/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.px;

import com.tridium.ui.PxIncludeManager;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.security.BPermissions;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxProperty;

public class BPxInclude
extends BWidget {
    public static final Property ord = BPxInclude.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property variables = BPxInclude.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Type TYPE = Sys.loadType(BPxInclude.class);
    private static final BIcon icon = BIcon.std((String)"widgets/px.png");
    private static final PxProperty[] noProps = new PxProperty[0];
    private static final BOrd[] noOrds = new BOrd[0];
    private boolean loading = false;
    private boolean loaded = false;
    private long lastModified;
    private BIFile pxFile;
    private BOrd baseOrd = null;
    private BOrd[] origOrds = noOrds;
    private Context cx;
    BWidget root = null;
    PxProperty[] props = noProps;
    private ReentrantLock lock = new ReentrantLock();
    private Condition loadCondition = this.lock.newCondition();

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public BFacets getVariables() {
        return (BFacets)this.get(variables);
    }

    public void setVariables(BFacets v) {
        this.set(variables, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void reload() {
        if (!this.loaded) {
            return;
        }
        this.loaded = false;
        this.root = null;
        this.props = noProps;
        this.origOrds = noOrds;
        this.pxFile = null;
        this.lastModified = 0L;
        if (this.get("root") != null) {
            this.remove("root");
        }
    }

    public BWidget getRootWidget() {
        return this.root;
    }

    public BOrd getBaseOrd() {
        return this.baseOrd;
    }

    public void setBaseOrd(BOrd baseOrd) {
        this.baseOrd = baseOrd;
    }

    public void sync() {
        if (this.loaded) {
            return;
        }
        if (this.lock.isHeldByCurrentThread()) {
            return;
        }
        this.lock.lock();
        try {
            this.load();
            while (!this.loaded) {
                try {
                    this.loadCondition.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void preLoad(BWidget root, PxProperty[] props, BOrd[] origOrds) {
    }

    protected void loaded() {
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == ord || prop == variables) {
            this.reload();
        }
    }

    @Override
    public void computePreferredSize() {
        if (!this.loaded) {
            this.load();
        } else if (this.root != null) {
            this.root.computePreferredSize();
            this.setPreferredSize(this.root.getPreferredWidth(), this.root.getPreferredHeight());
        }
    }

    @Override
    public void doLayout(BWidget[] kids) {
        if (!this.loaded) {
            this.load();
        } else if (this.root != null) {
            this.root.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void bindingsChanged() {
        for (int i = 0; i < this.props.length; ++i) {
            this.props[i].apply(this.root, this.get(this.props[i].getName()));
        }
    }

    private void load() {
        if (this.loaded || this.loading) {
            return;
        }
        this.loading = true;
        PxIncludeManager.load(this);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 205: {
                this.setBaseOrd((BOrd)a);
                if (b != null) {
                    this.cx = (Context)b;
                }
                return null;
            }
            case 304: {
                this.sync();
                return new Object[]{this.origOrds, this.props};
            }
            case 308: {
                if (this.isReloadRequired((Context)a)) {
                    return BBoolean.TRUE;
                }
                return BBoolean.FALSE;
            }
            case 307: {
                this.lock.lock();
                try {
                    if (a != null) {
                        this.root = (BWidget)a;
                        this.props = (PxProperty[])b;
                        this.origOrds = (BOrd[])c;
                        BIFile file = (BIFile)d;
                        if (file != null) {
                            this.pxFile = file;
                            this.lastModified = file.getLastModified().getMillis();
                        }
                        boolean add = true;
                        if (file != null && this.cx != null && this.cx.getUser() != null) {
                            add = file.getPermissions(this.cx).has(BPermissions.operatorRead);
                        }
                        if (add) {
                            this.preLoad(this.root, this.props, this.origOrds);
                            this.add("root", (BValue)this.root, 2);
                            this.bindingsChanged();
                            this.loaded();
                        }
                    }
                    this.loading = false;
                    this.loaded = true;
                    this.loadCondition.signalAll();
                    Object var6_6 = null;
                    return var6_6;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private boolean isReloadRequired(Context context) {
        boolean fileModified = this.pxFile != null && this.pxFile.getLastModified().getMillis() != this.lastModified;
        boolean userDegraded = false;
        if (context == null || context.getUser() == null) {
            return fileModified;
        }
        if (this.cx == null || context.getUser() != this.cx.getUser()) {
            this.cx = new BasicContext(context.getUser());
            userDegraded = this.pxFile != null && !this.pxFile.getPermissions(this.cx).has(BPermissions.operatorRead);
        }
        return fileModified || userDegraded;
    }
}

