/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.ScrollPaneTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;

public class BTextEditorPane
extends BScrollPane {
    public static final Property content = BTextEditorPane.newProperty((int)0, (BValue)new BTextEditor());
    public static final Property visibleRows = BTextEditorPane.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property visibleColumns = BTextEditorPane.newProperty((int)0, (int)40, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE = Sys.loadType(BTextEditorPane.class);

    public int getVisibleRows() {
        return this.getInt(visibleRows);
    }

    public void setVisibleRows(int v) {
        this.setInt(visibleRows, v, null);
    }

    public int getVisibleColumns() {
        return this.getInt(visibleColumns);
    }

    public void setVisibleColumns(int v) {
        this.setInt(visibleColumns, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTextEditorPane(String text, int visibleRows, int visibleColumns, boolean editable) {
        this(new BTextEditor(text, editable), visibleRows, visibleColumns);
    }

    public BTextEditorPane(int visibleRows, int visibleColumns) {
        this();
        this.setVisibleRows(visibleRows);
        this.setVisibleColumns(visibleColumns);
    }

    public BTextEditorPane(BTextEditor editor, int visibleRows, int visibleColumns) {
        this();
        this.setContent(editor);
        this.setVisibleRows(visibleRows);
        this.setVisibleColumns(visibleColumns);
    }

    public BTextEditorPane(BTextEditor editor) {
        this();
        this.setContent(editor);
    }

    public BTextEditorPane() {
        this.getHscrollBar().setSnapToUnitIncrement(true);
        this.getVscrollBar().setSnapToUnitIncrement(true);
    }

    public BTextEditor getEditor() {
        return (BTextEditor)this.getContent();
    }

    public String getText() {
        return this.getEditor().getText();
    }

    public void setText(String text) {
        this.getEditor().setText(text);
    }

    @Override
    public void computePreferredSize() {
        BInsets insets = this.theme().getInsets();
        double cellHeight = this.getEditor().getRenderer().getLineHeight();
        double cellWidth = this.getEditor().getRenderer().getColumnWidth(null, 0);
        double pw = cellWidth * (double)this.getVisibleColumns() + insets.left + insets.right;
        double ph = cellHeight * (double)this.getVisibleRows() + insets.top + insets.bottom;
        this.setPreferredSize(pw, ph);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        super.doLayout(kids);
        BTextEditor editor = this.getEditor();
        BInsets insets = this.theme().getInsets();
        double cellHeight = editor.getRenderer().getLineHeight();
        double cellWidth = editor.getRenderer().getColumnWidth(null, 0);
        int visibleLines = (int)((this.getHeight() - insets.top - insets.bottom) / cellHeight);
        int visibleColumns = (int)((this.getWidth() - insets.left - insets.right) / cellWidth);
        BScrollBar vsb = this.getVscrollBar();
        vsb.setUnitIncrement((int)cellHeight);
        vsb.setBlockIncrement((int)((double)(visibleLines - 1) * cellHeight));
        BScrollBar hsb = this.getHscrollBar();
        hsb.setUnitIncrement((int)cellWidth);
        hsb.setBlockIncrement((int)((double)(visibleColumns - 1) * cellHeight));
    }

    @Override
    ScrollPaneTheme theme() {
        return Theme.textEditorPane();
    }
}

