/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.TabbedPaneTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BLabelPaneContainer;

public class BTabbedPane
extends BLabelPaneContainer {
    public static final Property tabPlacement = BTabbedPane.newProperty((int)0, (BValue)BAlign.top, null);
    public static final Property showSingleTab = BTabbedPane.newProperty((int)0, (boolean)true, null);
    public static final Property tabControl = BTabbedPane.newProperty((int)6, (BValue)new BNullWidget(), null);
    public static final Property paintFullBorder = BTabbedPane.newProperty((int)0, (boolean)true, null);
    public static final Topic selectionModified = BTabbedPane.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BTabbedPane.class);
    private static final BIcon icon = BIcon.std((String)"widgets/tabbedPane.png");
    private static final String SELECTED_TAB_CLASS = "selected-tab";
    private static final String TAB_CLASS = "tab";
    private BLabelPane selection;
    private int fixedHeight;
    private int fixedWidth;
    private TabSupport support = new TabSupport();

    public BAlign getTabPlacement() {
        return (BAlign)this.get(tabPlacement);
    }

    public void setTabPlacement(BAlign v) {
        this.set(tabPlacement, (BValue)v, null);
    }

    public boolean getShowSingleTab() {
        return this.getBoolean(showSingleTab);
    }

    public void setShowSingleTab(boolean v) {
        this.setBoolean(showSingleTab, v, null);
    }

    public BWidget getTabControl() {
        return (BWidget)this.get(tabControl);
    }

    public void setTabControl(BWidget v) {
        this.set(tabControl, (BValue)v, null);
    }

    public boolean getPaintFullBorder() {
        return this.getBoolean(paintFullBorder);
    }

    public void setPaintFullBorder(boolean v) {
        this.setBoolean(paintFullBorder, v, null);
    }

    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTabbedPane(BAlign tabPlacement) {
        this.setTabPlacement(tabPlacement);
    }

    public BTabbedPane() {
    }

    private BLabelPane[] getLabelPanes() {
        BWidget[] widgets = this.getChildWidgets();
        Array visibleWidgets = new Array(BLabelPane.class);
        for (int i = 0; i < widgets.length; ++i) {
            if (!(widgets[i] instanceof BLabelPane) || !widgets[i].getVisible()) continue;
            visibleWidgets.add((Object)((BLabelPane)widgets[i]));
        }
        return (BLabelPane[])visibleWidgets.trim();
    }

    public BLabelPane getSelectedLabelPane() {
        if (this.selection == null) {
            return null;
        }
        if (!this.selection.isVisible()) {
            BLabelPane[] kids = this.getLabelPanes();
            if (kids.length > 0) {
                return kids[0];
            }
            return null;
        }
        return this.selection;
    }

    public BWidget getSelectedPane() {
        if (this.selection == null) {
            return null;
        }
        return this.selection.getContent();
    }

    public void selectLabelPane(BLabelPane pane) {
        this.setSelected(pane);
    }

    public void selectPane(BWidget content) {
        this.setSelected((BLabelPane)content.getParent());
    }

    public void setTabSupport(TabSupport support) {
        this.support = support;
    }

    public TabSupport getTabSupport() {
        return this.support;
    }

    public void setEnabledLabelPane(BLabelPane pane, boolean enabled) {
        if (pane == null) {
            return;
        }
        pane.setEnabled(enabled);
    }

    @Override
    public void computePreferredSize() {
        BLabelPane[] kids = this.getLabelPanes();
        if (kids.length == 0) {
            this.setPreferredSize(200.0, 200.0);
            return;
        }
        if (kids.length == 1 && !this.getShowSingleTab()) {
            BWidget w = kids[0].getContent();
            w.computePreferredSize();
            this.setPreferredSize(w.getPreferredWidth(), w.getPreferredHeight());
            return;
        }
        double w = 0.0;
        double h = 0.0;
        for (int i = 0; i < kids.length; ++i) {
            BWidget c = kids[i].getContent();
            c.computePreferredSize();
            w = Math.max(w, c.getPreferredWidth());
            h = Math.max(h, c.getPreferredHeight());
        }
        BAlign placement = this.tabPlacement();
        BInsets ti = Theme.tabbedPane().getTabInsets(placement);
        BInsets ci = Theme.tabbedPane().getContentInsets(placement, this.getPaintFullBorder());
        double lw = 0.0;
        double lh = 0.0;
        if (kids.length > 0) {
            BLabel label = kids[0].getLabel();
            label.computePreferredSize();
            lw = label.getPreferredWidth();
            lh = label.getPreferredHeight();
        }
        if (placement == BAlign.top || placement == BAlign.bottom) {
            h += ti.top + lh + ti.bottom;
        } else {
            w += ti.left + lw + ti.right;
        }
        this.setPreferredSize(w += ci.left + ci.right, h += ci.top + ci.bottom);
    }

    @Override
    public void doLayout(BWidget[] widgets) {
        Array visibleWidgets = new Array(BWidget.class);
        for (int i = 0; i < widgets.length; ++i) {
            if (!widgets[i].getVisible() && widgets[i].getType().is(BLabelPane.TYPE)) continue;
            visibleWidgets.add((Object)widgets[i]);
        }
        BWidget[] kids = (BWidget[])visibleWidgets.trim();
        BWidget control = this.getTabControl();
        if (this.selection == null) {
            if (kids.length == 1) {
                return;
            }
            this.setSelection((BLabelPane)kids[1]);
        }
        if (kids.length == 2 && !this.getShowSingleTab()) {
            kids[1].setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
            BWidget w = ((BLabelPane)kids[1]).getLabel();
            w.setVisible(false);
            w.setBounds(0.0, 0.0, 0.0, 0.0);
            w = ((BLabelPane)kids[1]).getContent();
            w.setVisible(true);
            w.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
            control.setBounds(0.0, 0.0, 0.0, 0.0);
            control.setVisible(false);
            return;
        }
        BAlign placement = this.tabPlacement();
        BInsets ti = Theme.tabbedPane().getTabInsets(placement);
        double w = this.getWidth();
        double h = this.getHeight();
        double x = 0.0;
        double y = 0.0;
        this.fixedWidth = 0;
        this.fixedHeight = 0;
        double cw = 0.0;
        double ch = 0.0;
        if (control instanceof BNullWidget) {
            control.setBounds(0.0, 0.0, 0.0, 0.0);
            control.setVisible(false);
        } else {
            control.computePreferredSize();
            cw = control.getPreferredWidth();
            ch = control.getPreferredHeight();
            double cx = 0.0;
            double cy = 0.0;
            switch (placement.getOrdinal()) {
                case 0: {
                    cx = w - cw;
                    break;
                }
                case 2: {
                    cx = w - cw;
                    cy = h - ch;
                    break;
                }
                case 1: {
                    cy = h - ch;
                    break;
                }
                case 3: {
                    cx = w - cw;
                    cy = h - ch;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            control.setBounds(cx, cy, cw, ch);
            control.setVisible(true);
            if (placement == BAlign.top || placement == BAlign.bottom) {
                this.fixedHeight = (int)ch;
            } else {
                this.fixedWidth = (int)cw;
            }
        }
        for (int i = 1; i < kids.length; ++i) {
            BLabelPane kid = (BLabelPane)kids[i];
            kid.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
            BWidget content = kid.getContent();
            content.setBounds(0.0, 0.0, 0.0, 0.0);
            content.setVisible(this.selection.getContent().equals(content));
            BLabel label = kid.getLabel();
            label.setVisible(true);
            label.computePreferredSize();
            double lw = label.getPreferredWidth();
            double lh = label.getPreferredHeight();
            double tw = lw + ti.left + ti.right;
            double th = lh + ti.top + ti.bottom;
            if (placement == BAlign.top || placement == BAlign.bottom) {
                if (x + tw > w - cw) {
                    y += 1.0;
                    x = 0.0;
                }
                label.setBounds(x + ti.left, y, lw, lh);
                x += tw;
                this.fixedHeight = (int)Math.max((double)this.fixedHeight, th);
                continue;
            }
            if (y + th > h - ch) {
                x += 1.0;
                y = 0.0;
            }
            label.setBounds(x, y + ti.top, lw, lh);
            y += th;
            this.fixedWidth = (int)Math.max((double)this.fixedWidth, tw);
        }
        int rowCount = (int)y + 1;
        int colCount = (int)x + 1;
        double tabAreaHeight = rowCount * this.fixedHeight;
        double tabAreaWidth = colCount * this.fixedWidth;
        BInsets ci = Theme.tabbedPane().getContentInsets(placement, this.getPaintFullBorder());
        switch (placement.getOrdinal()) {
            case 0: 
            case 2: {
                this.layoutRows(kids, rowCount);
                break;
            }
            case 1: 
            case 3: {
                this.layoutColumns(kids, colCount);
            }
        }
        for (int i = 1; i < kids.length; ++i) {
            BLabelPane kid = (BLabelPane)kids[i];
            BWidget content = kid.getContent();
            switch (placement.getOrdinal()) {
                case 0: {
                    content.setBounds(ci.left, tabAreaHeight + ci.top, w - ci.left - ci.right, h - tabAreaHeight - ci.top - ci.bottom);
                    break;
                }
                case 2: {
                    content.setBounds(ci.left, ci.top, w - ci.left - ci.right, h - tabAreaHeight - ci.top - ci.bottom);
                    break;
                }
                case 1: {
                    content.setBounds(ci.left + tabAreaWidth, ci.top, w - ci.left - ci.right - tabAreaWidth, h - ci.top - ci.bottom);
                    break;
                }
                case 3: {
                    content.setBounds(ci.left, ci.top, w - ci.left - ci.right - tabAreaWidth, h - ci.top - ci.bottom);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            kid.setBounds(0.0, 0.0, content.getWidth(), content.getHeight());
        }
    }

    private void layoutRows(BWidget[] kids, int rowCount) {
        int i;
        BInsets ti = Theme.tabbedPane().getTabInsets(this.tabPlacement());
        int[] tabsInRow = new int[rowCount];
        int[] rowTotal = new int[rowCount];
        int[] rowAdder = new int[rowCount];
        for (i = 1; i < kids.length; ++i) {
            BLabel label = ((BLabelPane)kids[i]).getLabel();
            int n = (int)label.getY();
            tabsInRow[n] = tabsInRow[n] + 1;
            int n2 = (int)label.getY();
            rowTotal[n2] = (int)((double)rowTotal[n2] + (label.getWidth() + ti.left + ti.right));
        }
        for (i = 0; i < rowCount - 1; ++i) {
            int div = tabsInRow[i];
            rowAdder[i] = div == 0 ? 0 : ((int)this.getWidth() - rowTotal[i]) / div;
        }
        int curRow = 0;
        int x = 0;
        int y = this.rowY(rowCount, curRow);
        for (int i2 = 1; i2 < kids.length; ++i2) {
            BLabel label = ((BLabelPane)kids[i2]).getLabel();
            if ((double)curRow != label.getY()) {
                if (i2 > 1) {
                    BLabel last = ((BLabelPane)kids[i2 - 1]).getLabel();
                    int toAdd = ((int)this.getWidth() - rowTotal[curRow]) % tabsInRow[curRow];
                    last.setSize(last.getWidth() + (double)toAdd, last.getHeight());
                }
                x = 0;
                y = this.rowY(rowCount, ++curRow);
            }
            int lx = x + (int)ti.left;
            int ly = y + (int)ti.top;
            int lw = (int)label.getWidth() + rowAdder[curRow];
            int lh = this.fixedHeight - (int)ti.top - (int)ti.bottom;
            label.setBounds(lx, ly, lw, lh);
            x = lx + lw + (int)ti.right;
        }
    }

    private int rowY(int rowCount, int row) {
        if (this.tabPlacement() == BAlign.top) {
            return (rowCount - row - 1) * this.fixedHeight;
        }
        return (int)this.getHeight() - (rowCount - row) * this.fixedHeight;
    }

    private void layoutColumns(BWidget[] kids, int colCount) {
        int i;
        BInsets ti = Theme.tabbedPane().getTabInsets(this.tabPlacement());
        int[] tabsInCol = new int[colCount];
        int[] colTotal = new int[colCount];
        int[] colAdder = new int[colCount];
        for (i = 1; i < kids.length; ++i) {
            BLabel label = ((BLabelPane)kids[i]).getLabel();
            int n = (int)label.getX();
            tabsInCol[n] = tabsInCol[n] + 1;
            int n2 = (int)label.getX();
            colTotal[n2] = (int)((double)colTotal[n2] + ((double)((int)label.getHeight()) + ti.top + ti.bottom));
        }
        for (i = 0; i < colCount - 1; ++i) {
            colAdder[i] = tabsInCol[i] == 0 ? 0 : ((int)this.getHeight() - colTotal[i]) / tabsInCol[i];
        }
        int curCol = 0;
        int x = this.colX(colCount, curCol);
        int y = 0;
        for (int i2 = 1; i2 < kids.length; ++i2) {
            BLabel label = ((BLabelPane)kids[i2]).getLabel();
            if ((double)curCol != label.getX()) {
                if (i2 > 1) {
                    BLabel last = ((BLabelPane)kids[i2 - 1]).getLabel();
                    int toAdd = ((int)this.getHeight() - colTotal[curCol]) % tabsInCol[curCol];
                    last.setSize((int)last.getWidth(), (int)last.getHeight() + toAdd);
                }
                x = this.colX(colCount, ++curCol);
                y = 0;
            }
            int lx = x + (int)ti.left;
            int ly = y + (int)ti.top;
            int lw = this.fixedWidth - (int)ti.left - (int)ti.right;
            int lh = (int)label.getHeight() + colAdder[curCol];
            label.setBounds(lx, ly, lw, lh);
            y = ly + lh + (int)ti.top;
        }
    }

    private int colX(int colCount, int col) {
        if (this.tabPlacement() == BAlign.left) {
            return (colCount - col - 1) * this.fixedWidth;
        }
        return (int)this.getWidth() - (colCount - col) * this.fixedWidth;
    }

    private void resetSelection() {
        int selectedIndex = -1;
        BWidget[] childWidgets = this.getChildWidgets();
        for (int i = 0; i < childWidgets.length; ++i) {
            if (this.selection != childWidgets[i]) continue;
            selectedIndex = i;
            break;
        }
        if (selectedIndex >= 0) {
            int desiredIndex = selectedIndex + 1;
            for (int i = 0; i < childWidgets.length; ++i) {
                BWidget kid = childWidgets[(desiredIndex + i) % childWidgets.length];
                if (!(kid instanceof BLabelPane) || !kid.isVisible()) continue;
                this.setSelected((BLabelPane)kid);
                break;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.selection == null) {
            return;
        }
        TabbedPaneTheme theme = Theme.tabbedPane();
        BAlign tabPlacement = this.tabPlacement();
        boolean fullBorder = this.getPaintFullBorder();
        theme.paintContentBackground(g, this, tabPlacement, this.selection.getContent(), fullBorder);
        BLabelPane[] kids = this.getLabelPanes();
        for (int i = kids.length - 1; i >= 0; --i) {
            if (!(kids[i] instanceof BLabelPane)) continue;
            BLabelPane kid = kids[i];
            BLabel label = kid.getLabel();
            boolean selected = this.selection == kid;
            theme.paintTabBackground(g, this, tabPlacement, label, selected, this.selection.getContent(), fullBorder);
            this.paintChild(g, label);
        }
        this.paintChild(g, this.getTabControl());
        if (!this.selection.isVisible()) {
            this.resetSelection();
        }
        if (this.getLabelPanes().length > 0) {
            this.paintChild(g, this.selection.getContent());
        } else {
            this.paintChild(g, new BLabelPane());
        }
    }

    @Override
    public String getStyleSelector() {
        return "pane tabbed-pane";
    }

    @Override
    public BWidget childAt(Point pt) {
        BWidget c;
        if (this.selection != null && (c = this.selection.getContent()).contains(pt.x - c.getX(), pt.y - c.getY())) {
            return c;
        }
        c = this.getTabControl();
        if (c.contains(pt.x - c.getX(), pt.y - c.getY())) {
            return c;
        }
        return null;
    }

    public void added(Property prop, Context ctx) {
        super.added(prop, ctx);
        BValue value = this.get(prop);
        if (value instanceof BLabelPane) {
            BLabelPane pane = (BLabelPane)value;
            if (this.selection == null && pane.getEnabled() && pane.isVisible()) {
                this.setSelection(pane);
            } else {
                this.updateTabFromTheme(pane, pane == this.selection);
            }
        }
    }

    private void setSelected(BLabelPane tab) {
        if (this.selection == tab) {
            return;
        }
        this.setSelection(tab);
        this.relayout();
        if (!this.hasFocus()) {
            BWidget w = this.selection.getContent();
            this.giveFocus(w);
        }
        this.fireSelectionModified(new BWidgetEvent(1, this));
        this.selectionModified(tab);
    }

    private void setSelection(BLabelPane tab) {
        this.updateTabFromTheme(this.selection, false);
        this.updateTabFromTheme(tab, true);
        this.selection = tab;
    }

    private void updateTabFromTheme(BLabelPane tab, boolean isSelected) {
        if (tab == null) {
            return;
        }
        BLabel label = tab.getLabel();
        label.setFlags((Slot)BWidget.styleClasses, label.getFlags((Slot)BWidget.styleClasses) | 2);
        if (isSelected) {
            label.setStyleClasses(SELECTED_TAB_CLASS);
        } else {
            label.setStyleClasses(TAB_CLASS);
        }
    }

    protected void selectionModified(BLabelPane tab) {
        if (!tab.isVisible()) {
            BLabelPane[] children = this.getLabelPanes();
            for (int i = 0; i < children.length; ++i) {
                BLabelPane child;
                if (!(children[i] instanceof BLabelPane) || !(child = children[i]).isVisible()) continue;
                this.setSelection(child);
                return;
            }
        }
    }

    private boolean giveFocus(BWidget w) {
        if (w.isFocusTraversable()) {
            w.requestFocus();
            return true;
        }
        BWidget[] kids = w.getChildWidgets();
        for (int i = 1; i < kids.length; ++i) {
            if (!this.giveFocus(kids[i])) continue;
            return true;
        }
        return false;
    }

    protected BLabelPane tabAt(double x, double y) {
        RectGeom r = new RectGeom();
        BInsets ti = Theme.tabbedPane().getTabInsets(this.tabPlacement());
        BLabelPane[] kids = this.getLabelPanes();
        for (int i = 0; i < kids.length; ++i) {
            BLabel label = kids[i].getLabel();
            r.x = label.getX() - ti.left;
            r.y = label.getY() - ti.top;
            r.width = label.getWidth() + ti.left + ti.right;
            r.height = label.getHeight() + ti.top + ti.bottom;
            if (!r.contains(x, y)) continue;
            return kids[i];
        }
        return null;
    }

    private void traverseLeft() {
        BLabelPane[] kids = this.getLabelPanes();
        int oldIndex = -1;
        for (int i = 0; i < kids.length; ++i) {
            if (this.selection != kids[i]) continue;
            oldIndex = i;
            break;
        }
        if (oldIndex == -1) {
            return;
        }
        int newIndex = oldIndex - 1;
        if (newIndex < 0) {
            newIndex = kids.length - 1;
        }
        for (int i = 1; i < kids.length; ++i) {
            if (kids[newIndex].getEnabled()) {
                this.selectLabelPane(kids[newIndex]);
                return;
            }
            if (--newIndex >= 0) continue;
            newIndex = kids.length - 1;
        }
    }

    private void traverseRight() {
        BLabelPane[] kids = this.getLabelPanes();
        int oldIndex = -1;
        for (int i = 0; i < kids.length; ++i) {
            if (this.selection != kids[i]) continue;
            oldIndex = i;
            break;
        }
        if (oldIndex == -1) {
            return;
        }
        int newIndex = oldIndex + 1;
        if (newIndex == kids.length) {
            newIndex = 0;
        }
        for (int i = 1; i < kids.length; ++i) {
            if (kids[newIndex].getEnabled()) {
                this.selectLabelPane(kids[newIndex]);
                return;
            }
            if (newIndex == kids.length - 1) {
                newIndex = 0;
                continue;
            }
            ++newIndex;
        }
    }

    public boolean isAnyTabEnabled() {
        BLabelPane[] kids = this.getLabelPanes();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].getEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void focusGained(BFocusEvent event) {
        this.repaint();
    }

    @Override
    public void focusLost(BFocusEvent event) {
        this.repaint();
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        if (event.getKeyCode() == 37) {
            event.consume();
            this.traverseLeft();
        } else if (event.getKeyCode() == 39) {
            event.consume();
            this.traverseRight();
        }
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        BLabelPane tab = this.tabAt(event.getX(), event.getY());
        if (tab != null) {
            if (!tab.getEnabled()) {
                return;
            }
            if (event.isPopupTrigger()) {
                this.support.tabPopup(tab, event);
            } else if (event.isButton1Down()) {
                this.setSelected(tab);
            }
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        BLabelPane tab = this.tabAt(event.getX(), event.getY());
        if (tab != null) {
            if (!tab.getEnabled()) {
                return;
            }
            if (event.isPopupTrigger()) {
                this.support.tabPopup(tab, event);
            }
        }
    }

    private BAlign tabPlacement() {
        BAlign placement = this.getTabPlacement();
        if (placement == BAlign.center) {
            placement = BAlign.top;
        }
        return placement;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public static class TabSupport {
        public void tabPopup(BLabelPane tab, BMouseEvent event) {
        }
    }
}

