/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.ScrollPaneTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BPane;

public class BScrollPane
extends BPane {
    public static final Property content = BScrollPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property hscrollBar = BScrollPane.newProperty((int)7, (BValue)new BScrollBar(BOrientation.horizontal, 15, 150, false), null);
    public static final Property vscrollBar = BScrollPane.newProperty((int)7, (BValue)new BScrollBar(BOrientation.vertical, 15, 150, false), null);
    public static final Property hpolicy = BScrollPane.newProperty((int)0, (BValue)BScrollBarPolicy.asNeeded, null);
    public static final Property vpolicy = BScrollPane.newProperty((int)0, (BValue)BScrollBarPolicy.asNeeded, null);
    public static final Property viewportBackground = BScrollPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property borderPolicy = BScrollPane.newProperty((int)0, (BValue)BScrollBarPolicy.always, null);
    public static final Action hscroll = BScrollPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Action vscroll = BScrollPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Type TYPE = Sys.loadType(BScrollPane.class);
    private static final BIcon icon = BIcon.std((String)"widgets/scrollPane.png");
    protected RectGeom viewport = new RectGeom();
    private RectGeom scrollTo;
    private boolean vsbShow = false;
    private boolean hsbShow = false;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public BScrollBar getHscrollBar() {
        return (BScrollBar)this.get(hscrollBar);
    }

    public void setHscrollBar(BScrollBar v) {
        this.set(hscrollBar, (BValue)v, null);
    }

    public BScrollBar getVscrollBar() {
        return (BScrollBar)this.get(vscrollBar);
    }

    public void setVscrollBar(BScrollBar v) {
        this.set(vscrollBar, (BValue)v, null);
    }

    public BScrollBarPolicy getHpolicy() {
        return (BScrollBarPolicy)this.get(hpolicy);
    }

    public void setHpolicy(BScrollBarPolicy v) {
        this.set(hpolicy, (BValue)v, null);
    }

    public BScrollBarPolicy getVpolicy() {
        return (BScrollBarPolicy)this.get(vpolicy);
    }

    public void setVpolicy(BScrollBarPolicy v) {
        this.set(vpolicy, (BValue)v, null);
    }

    public BBrush getViewportBackground() {
        return (BBrush)this.get(viewportBackground);
    }

    public void setViewportBackground(BBrush v) {
        this.set(viewportBackground, (BValue)v, null);
    }

    public BScrollBarPolicy getBorderPolicy() {
        return (BScrollBarPolicy)this.get(borderPolicy);
    }

    public void setBorderPolicy(BScrollBarPolicy v) {
        this.set(borderPolicy, (BValue)v, null);
    }

    public void hscroll(BScrollEvent event) {
        this.invoke(hscroll, (BValue)event, null);
    }

    public void vscroll(BScrollEvent event) {
        this.invoke(vscroll, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BScrollPane(BWidget content) {
        this();
        this.setContent(content);
    }

    public BScrollPane() {
        this.linkTo(this.getHscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)hscroll);
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    public void started() throws Exception {
        this.linkTo(this.getHscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)hscroll);
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    public RectGeom getViewport() {
        return new RectGeom((IRectGeom)this.viewport);
    }

    @Override
    public BWidget childAt(Point pt) {
        BInsets insets = this.theme().getInsets();
        if (pt.x - insets.left < this.viewport.width && pt.y - insets.top < this.viewport.height) {
            return this.getContent();
        }
        BScrollBar hsb = this.getHscrollBar();
        if (hsb.contains(pt.x - hsb.getX(), pt.y - hsb.getY())) {
            return hsb;
        }
        BScrollBar vsb = this.getVscrollBar();
        if (vsb.contains(pt.x - vsb.getX(), pt.y - vsb.getY())) {
            return vsb;
        }
        return null;
    }

    @Override
    public Point translateToChild(BWidget child, Point pt) {
        if (child == this.getContent()) {
            BInsets insets = this.theme().getInsets();
            pt.translate(this.viewport.x - insets.left, this.viewport.y - insets.top);
            return pt;
        }
        return super.translateToChild(child, pt);
    }

    @Override
    public void computePreferredSize() {
        BInsets insets = this.theme().getInsets();
        BWidget c = this.getContent();
        c.computePreferredSize();
        double w = c.getPreferredWidth() + insets.left + insets.right;
        double h = c.getPreferredHeight() + insets.top + insets.bottom;
        this.setPreferredSize(w, h);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        BWidget c = this.getContent();
        if (c == null) {
            return;
        }
        BInsets insets = this.theme().getInsets(this);
        double w = this.getWidth() - insets.left - insets.right;
        double h = this.getHeight() - insets.top - insets.bottom;
        c.computePreferredSize();
        double cw = c.getPreferredWidth();
        double ch = c.getPreferredHeight();
        BScrollBar hsb = this.getHscrollBar();
        BScrollBar vsb = this.getVscrollBar();
        BScrollBarPolicy hPolicy = this.getHpolicy();
        BScrollBarPolicy vPolicy = this.getVpolicy();
        hsb.computePreferredSize();
        vsb.computePreferredSize();
        this.hsbShow = false;
        switch (hPolicy.getOrdinal()) {
            case 0: {
                this.hsbShow = cw > w;
                break;
            }
            case 1: {
                this.hsbShow = true;
                break;
            }
            case 2: {
                this.hsbShow = false;
            }
        }
        this.vsbShow = false;
        switch (vPolicy.getOrdinal()) {
            case 0: {
                this.vsbShow = ch > h;
                break;
            }
            case 1: {
                this.vsbShow = true;
                break;
            }
            case 2: {
                this.vsbShow = false;
            }
        }
        if (hPolicy == BScrollBarPolicy.asNeeded && this.vsbShow) {
            boolean bl = this.hsbShow = cw > w - vsb.getPreferredWidth();
        }
        if (vPolicy == BScrollBarPolicy.asNeeded && this.hsbShow) {
            boolean bl = this.vsbShow = ch > h - hsb.getPreferredHeight();
        }
        if (hPolicy == BScrollBarPolicy.asNeeded && this.vsbShow) {
            boolean bl = this.hsbShow = cw > w - vsb.getPreferredWidth();
        }
        if (!this.hsbShow) {
            hsb.setBounds(0.0, 0.0, 0.0, 0.0);
        } else {
            double hsbWidth = this.vsbShow ? w - vsb.getPreferredWidth() : w;
            double hsbHeight = hsb.getPreferredHeight();
            hsb.setBounds(insets.left, h - hsbHeight + insets.top, hsbWidth, hsbHeight);
            hsb.setMin(0);
            hsb.setMax((int)cw);
            hsb.setExtent((int)Math.min(cw, w - (this.vsbShow ? vsb.getPreferredWidth() : 0.0)));
            if ((double)hsb.getPosition() > cw - (double)hsb.getExtent()) {
                this.viewport.x = cw - (double)hsb.getExtent();
                hsb.setPosition((int)this.viewport.x);
            } else {
                this.viewport.x = hsb.getPosition();
            }
        }
        if (!this.vsbShow) {
            vsb.setBounds(0.0, 0.0, 0.0, 0.0);
        } else {
            double vsbWidth = vsb.getPreferredWidth();
            double vsbHeight = this.hsbShow ? h - hsb.getPreferredHeight() : h;
            vsb.setBounds(w - vsbWidth + insets.right, insets.top, vsbWidth, vsbHeight);
            vsb.setMin(0);
            vsb.setMax((int)ch);
            vsb.setExtent((int)Math.min(ch, h - hsb.getHeight()));
            if ((double)vsb.getPosition() > ch - (double)vsb.getExtent()) {
                this.viewport.y = ch - (double)vsb.getExtent();
                vsb.setPosition((int)this.viewport.y);
            } else {
                this.viewport.y = vsb.getPosition();
            }
        }
        this.viewport.width = this.vsbShow ? w - vsb.getWidth() : w;
        double d = this.viewport.height = this.hsbShow ? h - hsb.getHeight() : h;
        if (this.viewport.width < 0.0) {
            this.viewport.x = 0.0;
            hsb.setPosition(0);
        } else if (this.viewport.width > cw) {
            this.viewport.x = 0.0;
            cw = this.viewport.width;
        }
        if (this.viewport.height < 0.0) {
            this.viewport.y = 0.0;
            vsb.setPosition(0);
        } else if (this.viewport.height > ch) {
            this.viewport.y = 0.0;
            ch = this.viewport.height;
        }
        c.setBounds(0.0, 0.0, cw, ch);
        if (this.scrollTo != null) {
            this.scrollToVisible(this.scrollTo);
            this.scrollTo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        BInsets insets = this.theme().getInsets();
        BWidget c = this.getContent();
        BScrollBar hsb = this.getHscrollBar();
        BScrollBar vsb = this.getVscrollBar();
        double itx = insets.left;
        double ity = insets.top;
        g.translate(itx, ity);
        IRectGeom clip = g.getClipBounds();
        BBrush bg = this.getViewportBackground();
        if (bg.isNull()) {
            g.setBrush(this.theme().getWindowBackground(this));
        } else {
            g.setBrush(bg);
        }
        g.fill((IGeom)clip);
        if (clip.intersects(0.0, 0.0, this.viewport.width, this.viewport.height)) {
            g.push();
            try {
                double vtx = this.viewport.x;
                double vty = this.viewport.y;
                g.clip(0.0, 0.0, this.viewport.width, this.viewport.height);
                g.translate(-vtx, -vty);
                c.paint(g);
            }
            finally {
                g.pop();
            }
        }
        if (hsb.getHeight() > 0.0 && vsb.getWidth() > 0.0) {
            g.setBrush(this.theme().getControlBackground());
            g.fillRect(hsb.getWidth(), vsb.getHeight(), vsb.getWidth(), hsb.getHeight());
        }
        g.translate(-itx, -ity);
        if (this.hsbShow) {
            this.paintChild(g, hsb);
        }
        if (this.vsbShow) {
            this.paintChild(g, vsb);
        }
        if (this.getBorderPolicy() == BScrollBarPolicy.always || this.getBorderPolicy() == BScrollBarPolicy.asNeeded && (this.vsbShow || this.hsbShow)) {
            this.theme().paintBorder(g, this);
        }
    }

    public void doHscroll(BScrollEvent event) {
        this.viewport.x = event.getPosition();
        this.repaint();
    }

    public void doVscroll(BScrollEvent event) {
        this.viewport.y = event.getPosition();
        this.repaint();
    }

    @Override
    public void scrollToVisible(RectGeom rect) {
        BScrollBar hsb = this.getHscrollBar();
        BScrollBar vsb = this.getVscrollBar();
        BWidget c = this.getContent();
        if (this.viewport.width == 0.0) {
            this.scrollTo = rect;
            return;
        }
        if (this.viewport.contains((IGeom)rect)) {
            return;
        }
        double cx1 = this.viewport.x;
        double cx2 = cx1 + this.viewport.width;
        double cy1 = this.viewport.y;
        double cy2 = cy1 + this.viewport.height;
        double dx1 = rect.x;
        double dx2 = dx1 + rect.width;
        double dy1 = rect.y;
        double dy2 = dy1 + rect.height;
        if (cx2 < dx2) {
            cx1 += dx2 - cx2;
        }
        if (cy2 < dy2) {
            cy1 += dy2 - cy2;
        }
        if (cx1 > dx1) {
            cx1 = dx1;
        }
        if (cy1 > dy1) {
            cy1 = dy1;
        }
        if (cx1 + this.viewport.width > c.getWidth()) {
            cx1 = c.getWidth() - this.viewport.width;
        }
        if (cy1 + this.viewport.height > c.getHeight()) {
            cy1 = c.getHeight() - this.viewport.height;
        }
        if (cx1 < 0.0) {
            cx1 = 0.0;
        }
        if (cy1 < 0.0) {
            cy1 = 0.0;
        }
        this.viewport.x = cx1;
        this.viewport.y = cy1;
        hsb.resetPosition((int)cx1, 602);
        vsb.resetPosition((int)cy1, 602);
    }

    public boolean pulseViewport(Point contentPt, double pulsePixels) {
        double edge;
        Point pt = this.translateFromChild(this.getContent(), new Point((IPoint)contentPt));
        double x = pt.x;
        double y = pt.y;
        if (!this.contains(x, y)) {
            return false;
        }
        double left = edge = 16.0;
        double right = this.getWidth() - edge - this.getVscrollBar().getWidth();
        double top = edge;
        double bottom = this.getHeight() - edge - this.getHscrollBar().getHeight();
        double dx = 0.0;
        double dy = 0.0;
        if (x < left) {
            dx = -pulsePixels;
        } else if (x > right) {
            dx = pulsePixels;
        }
        if (y < top) {
            dy = -pulsePixels;
        } else if (y > bottom) {
            dy = pulsePixels;
        }
        if (dx != 0.0 || dy != 0.0) {
            RectGeom viewport = this.getViewport();
            viewport.x += dx;
            viewport.y += dy;
            this.scrollToVisible(viewport);
            return true;
        }
        return false;
    }

    @Override
    public void mouseWheel(BMouseWheelEvent event) {
        BScrollBar sb = this.getVscrollBar();
        if (!sb.isVisible() || sb.getWidth() == 0.0) {
            return;
        }
        int wheelUnits = this.getWheelUnits();
        sb.scrollByUnits(event.getPreciseWheelRotation() * (double)wheelUnits);
        event.consume();
    }

    protected int getWheelUnits() {
        return 3;
    }

    ScrollPaneTheme theme() {
        return Theme.scrollPane();
    }

    @Override
    public String getStyleSelector() {
        return "pane scroll-pane";
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

