/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.list.ListSubject;
import javax.baja.ui.util.UiLexicon;

public class BCheckList
extends BList {
    static final BImage DEFAULT_SELECTED_ICON = BImage.make((String)"module://icons/x16/check.png");
    public static final Property selectedIcon = BCheckList.newProperty((int)0, (BValue)DEFAULT_SELECTED_ICON, null);
    public static final Property unselectedIcon = BCheckList.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Type TYPE = Sys.loadType(BCheckList.class);
    private double hgap = 4.0;

    public BImage getSelectedIcon() {
        return (BImage)this.get(selectedIcon);
    }

    public void setSelectedIcon(BImage v) {
        this.set(selectedIcon, (BValue)v, null);
    }

    public BImage getUnselectedIcon() {
        return (BImage)this.get(unselectedIcon);
    }

    public void setUnselectedIcon(BImage v) {
        this.set(unselectedIcon, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCheckList() {
        this.setController(new CheckListController());
        this.setRenderer(new CheckListRenderer());
    }

    public static class CheckListRenderer
    extends ListRenderer {
        @Override
        public BBrush getSelectionForeground(ListRenderer.Item item) {
            return this.getForeground(item);
        }

        @Override
        public BBrush getSelectionBackground(ListRenderer.Item item) {
            return this.getBackground(item);
        }

        @Override
        public double getPreferredItemWidth(ListRenderer.Item item) {
            BCheckList cl = (BCheckList)this.getList();
            double w = super.getPreferredItemWidth(item) + Math.max(cl.getSelectedIcon().getWidth(), cl.getUnselectedIcon().getHeight()) + cl.hgap;
            return w;
        }

        @Override
        public void paintItem(Graphics g, ListRenderer.Item item) {
            BImage icon;
            this.paintItemBackground(g, item);
            BCheckList list = (BCheckList)this.getList();
            double inset = Math.max(list.getSelectedIcon().getWidth(), list.getUnselectedIcon().getWidth()) + list.hgap;
            g.translate(inset, 0.0);
            super.paintItem(g, item);
            g.translate(-inset, 0.0);
            BImage bImage = icon = item.selected ? list.getSelectedIcon() : list.getUnselectedIcon();
            if (!icon.isNull()) {
                g.drawImage(icon, 2.0, 0.0);
            }
        }
    }

    public static class DeselectAllCommand
    extends Command {
        DeselectAllCommand(BList list) {
            super((BWidget)list, UiLexicon.bajaui().module, "commands.deselectAll");
        }

        @Override
        public CommandArtifact doInvoke() {
            ((BList)this.getOwner()).getSelection().deselectAll();
            return null;
        }
    }

    public static class SelectAllCommand
    extends Command {
        SelectAllCommand(BList list) {
            super((BWidget)list, UiLexicon.bajaui().module, "commands.selectAll");
        }

        @Override
        public CommandArtifact doInvoke() {
            ((BList)this.getOwner()).getSelection().selectAll();
            return null;
        }
    }

    public static class CheckListController
    extends ListController {
        @Override
        public void focusGained(BFocusEvent event) {
        }

        @Override
        protected void itemPressed(BMouseEvent event, int index) {
            if (event.isPopupTrigger()) {
                this.itemPopup(event, index);
            }
        }

        @Override
        protected void itemReleased(BMouseEvent event, int index) {
            if (event.isPopupTrigger()) {
                this.itemPopup(event, index);
            } else {
                ListSelection sel = this.list.getSelection();
                if (sel.isSelected(index)) {
                    sel.deselect(index);
                } else {
                    sel.select(index);
                }
            }
        }

        @Override
        protected void backgroundPressed(BMouseEvent event) {
            if (event.isPopupTrigger()) {
                this.backgroundPopup(event);
            }
        }

        @Override
        protected BMenu makePopup(ListSubject subject) {
            BMenu menu = new BMenu();
            menu.add(null, new SelectAllCommand(this.getList()));
            menu.add(null, new DeselectAllCommand(this.getList()));
            return menu;
        }
    }
}

