/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.ShellPeer;
import com.tridium.ui.UiEnv;
import com.tridium.ui.WindowPeer;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;

public class BRoundedWindow
extends BWindow {
    public static final Action handleMouseEvent = BRoundedWindow.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BRoundedWindow.class);
    protected static final float DEFAULT_ARC_WIDTH = 10.0f;
    protected static final float DEFAULT_ARC_HEIGHT = 10.0f;
    private BWidget owner;
    protected float arcWidth = 10.0f;
    protected float arcHeight = 10.0f;
    private Point pressed;
    private BInsets dragInsets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);

    public void handleMouseEvent(BMouseEvent event) {
        this.invoke(handleMouseEvent, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRoundedWindow(BWidget owner, BWidget content) {
        this(owner, content, 10.0f, 10.0f);
    }

    public BRoundedWindow(BWidget owner, BWidget content, float arcWidth, float arcHeight) {
        super(UiEnv.get().makeRoundedWindowPeer(owner, arcWidth, arcHeight));
        this.setContent(content);
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public BRoundedWindow(BWidget owner) {
        super(UiEnv.get().makeRoundedWindowPeer(owner, 10.0f, 10.0f));
    }

    public BRoundedWindow(BWidget owner, float arcWidth, float arcHeight) {
        super(UiEnv.get().makeRoundedWindowPeer(owner, arcWidth, arcHeight));
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public BRoundedWindow() {
        super(UiEnv.get().makeRoundedWindowPeer(null, 10.0f, 10.0f));
    }

    BRoundedWindow(WindowPeer peer) {
        super(peer);
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public float getArcWidth() {
        return this.arcWidth;
    }

    public float getArcHeight() {
        return this.arcHeight;
    }

    @Override
    public void handleEscape() {
        this.windowClosing(null);
    }

    public void setBoundsCenteredOnOwner() {
        try {
            ShellPeer peer = this.getOwner().getShell().getShellPeer();
            this.setBoundsCenteredOn(peer.getScreenBounds());
        }
        catch (RuntimeException e) {
            this.setBoundsCenteredOnScreen();
        }
    }

    @Override
    public void setBoundsCenteredOn(IRectGeom rect) {
        Insets insets = UiEnv.get().getWindowInsets(this);
        this.computePreferredSize();
        double w = this.getPreferredWidth() + insets.left + insets.right;
        double h = this.getPreferredHeight() + insets.top + insets.bottom;
        double x = rect.x() + (rect.width() - w) / 2.0;
        double y = rect.y() + (rect.height() - h) / 2.0;
        IRectGeom screen = UiEnv.get().getScreenBounds(this);
        double sx = screen.x();
        double sy = screen.y();
        double sw = screen.width();
        double sh = screen.height();
        if (w > sw) {
            w = sw;
        }
        if (h > sh) {
            h = sh;
        }
        if (x + w > sx + sw) {
            x = sx + sw - w;
        }
        if (y + h > sy + sh) {
            y = sh - h;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < sy) {
            y = sy;
        }
        this.setScreenBounds(x, y, w, h);
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    @Override
    public void mouseDragged(BMouseEvent e) {
        if (null == this.pressed) {
            return;
        }
        Point absMousePos = this.translateToScreen(new Point(e.getX(), e.getY()));
        RectGeom rect = new RectGeom(absMousePos.x - this.pressed.x, absMousePos.y - this.pressed.y, this.getWidth(), this.getHeight());
        this.setScreenBounds(rect.x(), rect.y(), rect.width(), rect.height());
    }

    @Override
    public void mousePressed(BMouseEvent e) {
        double height;
        double width = this.getWidth() - this.dragInsets.left - this.dragInsets.right;
        RectGeom rect = new RectGeom(this.dragInsets.left, this.dragInsets.top, width, height = this.getHeight() - this.dragInsets.top - this.dragInsets.bottom);
        if (rect.contains(e.getX(), e.getY())) {
            this.pressed = new Point(e.getX(), e.getY());
            e.getWidget().setMouseCursor(MouseCursor.grabHand);
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        event.getWidget().setMouseCursor(MouseCursor.normal);
    }

    public void doHandleMouseEvent(BMouseEvent event) {
        this.fireMouseEvent(event);
    }
}

