/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.Theme;
import java.text.DecimalFormat;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;

public class BProgressBar
extends BWidget {
    public static final Property min = BProgressBar.newProperty((int)0, (int)0, null);
    public static final Property max = BProgressBar.newProperty((int)0, (int)100, null);
    public static final Property textPattern = BProgressBar.newProperty((int)0, (String)"#%", null);
    public static final Property textFont = BProgressBar.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property backgroundBrush = BProgressBar.newProperty((int)0, (BValue)BColor.white.toBrush(), null);
    public static final Property barBrush = BProgressBar.newProperty((int)0, (BValue)BColor.gray.toBrush(), null);
    public static final Property indeterminate = BProgressBar.newProperty((int)0, (boolean)false, null);
    public static final Topic valueChanged = BProgressBar.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BProgressBar.class);
    private double value;
    private int inOff = 0;

    public double getMin() {
        return this.getDouble(min);
    }

    public void setMin(double v) {
        this.setDouble(min, v, null);
    }

    public double getMax() {
        return this.getDouble(max);
    }

    public void setMax(double v) {
        this.setDouble(max, v, null);
    }

    public String getTextPattern() {
        return this.getString(textPattern);
    }

    public void setTextPattern(String v) {
        this.setString(textPattern, v, null);
    }

    public BFont getTextFont() {
        return (BFont)this.get(textFont);
    }

    public void setTextFont(BFont v) {
        this.set(textFont, (BValue)v, null);
    }

    public BBrush getBackgroundBrush() {
        return (BBrush)this.get(backgroundBrush);
    }

    public void setBackgroundBrush(BBrush v) {
        this.set(backgroundBrush, (BValue)v, null);
    }

    public BBrush getBarBrush() {
        return (BBrush)this.get(barBrush);
    }

    public void setBarBrush(BBrush v) {
        this.set(barBrush, (BValue)v, null);
    }

    public boolean getIndeterminate() {
        return this.getBoolean(indeterminate);
    }

    public void setIndeterminate(boolean v) {
        this.setBoolean(indeterminate, v, null);
    }

    public void fireValueChanged(BWidgetEvent event) {
        this.fire(valueChanged, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BProgressBar() {
    }

    public BProgressBar(double min, double max) {
        this();
        this.setMin(min);
        this.setMax(max);
    }

    @Override
    public void computePreferredSize() {
        this.setPreferredSize(200.0, 20.0);
    }

    @Override
    public void animate() {
        if (this.getIndeterminate()) {
            this.inOff += 4;
            if (this.inOff >= 16) {
                this.inOff = 0;
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        int pw = 0;
        BBrush bg = this.getBackgroundBrush();
        BBrush fg = this.getBarBrush();
        g.setBrush(bg);
        g.fillRect(0.0, 0.0, w, h);
        if (this.getIndeterminate()) {
            g.setBrush(fg);
            int i = -((int)(h + 16.0));
            while ((double)i < w) {
                int x = i + this.inOff;
                g.strokeLine((double)x, h, (double)x + h, 0.0);
                g.strokeLine((double)(x + 1), h, (double)x + h + 1.0, 0.0);
                g.strokeLine((double)(x + 2), h, (double)x + h + 2.0, 0.0);
                g.strokeLine((double)(x + 3), h, (double)x + h + 3.0, 0.0);
                g.strokeLine((double)(x + 4), h, (double)x + h + 4.0, 0.0);
                g.strokeLine((double)(x + 5), h, (double)x + h + 5.0, 0.0);
                g.strokeLine((double)(x + 6), h, (double)x + h + 6.0, 0.0);
                g.strokeLine((double)(x + 7), h, (double)x + h + 7.0, 0.0);
                g.strokeLine((double)(x + 8), h, (double)x + h + 8.0, 0.0);
                i += 16;
            }
        } else {
            pw = (int)(this.getPercentComplete() * w);
            g.setBrush(fg);
            g.fillRect(0.0, 0.0, (double)pw, h);
        }
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        if (this.getIndeterminate()) {
            return;
        }
        String pattern = this.getTextPattern();
        if (!pattern.equals("")) {
            DecimalFormat df = new DecimalFormat(pattern);
            String text = df.format(this.getPercentComplete());
            BFont font = this.getTextFont();
            if (font.isNull()) {
                font = Theme.label().getTextFont();
            }
            g.setFont(font);
            double fontHeight = font.getHeight();
            double fontDescent = font.getDescent();
            double textWidth = font.width(text);
            double tx = (w - textWidth) / 2.0;
            double ty = (h - fontHeight) / 2.0;
            g.push();
            try {
                g.clip(0.0, 0.0, (double)pw, h);
                g.setBrush(bg);
                g.drawString(text, tx, ty + fontHeight - fontDescent);
            }
            finally {
                g.pop();
            }
            g.push();
            try {
                g.clip((double)pw, 0.0, w - (double)pw, h);
                g.setBrush(fg);
                g.drawString(text, tx, ty + fontHeight - fontDescent);
            }
            finally {
                g.pop();
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double v) {
        if (v < this.getMin()) {
            v = this.getMin();
        } else if (v > this.getMax()) {
            v = this.getMax();
        }
        this.value = v;
        this.fireValueChanged(null);
        this.repaint();
    }

    public double getPercentComplete() {
        return (this.getValue() - this.getMin()) / (this.getMax() - this.getMin());
    }
}

