/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenuItem;

public abstract class BMenuItem
extends BWidget
implements BIMenuItem {
    public static final Property text = BMenuItem.newProperty((int)0, (String)"", null);
    public static final Property image = BMenuItem.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property accelerator = BMenuItem.newProperty((int)0, (BValue)BAccelerator.NULL, null);
    public static final Type TYPE = Sys.loadType(BMenuItem.class);
    private static final BIcon icon = BIcon.std((String)"widgets/menuItem.png");
    static Object timerLock = new Object();
    static Timer timer;
    static BMenuItem timed;
    char shortcut = '\u0000';
    double baseline;
    double textWidth;
    double acceleratorWidth;
    double acceleratorX;
    boolean showAccelerator;
    boolean isSelected;
    Command command;
    boolean isOver;

    @Override
    public String getText() {
        return this.getString(text);
    }

    public void setText(String v) {
        this.setString(text, v, null);
    }

    @Override
    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    @Override
    public BAccelerator getAccelerator() {
        return (BAccelerator)this.get(accelerator);
    }

    public void setAccelerator(BAccelerator v) {
        this.set(accelerator, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BMenuItem(String text, BAccelerator accelerator) {
        this.setText(text);
        this.setAccelerator(accelerator);
    }

    public BMenuItem(String text) {
        this.setText(text);
    }

    public BMenuItem(Command command) {
        this.setCommand(command);
    }

    public BMenuItem() {
    }

    @Override
    public BWidget asWidget() {
        return this;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.setCommand(command, true, true, true);
    }

    public void setCommand(Command command, boolean useLabel, boolean useIcon, boolean useAcc) {
        BAccelerator acc;
        BImage icon;
        if (this.command != null) {
            this.command.unregister(this);
        }
        if (command == null) {
            return;
        }
        if (useLabel) {
            String label = command.getLabel();
            if (label == null) {
                label = "No label";
            }
            this.setText(label);
        }
        if (useIcon && !Theme.javaFx().shouldHideNonessentialIcons() && (icon = command.getIcon()) != null) {
            this.setImage(icon);
        }
        if (useAcc && (acc = command.getAccelerator()) != null && !acc.isNull()) {
            this.setAccelerator(acc);
        }
        this.command = command;
        command.register(this);
    }

    @Override
    public void computePreferredSize() {
        BAccelerator acc = this.getAccelerator();
        BInsets insets = Theme.menuItem().getInsets();
        BFont textFont = Theme.menuItem().getTextFont();
        BFont accFont = Theme.menuItem().getAcceleratorFont();
        double fh = Math.max(textFont.getHeight(), accFont.getHeight());
        this.textWidth = textFont.width(this.getText());
        this.acceleratorWidth = 0.0;
        if (!acc.isNull()) {
            this.acceleratorWidth = accFont.width(this.getAccelerator().toString());
        }
        double w = 0.0;
        double h = fh + insets.top + insets.bottom;
        this.baseline = h - textFont.getDescent() - insets.bottom;
        this.setPreferredSize(w, h);
    }

    @Override
    public void paint(Graphics g) {
        MenuItemTheme theme = Theme.menuItem();
        BAccelerator acc = this.getAccelerator();
        BInsets insets = Theme.menuItem().getInsets();
        this.paintBackground(g, theme);
        g.setFont(theme.getTextFont());
        if (this.getEnabled()) {
            if (this.isSelected) {
                g.setBrush(theme.getSelectionForeground(this));
            } else {
                g.setBrush(theme.getTextBrush());
            }
            if (this.shortcut != '\u0000') {
                String text;
                double offset = insets.left;
                int shortcutIndex = this.getText().toLowerCase().indexOf(Character.toLowerCase(this.shortcut));
                if (shortcutIndex > 0) {
                    text = this.getText().substring(0, shortcutIndex);
                    g.drawString(text, offset, this.baseline);
                    offset += g.getFont().width(text);
                }
                if (shortcutIndex > -1) {
                    text = this.getText().substring(shortcutIndex, shortcutIndex + 1);
                    BFont underline = BFont.make((BFont)theme.getTextFont(), (int)(theme.getTextFont().getStyle() | 4));
                    g.setFont(underline);
                    g.drawString(text, offset, this.baseline);
                    offset += underline.width(text);
                }
                if (shortcutIndex < this.getText().length()) {
                    text = this.getText().substring(shortcutIndex + 1, this.getText().length());
                    g.setFont(theme.getTextFont());
                    g.drawString(text, offset, this.baseline);
                }
            } else {
                g.drawString(this.getText(), insets.left, this.baseline);
            }
        } else {
            theme.paintDisabledText(g, this, this.getText(), insets.left, this.baseline);
        }
        if (this.showAccelerator && !acc.isNull()) {
            g.setFont(theme.getAcceleratorFont());
            if (this.getEnabled()) {
                if (this.isSelected) {
                    g.setBrush(theme.getSelectionForeground());
                } else {
                    g.setBrush(theme.getAcceleratorBrush());
                }
                g.drawString(acc.toString(), this.acceleratorX, this.baseline);
            } else {
                theme.paintDisabledText(g, this, acc.toString(), this.acceleratorX, this.baseline);
            }
        }
        this.paintImage(g);
    }

    void paintImage(Graphics g) {
        if (Theme.javaFx().shouldHideNonessentialIcons()) {
            return;
        }
        BImage image = this.getImage();
        if (!image.isNull()) {
            if (!this.isEnabled()) {
                image = image.getDisabledImage();
            }
            BInsets insets = Theme.menuItem().getInsets();
            g.drawImage(image, Theme.menuItem().getIconIndent(), insets.top);
        }
    }

    @Override
    public String getStyleSelector() {
        return "menu-item";
    }

    @Override
    public BWidget childAt(Point pt) {
        return null;
    }

    void opening(BMenu menu, boolean showAccelerator) {
        this.isSelected = false;
        this.showAccelerator = showAccelerator;
    }

    void select() {
        this.isSelected = true;
        this.repaint();
    }

    void unselect() {
        this.isSelected = false;
        this.repaint();
    }

    void doClick(BInputEvent event) {
    }

    void timerExpired() {
        if (this.isOver) {
            this.closeSiblings();
        }
    }

    void closeSiblings() {
        BMenuItem.stopTimer();
        SlotCursor c = this.getParent().getProperties();
        while (c.nextComponent()) {
            BValue x = c.get();
            if (x == this || !(x instanceof BSubMenuItem)) continue;
            ((BSubMenuItem)x).closeMenu();
        }
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        ((BMenu)this.getParent()).select(this);
        this.isOver = true;
        this.startTimer();
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        ((BMenu)this.getParent()).unselect(this);
        this.isOver = false;
        this.startTimer();
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        UiEnv.get().closePopup(null);
        if (this.contains(event.getX(), event.getY())) {
            this.doClick(event);
        }
    }

    void paintBackground(Graphics g, MenuItemTheme theme) {
        theme.paintBackground(g, this, this.isSelected);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimer() {
        Object object = timerLock;
        synchronized (object) {
            BMenuItem.stopTimer();
            timed = this;
            timer = new Timer();
            timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopTimer() {
        Object object = timerLock;
        synchronized (object) {
            timed = null;
            if (timer != null) {
                timer.kill();
            }
        }
    }

    static class TimerInvoker
    implements Runnable {
        BMenuItem item;

        TimerInvoker(BMenuItem item) {
            this.item = item;
        }

        @Override
        public void run() {
            this.item.timerExpired();
        }
    }

    static class Timer
    extends Thread {
        boolean dead;

        public Timer() {
            super("Ui:MenuItemTimer");
        }

        public void kill() {
            this.dead = true;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                BMenuItem item;
                Timer.sleep(200L);
                if (!this.dead && (item = timed) != null) {
                    UiEnv.get().invokeLater(new TimerInvoker(item));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

