/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.MenuBarTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractBar;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuBar;

public class BMenuBar
extends BAbstractBar
implements BMenu.MenuCloseListener,
BIMenuBar {
    public static final Type TYPE = Sys.loadType(BMenuBar.class);
    private static final BIcon icon = BIcon.std((String)"widgets/menuBar.png");
    static double itemGap = 4.0;
    private boolean mouseOver = false;
    private double ty;
    private BMenu over;
    private BMenu open;

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.getShell().setMenuBar(this);
    }

    public void stopped() throws Exception {
        this.getShell().setMenuBar(null);
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public BWidget asWidget() {
        return this;
    }

    @Override
    public BIMenu[] getMenus() {
        return (BIMenu[])this.getChildren(BMenu.class);
    }

    @Override
    public void addMenu(String menuName, BIMenu menu) {
        this.add(menuName, (BValue)menu.asWidget());
    }

    @Override
    public void setMenu(String menuName, BIMenu menu) {
        this.set(menuName, (BValue)menu.asWidget());
    }

    @Override
    public BIMenu getMenu(String menuName) {
        return (BIMenu)this.get(menuName);
    }

    @Override
    public BIMenu removeMenu(String menuName) {
        BIMenu menu = this.getMenu(menuName);
        this.removeMenu(menu);
        return menu;
    }

    @Override
    public void removeMenu(BIMenu menu) {
        this.remove((BComplex)menu.asWidget());
    }

    @Override
    public void removeAllMenus() {
        this.removeAll();
    }

    @Override
    public void addQuickSearch(BWidget quickSearch) {
        throw new UnsupportedOperationException("QuickSearch not supported on BMenuBar");
    }

    @Override
    public void removeQuickSearch() {
        throw new UnsupportedOperationException("QuickSearch not supported on BMenuBar");
    }

    @Override
    public void computePreferredSize() {
        MenuBarTheme theme = Theme.menuBar();
        BInsets bi = theme.getBarInsets();
        BInsets ii = theme.getItemInsets();
        BFont font = theme.getItemFont(this);
        double x = bi.left + itemGap;
        double y = bi.top;
        double w = 0.0;
        double h = font.getHeight() + ii.top + ii.bottom;
        this.ty = bi.top + ii.top + font.getHeight() - font.getDescent();
        BWidget[] items = this.getChildWidgets();
        for (int i = 0; i < items.length; ++i) {
            BMenu item = (BMenu)items[i];
            w = font.width(item.getText()) + ii.left + ii.right;
            item.menuBarRect = new RectGeom(x, y, w, h);
            x += w + itemGap;
        }
        this.setPreferredSize(x + w + bi.right, y + h + bi.top);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
    }

    @Override
    public BWidget childAt(Point pt) {
        return null;
    }

    @Override
    public void paint(Graphics g) {
        MenuBarTheme theme = Theme.menuBar();
        BInsets insets = theme.getItemInsets();
        theme.paintBackground(g, this);
        this.computeShortcutKeys();
        BMenu[] items = (BMenu[])this.getChildren(BMenu.class);
        g.setFont(theme.getTextFont(this));
        for (int i = 0; i < items.length; ++i) {
            String textPart;
            BMenu item = items[i];
            String text = item.getText();
            double tx = item.menuBarRect.x + insets.right;
            int state = 0;
            if (item == this.open) {
                state = 2;
            } else if (!(this.open != null && this.open.isOpen() || !this.hasFocus() && !this.mouseOver || item != this.over)) {
                state = 1;
            }
            theme.paintItemBackground(g, this, item.menuBarRect, state);
            g.setBrush(theme.getItemTextBrush(state, this));
            Point offset = theme.getItemTextOffset(state);
            if (!this.hasFocus()) {
                g.drawString(text, tx + offset.x, this.ty + offset.y);
                continue;
            }
            double textOffset = tx + offset.x;
            int shortcutIndex = text.toLowerCase().indexOf(Character.toLowerCase(items[i].shortcut));
            if (shortcutIndex > 0) {
                textPart = text.substring(0, shortcutIndex);
                g.drawString(textPart, textOffset, this.ty + offset.y);
                textOffset += g.getFont().width(textPart);
            }
            if (shortcutIndex > -1) {
                textPart = text.substring(shortcutIndex, shortcutIndex + 1);
                BFont underline = BFont.make((BFont)theme.getTextFont(), (int)(theme.getTextFont().getStyle() | 4));
                g.setFont(underline);
                g.drawString(textPart, textOffset, this.ty + offset.y);
                textOffset += underline.width(textPart);
            }
            if (shortcutIndex >= text.length()) continue;
            textPart = text.substring(shortcutIndex + 1, text.length());
            g.setFont(theme.getTextFont());
            g.drawString(textPart, textOffset, this.ty + offset.y);
        }
    }

    @Override
    public String getStyleSelector() {
        return "menu-bar";
    }

    private void computeShortcutKeys() {
        if (this.hasFocus()) {
            int letterIndex;
            int k;
            int i;
            BMenu[] items = (BMenu[])this.getChildren(BMenu.class);
            boolean[] letters = new boolean[26];
            for (i = 0; i < items.length; ++i) {
                if (items[i].shortcut <= '\u0000') continue;
                letters[items[i].shortcut - 97] = true;
            }
            block1: for (i = 0; i < items.length; ++i) {
                if (items[i].shortcut != '\u0000') continue;
                String[] words = TextUtil.split((String)items[i].getText().toLowerCase(), (char)' ');
                for (k = 0; k < words.length; ++k) {
                    if (words[k].length() <= 0 || words[k].charAt(0) < 'a' || words[k].charAt(0) > 'z' || letters[letterIndex = words[k].charAt(0) - 97]) continue;
                    items[i].shortcut = words[k].charAt(0);
                    letters[letterIndex] = true;
                    continue block1;
                }
            }
            block3: for (i = 0; i < items.length; ++i) {
                if (items[i].shortcut != '\u0000') continue;
                String text = items[i].getText().toLowerCase();
                for (k = 0; k < text.length(); ++k) {
                    if (text.charAt(k) < 'a' || text.charAt(k) > 'z' || letters[letterIndex = text.charAt(k) - 97]) continue;
                    items[i].shortcut = text.charAt(k);
                    letters[letterIndex] = true;
                    continue block3;
                }
            }
        } else {
            BMenuItem[] items = (BMenuItem[])this.getChildren(BMenuItem.class);
            for (int i = 0; i < items.length; ++i) {
                items[i].shortcut = '\u0000';
            }
        }
    }

    void openLeft() {
        BWidget[] children = this.getChildWidgets();
        for (int i = 0; i < children.length - 1; ++i) {
            if (children[i + 1] != this.open) continue;
            this.open((BMenu)children[i]);
            return;
        }
        if (children.length > 0) {
            this.open((BMenu)children[children.length - 1]);
        }
    }

    void openRight() {
        BWidget[] children = this.getChildWidgets();
        for (int i = 1; i < children.length; ++i) {
            if (children[i - 1] != this.open) continue;
            this.open((BMenu)children[i]);
            return;
        }
        if (children.length > 0) {
            this.open((BMenu)children[0]);
        }
    }

    private void open(BMenu menu) {
        if (this.open != null) {
            this.open.close();
        }
        RectGeom r = menu.menuBarRect;
        menu.open(this, r.x, r.y + r.height);
        menu.requestFocus();
        this.over = this.open = menu;
    }

    public void focus(BMenu menu) {
        this.requestFocus();
        this.over = menu;
    }

    void moveSelectionLeft() {
        BWidget[] children = this.getChildWidgets();
        for (int i = 0; i < children.length - 1; ++i) {
            if (children[i + 1] != this.over) continue;
            this.over = (BMenu)children[i];
            return;
        }
        if (children.length > 0) {
            this.over = (BMenu)children[children.length - 1];
        }
    }

    void moveSelectionRight() {
        BWidget[] children = this.getChildWidgets();
        for (int i = 1; i < children.length; ++i) {
            if (children[i - 1] != this.over) continue;
            this.over = (BMenu)children[i];
            return;
        }
        if (children.length > 0) {
            this.over = (BMenu)children[0];
        }
    }

    @Override
    public void focusGained(BFocusEvent event) {
        this.repaint();
        super.focusGained(event);
    }

    @Override
    public void focusLost(BFocusEvent event) {
        this.repaint();
        super.focusLost(event);
    }

    @Override
    public void menuClosed(BMenu menu) {
        this.open = null;
        this.repaint();
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.mouseOver = true;
        this.over = this.itemAt(event);
        this.repaint();
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        this.mouseOver = false;
        this.repaint();
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        BMenu last = this.over;
        this.over = this.itemAt(event);
        if (this.over != null && this.open != null && this.open != this.over) {
            this.open(this.over);
        }
        if (last != this.over) {
            this.repaint();
        }
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        if (this.over != null) {
            this.open(this.over);
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        if (this.open != null && this.open.isOpen()) {
            this.open.requestFocus();
        }
    }

    private BMenu itemAt(BMouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        BWidget[] items = this.getChildWidgets();
        for (int i = 0; i < items.length; ++i) {
            BMenu item = (BMenu)items[i];
            if (!item.menuBarRect.contains(x, y)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void keyReleased(BKeyEvent event) {
        if (event.getModifiers() != 0) {
            return;
        }
        block0 : switch (event.getKeyCode()) {
            case 40: {
                this.open(this.over);
                event.consume();
                break;
            }
            case 37: {
                this.moveSelectionLeft();
                event.consume();
                this.repaint();
                break;
            }
            case 39: {
                this.moveSelectionRight();
                event.consume();
                this.repaint();
                break;
            }
            default: {
                if (event.getKeyChar() < 'a' || event.getKeyChar() > 'z') break;
                BMenu[] items = (BMenu[])this.getChildren(BMenu.class);
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].shortcut != event.getKeyChar()) continue;
                    this.open(items[i]);
                    event.consume();
                    break block0;
                }
            }
        }
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 305: {
                return this;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

