/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BLayoutDimension
extends BSimple {
    public static final int ABS = 0;
    public static final int PERCENT = 1;
    public static final int PREF = 2;
    public static final BLayoutDimension DEFAULT = BLayoutDimension.make(0.0, 0);
    public static final Type TYPE = Sys.loadType(BLayoutDimension.class);
    private double value;
    private int unit;
    private String string;

    public static BLayoutDimension make(double value, int unit) {
        if (!BLayoutDimension.isWH(unit)) {
            throw new IllegalArgumentException("Unit is unknown: " + unit);
        }
        BLayoutDimension layout = new BLayoutDimension();
        layout.value = value;
        layout.unit = unit;
        return layout;
    }

    public static BLayoutDimension makeAbs(double value) {
        return BLayoutDimension.make(value, 0);
    }

    static boolean isWH(int unit) {
        return unit == 0 || unit == 1 || unit == 2;
    }

    public static BLayoutDimension make(String s) {
        try {
            Parser parser = new Parser(s);
            BLayoutDimension layout = new BLayoutDimension();
            layout.value = parser.cur.num;
            if (parser.cur.num()) {
                layout.unit = 0;
            } else if (parser.cur.dimen("%")) {
                layout.unit = 1;
            } else if (parser.cur.id("pref")) {
                layout.unit = 2;
            } else {
                throw new Exception();
            }
            return layout;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(s);
        }
    }

    private BLayoutDimension() {
    }

    public double getValue() {
        return this.value;
    }

    public int getUnit() {
        return this.unit;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.value);
        hash = hash * 37L + (long)this.unit;
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object object) {
        if (object instanceof BLayoutDimension) {
            BLayoutDimension o = (BLayoutDimension)((Object)object);
            return this.value == o.value && this.unit == o.unit;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return BLayoutDimension.make(in.readUTF());
    }

    public String encodeToString() {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            if (this.unit == 2) {
                s.append("pref");
            } else {
                s.append(BDouble.encode((double)this.value));
                if (this.unit == 1) {
                    s.append('%');
                }
            }
            this.string = s.toString();
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BLayoutDimension.make(s);
    }

    public Type getType() {
        return TYPE;
    }
}

