/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;

public class BHyperlinkLabel
extends BLabel {
    public static final Property ord = BHyperlinkLabel.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BHyperlinkLabel.class);
    private static final BIcon icon = BIcon.std((String)"widgets/hyperlinkLabel.png");
    private static final BIcon imageIcon = BIcon.std((String)"widgets/image.png");
    private boolean mouseOver = false;

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHyperlinkLabel() {
    }

    public BHyperlinkLabel(String label, BOrd ord) {
        super(label);
        this.setOrd(ord);
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public boolean receiveInputEvents() {
        return true;
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        BOrd ord = this.getOrd();
        if (this.mouseOver && !ord.isNull() && shell instanceof BIHyperlinkShell) {
            ((BIHyperlinkShell)((Object)shell)).hyperlink(new HyperlinkInfo(ord, event));
        }
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        BOrd ord = this.getOrd();
        if (shell != null && !ord.isNull()) {
            shell.showStatus(ord.toString());
            this.setMouseCursor(MouseCursor.hand);
        }
        this.mouseOver = true;
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(null);
        }
        this.mouseOver = false;
        this.setMouseCursor(MouseCursor.normal);
    }

    @Override
    public BIcon getIcon() {
        return this.getImage().isNull() ? icon : imageIcon;
    }
}

