/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import com.tridium.ui.util.LayoutUtil;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BCanvasPane;

public class ScaledLayout {
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private BTransform transform;

    public static ScaledLayout scaleToSelf(BCanvasPane canvasPane) {
        BScaleMode scaleMode;
        BValign valign;
        BHalign halign;
        if (LayoutUtil.isSelfScalingEnabled(canvasPane)) {
            halign = canvasPane.getHalign();
            valign = canvasPane.getValign();
            scaleMode = canvasPane.getScale();
        } else {
            halign = BHalign.left;
            valign = BValign.top;
            scaleMode = BScaleMode.none;
        }
        return ScaledLayout.scaleToSize(canvasPane, BSize.make((double)canvasPane.getWidth(), (double)canvasPane.getHeight()), halign, valign, scaleMode);
    }

    public static ScaledLayout scaleToOffsetParent(BCanvasPane canvasPane, BWidget offsetParent) {
        BInsets border = LayoutUtil.getAccumulatedInsets(canvasPane);
        BSize targetSize = BSize.make((double)(offsetParent.getWidth() - border.left - border.right), (double)(offsetParent.getHeight() - border.top - border.bottom));
        return ScaledLayout.scaleToSize(canvasPane, targetSize, canvasPane.getHalign(), canvasPane.getValign(), canvasPane.getScale());
    }

    private static ScaledLayout scaleToSize(BCanvasPane canvasPane, BSize targetSize, BHalign halign, BValign valign, BScaleMode scaleMode) {
        return ScaledLayout.scale(canvasPane.getViewSize(), targetSize, halign, valign, scaleMode, canvasPane.getMinScaleFactor(), canvasPane.getMaxScaleFactor());
    }

    public static ScaledLayout scale(BSize inner, BSize outer, BHalign halign, BValign valign, BScaleMode scaleMode) {
        return ScaledLayout.scale(inner, outer, halign, valign, scaleMode, 0.0, 0.0);
    }

    public static ScaledLayout scale(BSize inner, BSize outer, BHalign halign, BValign valign, BScaleMode scaleMode, double minScale, double maxScale) {
        double yScale;
        double xScale;
        if (maxScale <= 0.0) {
            maxScale = Double.POSITIVE_INFINITY;
        }
        double ow = outer.width;
        double oh = outer.height;
        double iw = inner.width;
        double ih = inner.height;
        if (iw == 0.0) {
            iw = ow;
        }
        if (ih == 0.0) {
            ih = oh;
        }
        double xRatio = ow / iw;
        double yRatio = oh / ih;
        switch (scaleMode.getOrdinal()) {
            case 1: {
                xScale = ScaledLayout.constrainToRange(xRatio, minScale, maxScale);
                yScale = ScaledLayout.constrainToRange(yRatio, minScale, maxScale);
                break;
            }
            case 3: {
                xScale = ScaledLayout.constrainToRange(xRatio, minScale, maxScale);
                yScale = 1.0;
                break;
            }
            case 4: {
                xScale = 1.0;
                yScale = ScaledLayout.constrainToRange(yRatio, minScale, maxScale);
                break;
            }
            case 2: {
                double scale = Math.min(xRatio, yRatio);
                xScale = scale = ScaledLayout.constrainToRange(scale, minScale, maxScale);
                yScale = scale;
                break;
            }
            case 0: {
                xScale = 1.0;
                yScale = 1.0;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported BScaleMode ordinal " + scaleMode.getOrdinal());
            }
        }
        return new ScaledLayout().withOffset(ScaledLayout.doHalign(ow, iw * xScale, halign), ScaledLayout.doValign(oh, ih * yScale, valign)).withScale(xScale, yScale);
    }

    public BTransform.Scale getScale() {
        return new BTransform.Scale(this.scaleX, this.scaleY);
    }

    public BTransform.Translate getTranslate() {
        return new BTransform.Translate(this.offsetX, this.offsetY);
    }

    public BTransform transform() {
        if (this.transform == null) {
            this.transform = BTransform.make((BTransform.Transform[])new BTransform.Transform[]{this.getTranslate(), this.getScale()});
        }
        return this.transform;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public String toString() {
        return "offset: {" + this.offsetX + "," + this.offsetY + "} scale: {" + this.scaleX + "," + this.scaleY + "}";
    }

    private static double doHalign(double outerWidth, double innerWidth, BHalign halign) {
        switch (halign.getOrdinal()) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return (outerWidth - innerWidth) / 2.0;
            }
        }
        return outerWidth - innerWidth;
    }

    private static double doValign(double outerHeight, double innerHeight, BValign valign) {
        switch (valign.getOrdinal()) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return (outerHeight - innerHeight) / 2.0;
            }
        }
        return outerHeight - innerHeight;
    }

    private static double constrainToRange(double num, double min, double max) {
        return Math.max(min, Math.min(num, max));
    }

    private ScaledLayout withOffset(double xOffset, double yOffset) {
        this.offsetX = xOffset;
        this.offsetY = yOffset;
        if (xOffset > -1.0 && xOffset < 0.0) {
            xOffset = 0.0;
        }
        if (yOffset > -1.0 && yOffset < 0.0) {
            yOffset = 0.0;
        }
        this.offsetX = Math.floor(xOffset);
        this.offsetY = Math.floor(yOffset);
        return this;
    }

    private ScaledLayout withScale(double scaleX, double scaleY) {
        return this.withScale(scaleX, scaleY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private ScaledLayout withScale(double scaleX, double scaleY, double min, double max) {
        this.scaleX = ScaledLayout.constrainToRange(scaleX, min, max);
        this.scaleY = ScaledLayout.constrainToRange(scaleY, min, max);
        return this;
    }
}

