/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import com.tridium.ui.ShellManager;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BResponsivePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.px.BPxInclude;

public final class LayoutUtil {
    private LayoutUtil() {
    }

    public static BInsets getAccumulatedInsets(BWidget widget) {
        BWidget ancestor = widget;
        BWidget offsetParent = LayoutUtil.getOffsetParent(widget);
        boolean responsiveFound = false;
        double top = 0.0;
        double right = 0.0;
        double bottom = 0.0;
        double left = 0.0;
        while (ancestor != null && ancestor != offsetParent) {
            BInsets border;
            if ((ancestor = ancestor.getParentWidget()) instanceof BBorderPane) {
                border = ((BBorderPane)ancestor).getAccumulatedBorder();
                top += border.top;
                right += border.right;
                bottom += border.bottom;
                left += border.left;
                continue;
            }
            if (ancestor instanceof BResponsivePane) {
                responsiveFound = true;
                BResponsivePane responsivePane = (BResponsivePane)ancestor;
                BFlowPane flowPane = (BFlowPane)responsivePane.getParentWidget();
                double width = flowPane.getPreferredWidth(responsivePane);
                left = left + flowPane.getWidth() - width;
                continue;
            }
            if (!(ancestor instanceof BScrollPane) || !responsiveFound) continue;
            border = LayoutUtil.getScrollPaneInsets((BScrollPane)ancestor);
            top += border.top;
            right += border.right;
            bottom += border.bottom;
            left += border.left;
        }
        return BInsets.make((double)top, (double)right, (double)bottom, (double)left);
    }

    public static BWidget getOffsetParent(BWidget widget) {
        BWidget parent;
        for (parent = widget.getParentWidget(); parent != null; parent = parent.getParentWidget()) {
            if (LayoutUtil.childMustSizeSelf(parent, widget)) {
                return null;
            }
            if (LayoutUtil.canScaleChildToSelf(parent)) {
                return widget;
            }
            widget = parent;
        }
        return parent == null ? null : widget;
    }

    private static boolean childMustSizeSelf(BWidget parent, BWidget child) {
        if (parent instanceof BEdgePane) {
            BEdgePane edgePane = (BEdgePane)parent;
            return child != edgePane.getCenter();
        }
        String parentType = parent.getType().toString();
        return parent instanceof BConstrainedPane || parent instanceof BGridPane || "mobile:BasicMobilePane".equals(parentType) || "mobile:MobileGridPane".equals(parentType);
    }

    private static boolean canScaleChildToSelf(BWidget widget) {
        return !(widget instanceof BBorderPane) && !(widget instanceof BScrollPane) && !(widget instanceof BFlowPane) && !(widget instanceof BResponsivePane) && !(widget instanceof BPxInclude);
    }

    public static boolean isSelfScalingEnabled(BWidget widget) {
        ShellManager shellManager = widget.getShellManager();
        return shellManager == null || shellManager.allowScalingTransforms();
    }

    public static BScrollPane getParentScrollPane(BWidget widget) {
        if (widget == null) {
            return null;
        }
        BWidget parent = widget.getParentWidget();
        while (parent instanceof BBorderPane) {
            parent = parent.getParentWidget();
        }
        return parent instanceof BScrollPane ? (BScrollPane)parent : null;
    }

    public static BInsets getAccumulatedBorderAndScrollSize(BWidget widget) {
        BInsets border;
        BWidget ancestor = widget;
        double top = 0.0;
        double right = 0.0;
        double bottom = 0.0;
        double left = 0.0;
        do {
            if (!((ancestor = ancestor.getParentWidget()) instanceof BBorderPane)) continue;
            border = ((BBorderPane)ancestor).getAccumulatedBorder();
            top += border.top;
            right += border.right;
            bottom += border.bottom;
            left += border.left;
        } while (ancestor instanceof BBorderPane);
        if (ancestor instanceof BScrollPane) {
            border = LayoutUtil.getScrollPaneInsets((BScrollPane)ancestor);
            top += border.top;
            right += border.right;
            bottom += border.bottom;
            left += border.left;
        }
        return BInsets.make((double)top, (double)right, (double)bottom, (double)left);
    }

    public static BInsets getScrollPaneInsets(BScrollPane scrollPane) {
        BScrollBar hsb = scrollPane.getHscrollBar();
        BScrollBar vsb = scrollPane.getVscrollBar();
        double scrollW = vsb.getPreferredWidth();
        double scrollH = hsb.getPreferredHeight();
        if (hsb.getWidth() == 0.0) {
            scrollH = 0.0;
        }
        return BInsets.make((double)0.0, (double)scrollW, (double)scrollH, (double)0.0);
    }

    public static BSize getPreferredSizeForDialogContent(BWidget c) {
        c.computePreferredSize();
        double width = c.getPreferredWidth() + 12.0;
        double height = c.getPreferredHeight() + 12.0;
        if (!(c instanceof BTextEditorPane) && (c instanceof BScrollPane || c instanceof BTabbedPane)) {
            if (c instanceof BScrollPane) {
                width = c.getPreferredWidth() > 800.0 ? 800.0 : (c.getPreferredWidth() < 400.0 ? 400.0 : c.getPreferredWidth() + 12.0);
                height = c.getPreferredHeight() > 800.0 ? 800.0 : (c.getPreferredHeight() < 100.0 ? 100.0 : c.getPreferredHeight() + 8.0);
            } else {
                width = 400.0;
                height = 300.0;
            }
        }
        return BSize.make((double)width, (double)height);
    }
}

