/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import com.tridium.ui.theme.Theme;
import com.tridium.util.ObjectUtil;
import java.text.DateFormat;
import java.util.Date;
import javax.baja.gx.BFont;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BPane;
import javax.baja.util.LexiconText;

public class LabelUtil {
    public static BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();

    public static void addLabelWidgetPair(BPane grid, LexiconText text, BWidget widget2, boolean bold) {
        LabelUtil.addLabelWidgetPair(grid, text == null ? "" : text.getText(null), widget2, bold);
    }

    public static void addLabelWidgetPair(BPane grid, LexiconText text, BWidget widget2) {
        LabelUtil.addLabelWidgetPair(grid, text == null ? "" : text.getText(null), widget2, true);
    }

    public static void addLabelWidgetPair(BPane grid, LexiconText text, Object[] lexArgs, BWidget widget2, boolean bold) {
        LabelUtil.addLabelWidgetPair(grid, text == null ? "" : text.getText(null, lexArgs), widget2, bold);
    }

    public static void addLabelWidgetPair(BPane grid, LexiconText text, Object[] lexArgs, BWidget widget2) {
        LabelUtil.addLabelWidgetPair(grid, text == null ? "" : text.getText(null, lexArgs), widget2, true);
    }

    public static void addLabelWidgetPair(BPane grid, String text, BWidget widget2) {
        LabelUtil.addLabelWidgetPair(grid, text, widget2, true);
    }

    public static void addLabelWidgetPair(BPane grid, String text, BWidget widget2, boolean bold) {
        String fieldName = text.trim();
        if (fieldName.length() > 10) {
            fieldName = fieldName.substring(0, 10);
        }
        fieldName = ObjectUtil.generateUniqueSlotName((String)SlotPath.escape((String)fieldName), (ObjectUtil.NameContainer)new NameContainer((BComplex)grid));
        grid.add(fieldName, (BValue)LabelUtil.makeLabel(text, bold));
        grid.add(null, (BValue)widget2);
    }

    public static void addLabelWidgetPair(BPane grid, BLabel widget1, BWidget widget2) {
        String fieldName = widget1.getText().trim();
        if (fieldName.length() > 10) {
            fieldName = fieldName.substring(0, 10);
        }
        fieldName = ObjectUtil.generateUniqueSlotName((String)SlotPath.escape((String)fieldName), (ObjectUtil.NameContainer)new NameContainer((BComplex)grid));
        grid.add(fieldName, (BValue)widget1);
        grid.add(null, (BValue)widget2);
    }

    public static BLabel makeLabel(LexiconText text) {
        return LabelUtil.makeLabel(text, false, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText text, boolean bold) {
        return LabelUtil.makeLabel(text, bold, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText text, boolean bold, BHalign align) {
        return LabelUtil.makeLabel(text == null ? null : text.getText(null), bold, align);
    }

    public static BLabel makeLabel(LexiconText text, Object[] lexArgs) {
        return LabelUtil.makeLabel(text, lexArgs, false, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText text, Object[] lexArgs, boolean bold) {
        return LabelUtil.makeLabel(text, lexArgs, bold, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText text, Object[] lexArgs, boolean bold, BHalign align) {
        return LabelUtil.makeLabel(text == null ? null : text.getText(null, lexArgs), bold, align);
    }

    public static BLabel makeLabel(String text, boolean bold) {
        return LabelUtil.makeLabel(text, bold, BHalign.left);
    }

    public static BLabel makeLabel(String text, boolean bold, BHalign align) {
        BLabel result = new BLabel(text == null ? "" : text, align);
        if (bold) {
            result.setFont(BOLD_TEXT_FONT);
        }
        return result;
    }

    public static String formatTime(BAbsTime time) {
        if (time == null || time.isNull()) {
            return String.valueOf(time);
        }
        return DateFormat.getInstance().format(new Date(time.getMillis()));
    }

    private static class NameContainer
    implements ObjectUtil.NameContainer {
        BComplex complex;

        public NameContainer(BComplex pComplex) {
            this.complex = pComplex;
        }

        public boolean contains(String name) {
            return this.complex.getSlot(name) != null;
        }
    }
}

