/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextModel;

public final class BProgressTextPane
extends BTextEditorPane {
    public static final Action scrollToBottom = BProgressTextPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BProgressTextPane.class);
    private WorkerRunnable workerRunnable;
    private Thread worker;
    private volatile Clock.Ticket scrollTicket = Clock.expiredTicket;
    private static final long maxSize = 32768L;

    public void scrollToBottom() {
        this.invoke(scrollToBottom, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BProgressTextPane() {
        this((WorkerRunnable)null);
    }

    public BProgressTextPane(WorkerRunnable workerRunnable) {
        if (workerRunnable != null) {
            this.setWorkerRunnable(workerRunnable);
        }
        this.getEditor().setEditable(false);
    }

    public void add(String text) {
        TextModel model = this.getEditor().getModel();
        model.insert(model.getEndPosition(), text + "\n");
        long currentSize = model.getTextLength();
        if (currentSize > 32768L) {
            int linePos = 0;
            while ((double)currentSize > 31129.6) {
                Line line = model.getLine(linePos);
                currentSize -= (long)line.getColumnCount();
                ++linePos;
            }
            model.remove(new Position(0, 0), new Position(linePos, 0));
        }
        this.repaint();
    }

    public void add(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(out));
        this.add(out.toString());
    }

    public void add(byte[] buf, int offset, int len) {
        this.add(new String(buf, offset, len));
    }

    public void clear() {
        this.setText("");
        this.repaint();
    }

    public void setWorkerRunnable(WorkerRunnable workerRunnable) {
        if (workerRunnable != null) {
            workerRunnable.progressTextBox = this;
        }
        this.workerRunnable = workerRunnable;
    }

    public void startWorker() {
        this.worker = new Thread((Runnable)this.workerRunnable, "ProgressTextBox.Worker");
        this.worker.start();
    }

    @Override
    public void started() throws Exception {
        this.startWorker();
    }

    public void stopped() throws Exception {
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.scrollTicket.cancel();
    }

    public void doScrollToBottom() {
        BWidget.invokeLater(new Runnable(){

            @Override
            public void run() {
                BProgressTextPane.this.getEditor().moveCaretPosition(new Position(BProgressTextPane.this.getEditor().getModel().getLineCount() - 1, 0));
                BProgressTextPane.this.relayout();
            }
        });
    }

    public static abstract class WorkerRunnable
    implements Runnable {
        private BProgressTextPane progressTextBox;

        @Override
        public final void run() {
            try {
                this.progressTextBox.scrollTicket.cancel();
                this.progressTextBox.scrollTicket = Clock.schedulePeriodically((BComponent)this.progressTextBox, (BRelTime)BRelTime.make((long)1000L), (Action)scrollToBottom, null);
                this.clear();
                this.doRun();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                e.printStackTrace();
                BDialog.error(this.progressTextBox, "Progress Text Pane Worker Failed", e);
            }
            finally {
                this.progressTextBox.scrollTicket.cancel();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                this.progressTextBox.doScrollToBottom();
            }
        }

        public abstract void doRun() throws Exception;

        protected final void add(final String text) {
            BWidget.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressTextBox.add(text);
                }
            });
        }

        protected final void add(final Throwable t) {
            BWidget.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressTextBox.add(t);
                }
            });
        }

        protected final void add(final byte[] buf, final int offset, final int len) {
            BWidget.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressTextBox.add(buf, offset, len);
                }
            });
        }

        protected final void clear() {
            BWidget.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressTextBox.clear();
                }
            });
        }

        protected BProgressTextPane getProgressTextBox() {
            return this.progressTextBox;
        }

        protected boolean isInterrupted() {
            return this.getThread().isInterrupted();
        }

        protected final Thread getThread() {
            return this.progressTextBox.worker;
        }
    }
}

