/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.style.IStylable;

public class PalladiumMenuItemTheme
extends PalladiumWidgetTheme
implements MenuItemTheme {
    static BInsets insets = BInsets.make((double)2.0, (double)14.0, (double)2.0, (double)22.0);
    static BFont acceleratorFont = null;
    static BBrush acceleratorBrush = PalladiumWidgetTheme.selectionBackground;

    @Override
    public BInsets getInsets() {
        return insets;
    }

    @Override
    public double getIconIndent() {
        return 2.0;
    }

    @Override
    public BFont getTextFont() {
        return this.getPlainText();
    }

    @Override
    public BBrush getTextBrush() {
        return this.getControlForeground();
    }

    @Override
    public BFont getAcceleratorFont() {
        return acceleratorFont;
    }

    @Override
    public BBrush getAcceleratorBrush() {
        return acceleratorBrush;
    }

    @Override
    public BBrush getAcceleratorBrush(IStylable widget) {
        return this.getAcceleratorBrush();
    }

    @Override
    @Deprecated
    public void paintDisabledText(Graphics g, String s, double x, double y) {
        g.setBrush(this.getControlHighlight());
        g.drawString(s, x + 1.0, y + 1.0);
        g.setBrush(this.getControlShadow());
        g.drawString(s, x, y);
    }

    @Override
    public void paintBackground(Graphics g, BMenuItem m, boolean selected) {
        if (selected) {
            g.setBrush(this.getSelectionBackground());
        } else {
            g.setBrush(this.getControlBackground());
        }
        g.fillRect(0.0, 0.0, m.getWidth(), m.getHeight());
    }

    @Override
    public void paintSubMenuArrow(Graphics g, BMenuItem m, boolean selected) {
        double w = m.getWidth();
        double h = m.getHeight();
        double mid = h / 2.0;
        double x = w - 4.0;
        if (m.getEnabled()) {
            if (selected) {
                g.setBrush(this.getSelectionForeground());
            } else {
                g.setBrush(this.getControlForeground());
            }
        } else {
            g.setBrush(this.getTextDisabled());
        }
        g.strokeLine(x, mid - 0.0, x, mid + 0.0);
        g.strokeLine(x -= 1.0, mid - 1.0, x, mid + 1.0);
        g.strokeLine(x -= 1.0, mid - 2.0, x, mid + 2.0);
        g.strokeLine(x -= 1.0, mid - 3.0, x, mid + 3.0);
        g.strokeLine(x -= 1.0, mid - 4.0, x, mid + 4.0);
        x -= 1.0;
    }

    @Override
    public void paintCheckBox(Graphics g, BCheckBoxMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double h = m.getHeight();
            double x = PalladiumMenuItemTheme.insets.left / 2.0 - 4.0;
            double y = h / 2.0 + 2.0;
            if (m.getEnabled()) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - 4.0);
            g.strokeLine(x + 2.0, y + 2.0, x + 7.0, y - 3.0);
            g.strokeLine(x + 1.0, y, x + 2.0, y + 1.0);
            g.strokeLine(x + 2.0, y + 1.0, x + 6.0, y - 3.0);
        }
    }

    @Override
    public void paintRadioBox(Graphics g, BRadioButtonMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double w = 4.0;
            double h = 4.0;
            double x = PalladiumMenuItemTheme.insets.left / 2.0 - w / 2.0;
            double y = m.getHeight() / 2.0 - h / 2.0 + 1.0;
            if (m.getEnabled()) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeLine(x, y + h / 2.0, x + w / 2.0, y);
            g.strokeLine(x + 1.0, y + h / 2.0 + 1.0, x + w / 2.0 + 1.0, y + 1.0);
            g.strokeLine(x + 2.0, y + h / 2.0 + 2.0, x + w / 2.0 + 2.0, y + 2.0);
            g.strokeLine(x + 1.0, y + h / 2.0, x + w / 2.0, y + 1.0);
            g.strokeLine(x + 2.0, y + h / 2.0 + 1.0, x + w / 2.0 + 1.0, y + 2.0);
        }
    }

    static {
        BFont font = PalladiumWidgetTheme.plainText;
        acceleratorFont = BFont.make((String)font.getName(), (double)(font.getSize() - 1.0), (int)font.getStyle());
    }
}

