/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public class StyleUtils {
    public static void addStyleClass(IStylable widget, String styleClass) {
        if (widget == null || styleClass == null) {
            return;
        }
        String styleClassList = widget.getStyleClasses();
        widget.setStyleClasses(StyleUtils.addStyleClass(styleClassList, styleClass));
    }

    public static String addStyleClass(String styleClassList, String styleClass) {
        List<String> classes = StyleUtils.toStyleClassList(styleClassList);
        if (!classes.contains(styleClass)) {
            classes.add(styleClass);
        }
        return StyleUtils.toStyleClassString(classes);
    }

    public static void removeStyleClass(IStylable widget, String styleClass) {
        if (widget == null || styleClass == null) {
            return;
        }
        String styleClassList = widget.getStyleClasses();
        widget.setStyleClasses(StyleUtils.removeStyleClass(styleClassList, styleClass));
    }

    public static String removeStyleClass(String styleClassList, String styleClass) {
        List<String> classes = StyleUtils.toStyleClassList(styleClassList);
        classes.remove(styleClass);
        return StyleUtils.toStyleClassString(classes);
    }

    public static void toggleStyleClass(IStylable widget, String styleClass, boolean toggle) {
        if (toggle) {
            StyleUtils.addStyleClass(widget, styleClass);
        } else {
            StyleUtils.removeStyleClass(widget, styleClass);
        }
    }

    public static boolean hasStyle(IStylable widget, String style) {
        if (widget == null || style == null) {
            return false;
        }
        return StyleUtils.toStyleClassList(widget.getStyleClasses()).contains(style);
    }

    public static List<String> toStyleClassList(String styleClassList) {
        ArrayList<String> styleClasses = new ArrayList<String>();
        if (styleClassList != null) {
            StringTokenizer tok = new StringTokenizer(styleClassList);
            while (tok.hasMoreTokens()) {
                styleClasses.add(tok.nextToken());
            }
        }
        return styleClasses;
    }

    public static List<String> getAutoClasses(IStylable s) {
        BWidget widget;
        ArrayList<String> classes = new ArrayList<String>();
        if (s instanceof BWidget && !(widget = (BWidget)s).isEnabled()) {
            classes.add("disabled");
        }
        return classes;
    }

    public static String toStyleClassString(List<String> styleClasses) {
        if (styleClasses == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean started = false;
        for (int i = 0; i < styleClasses.size(); ++i) {
            if (started) {
                sb.append(" ");
            }
            sb.append(styleClasses.get(i));
            started = true;
        }
        return sb.toString();
    }
}

