/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.CheckBoxTheme;
import com.tridium.ui.theme.custom.CustomToggleButtonTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;

public class CustomCheckBoxTheme
extends CustomToggleButtonTheme
implements CheckBoxTheme {
    private int checkBoxSize;

    public CustomCheckBoxTheme() {
        NSS nss = CustomCheckBoxTheme.getNSS();
        NSS checkBox = nss.selectNode("button checkbox");
        this.regFallbackValue(checkBox, "normalPadding", "padding", "2 2 2 18");
        this.regFallbackValue(checkBox, "checkBoxSize", "size", "13");
    }

    @Override
    String getNSSSelector() {
        return "button checkbox";
    }

    @Override
    public BFont getTextFont() {
        return this.getPlainText();
    }

    @Override
    public IPoint getLabelOffset(BAbstractButton button) {
        return this.noOffset;
    }

    @Override
    public int getCheckBoxSize() {
        return this.checkBoxSize;
    }

    public void setCheckBoxSize(int checkBoxSize) {
        this.checkBoxSize = checkBoxSize;
    }

    @Override
    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean selected = ((BToggleButton)b).isSelected();
        BBrush bg = b.getBackground();
        if (!bg.isNull()) {
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, b.getWidth(), b.getHeight());
        }
        double x = 0.0;
        double y = b.getHeight() / 2.0 - (double)(this.checkBoxSize / 2);
        double w = this.checkBoxSize - 1;
        double h = this.checkBoxSize - 1;
        g.setBrush(this.getControlBackground(b));
        g.fillRect(x, y, w, h);
        g.setBrush(this.getControlForeground(b));
        g.strokeRect(x, y, w, h);
        if (pressed && mouseOver) {
            g.setBrush(this.getControlShadow(b));
        } else {
            g.setBrush(this.getControlHighlight(b));
        }
        g.strokeLine(x + 1.0, y + 1.0, x + w - 2.0, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - 2.0);
        g.setBrush(this.getControlShadow(b));
        g.strokeLine(x + w - 1.0, y + 1.0, x + w - 1.0, y + h - 1.0);
        g.strokeLine(x + 1.0, y + h - 1.0, x + w - 1.0, y + h - 1.0);
        if (selected) {
            x = w / 2.0 - 4.0;
            y = b.getHeight() / 2.0;
            g.setBrush(this.getControlForeground(b));
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - 4.0);
            g.strokeLine(x + 2.0, y + 2.0, x + 7.0, y - 3.0);
            g.strokeLine(x + 1.0, y, x + 2.0, y + 1.0);
            g.strokeLine(x + 2.0, y + 1.0, x + 6.0, y - 3.0);
            g.setBrush(this.getControlShadow(b));
            g.strokeLine(x + 3.0, y + 2.0, x + 7.0, y - 2.0);
            g.strokeLine(x + 3.0, y + 3.0, x + 8.0, y - 2.0);
        }
        if (b.hasFocus() && b.isFocusTraversable() && b.getText() != null && b.getText().length() > 0) {
            BInsets padding = this.getNormalPadding();
            x = padding.left - 2.0;
            y = padding.top;
            w = b.getWidth() - (x + padding.right);
            h = b.getHeight() - (y + padding.bottom);
            this.paintFocus(g, new RectGeom(x, y, w, h));
        }
    }
}

