/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme;

import com.tridium.ui.theme.Theme;
import com.tridium.util.BIStationTheme;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStationTheme
extends BObject
implements BIStationTheme {
    public static final Type TYPE = Sys.loadType(BStationTheme.class);
    private static Logger logger = Logger.getLogger("com.tridium.ui.theme");
    private static boolean stationThemeSet = false;
    private static String STATION_THEME = AccessController.doPrivileged(() -> System.getProperty("niagara.stationTheme"));

    public Type getType() {
        return TYPE;
    }

    public void setStationTheme(BDynamicEnum stationTheme) {
        if (stationThemeSet) {
            return;
        }
        stationThemeSet = true;
        if ("palladium".equalsIgnoreCase(STATION_THEME)) {
            logger.fine("Keeping default palladium theme for station theme.");
            return;
        }
        if (STATION_THEME != null) {
            stationTheme = BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{STATION_THEME}));
            logger.fine("Installing custom theme module from system.property entry " + stationTheme.getTag() + "...");
        } else {
            logger.fine("Installing custom theme module " + stationTheme.getTag() + "...");
        }
        Theme.installFromEnum(stationTheme);
    }
}

