/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.swing;

import com.tridium.gx.awt.AwtGraphics;
import com.tridium.ui.ShellManager;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.NMouseCursor;
import com.tridium.ui.theme.Theme;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.security.AccessController;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public abstract class BSwingWidget
extends BTransferWidget {
    public static final Type TYPE = Sys.loadType(BSwingWidget.class);
    protected JRootPane rootPane;
    private KeyListener contentKeyListener;

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BWidget;
    }

    public abstract JComponent createContent();

    public String getWidgetDisplayName(Context cx) {
        return TextUtil.toFriendly((String)this.getType().getTypeName());
    }

    protected void doInitialize() {
    }

    protected boolean canInitialize() {
        return this.getAwtShellManager() != null || BBoolean.TRUE.equals((Object)this.get("forceInitialize"));
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11 && this.canInitialize()) {
            this.addToShell();
            AccessController.doPrivileged(() -> {
                this.rootPane.setGlassPane(new GlassPane(this.rootPane.getContentPane()));
                this.rootPane.getGlassPane().setVisible(this.getVisible());
                this.rootPane.setVisible(this.getVisible());
                this.rootPane.getContentPane().setVisible(this.getVisible());
                this.rootPane.setEnabled(this.getEnabled());
                this.rootPane.getContentPane().setEnabled(this.getEnabled());
                return null;
            });
            this.layoutSwing();
            this.relayout();
            this.doInitialize();
        } else if (x == 12) {
            this.removeFromShell();
        } else if (x == 2) {
            this.swChanged((Property)a);
        }
        return super.fw(x, a, b, c, d);
    }

    protected void addToShell() {
        JComponent content;
        if (this.rootPane == null) {
            this.rootPane = new JRootPane(){

                @Override
                protected Container createContentPane() {
                    return new NullPanel();
                }
            };
        }
        if ((content = (JComponent)this.rootPane.getContentPane()) == null || content instanceof NullPanel) {
            content = this.createContent();
            this.rootPane.setContentPane(content);
        }
        content.setOpaque(true);
        final AwtShellManager shellManager = this.getAwtShellManager();
        if (shellManager != null) {
            this.contentKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isControlDown() || e.isShiftDown() || e.isAltDown()) {
                        shellManager.processKeyEvent(e);
                    }
                }
            };
        }
        content.addKeyListener(this.contentKeyListener);
        this.rootPane.setContentPane(content);
        if (shellManager != null) {
            AccessController.doPrivileged(() -> {
                shellManager.add(this.rootPane);
                return null;
            });
        }
    }

    protected void removeFromShell() {
        AccessController.doPrivileged(() -> {
            if (this.rootPane != null && this.rootPane.getParent() != null) {
                this.rootPane.getParent().remove(this.rootPane);
            }
            if (this.rootPane != null && this.rootPane.getContentPane() != null && this.contentKeyListener != null) {
                this.rootPane.getContentPane().removeKeyListener(this.contentKeyListener);
            }
            return null;
        });
    }

    private void swChanged(Property prop) {
        SwingUtilities.invokeLater(() -> {
            if (this.canInitialize() && this.rootPane != null && this.rootPane.getContentPane() != null) {
                if (prop == BWidget.visible) {
                    AccessController.doPrivileged(() -> {
                        this.rootPane.setVisible(this.getVisible());
                        this.rootPane.getContentPane().setVisible(this.getVisible());
                        return null;
                    });
                } else if (prop == BWidget.enabled) {
                    AccessController.doPrivileged(() -> {
                        this.rootPane.setEnabled(this.getEnabled());
                        this.rootPane.getContentPane().setEnabled(this.getEnabled());
                        return null;
                    });
                }
                this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof AwtGraphics && this.canInitialize()) {
            this.layoutSwing();
            AwtGraphics awtg = (AwtGraphics)g;
            if (this.rootPane != null) {
                this.rootPane.paintAll(awtg.getAwtGraphics());
            }
        } else {
            g.setBrush(BColor.lightCyan);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
            String str = this.getWidgetDisplayName(null);
            BFont font = Theme.label().getTextFont(this);
            g.setFont(font);
            g.setBrush(BColor.black);
            double tw = font.width(str);
            double th = font.getHeight();
            double x = this.getWidth() / 2.0 - tw / 2.0;
            double y = this.getHeight() / 2.0 - th / 2.0;
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
            g.drawString(str, x, y);
        }
        this.paintChildren(g);
    }

    @Override
    public void doLayout(BWidget[] children) {
        this.layoutSwing();
    }

    private void layoutSwing() {
        if (this.rootPane != null) {
            Point point = new Point(0.0, 0.0);
            AwtShellManager shell = this.getAwtShellManager();
            if (shell != null) {
                point = this.translateToTopMostShell(shell.getShell(), point);
            }
            this.rootPane.setBounds((int)point.x, (int)point.y, (int)this.getWidth(), (int)this.getHeight());
            this.rootPane.getContentPane().setBounds(new Rectangle((int)this.getWidth(), (int)this.getHeight()));
            this.rootPane.revalidate();
        }
    }

    private Point translateToTopMostShell(BWidget ancestor, Point pt) {
        BWidget p = this.findParentWidget((BComplex)this);
        BWidget w = this;
        while (w != ancestor) {
            p.translateFromChild(w, pt);
            w = p;
            p = this.findParentWidget((BComplex)p);
        }
        return pt;
    }

    private BWidget findParentWidget(BComplex c) {
        if (c == null) {
            return null;
        }
        BComplex p = c.getParent();
        if (p == null) {
            return null;
        }
        if (p instanceof BWidget) {
            return (BWidget)p;
        }
        return this.findParentWidget(p.getParent());
    }

    @Override
    public void computePreferredSize() {
        if (this.rootPane != null && this.rootPane.getContentPane() != null) {
            Dimension dim = this.rootPane.getContentPane().getPreferredSize();
            this.setPreferredSize(dim.getWidth(), dim.getHeight());
        } else {
            this.setPreferredSize(640.0, 480.0);
        }
    }

    public void setContentKeyListener(KeyListener listener) {
        if (this.rootPane != null && this.rootPane.getContentPane() != null) {
            if (this.contentKeyListener != null) {
                this.rootPane.getContentPane().removeKeyListener(this.contentKeyListener);
            }
            this.contentKeyListener = listener;
            this.rootPane.getContentPane().addKeyListener(listener);
        }
    }

    @Override
    public TransferEnvelope getTransferData() throws Exception {
        return null;
    }

    @Override
    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return null;
    }

    @Override
    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    @Override
    public final int dragOver(TransferContext cx) {
        int res = this.doDragOver(cx);
        this.setMouseCursor(new NMouseCursor(res == 0 ? DragSource.DefaultCopyNoDrop : DragSource.DefaultCopyDrop));
        return res;
    }

    public int doDragOver(TransferContext cx) {
        return 0;
    }

    @Override
    public final CommandArtifact drop(TransferContext cx) throws Exception {
        CommandArtifact res;
        try {
            res = this.doDrop(cx);
        }
        finally {
            this.setMouseCursor(new NMouseCursor(Cursor.getDefaultCursor()));
        }
        return res;
    }

    public CommandArtifact doDrop(TransferContext cx) throws Exception {
        return null;
    }

    public final JComponent getContent() {
        return this.rootPane != null ? (JComponent)this.rootPane.getContentPane() : null;
    }

    protected final AwtShellManager getAwtShellManager() {
        return this.findAwtShellManager((BComplex)this);
    }

    private AwtShellManager findAwtShellManager(BComplex c) {
        if (c == null) {
            return null;
        }
        if (!(c instanceof BWidget)) {
            return this.findAwtShellManager(c.getParent());
        }
        ShellManager shell = ((BWidget)c).getShellManager();
        if (shell != null && shell instanceof AwtShellManager) {
            return (AwtShellManager)shell;
        }
        return this.findAwtShellManager(c.getParent());
    }

    static {
        if (AccessController.doPrivileged(() -> System.getProperty("bajaui.enableRepaintManager", "true")).equals("true")) {
            SwingUtilities.invokeLater(() -> RepaintManager.setCurrentManager(new BajauiRepaintManager()));
        }
    }

    private static class BajauiRepaintManager
    extends RepaintManager {
        private BajauiRepaintManager() {
        }

        @Override
        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            AwtShellManager shellManager = this.findShellManager(c);
            if (shellManager != null) {
                java.awt.Point pnt = this.translateToShell(new java.awt.Point(x, y), c);
                shellManager.repaint(pnt.x, pnt.y, w, h);
            } else {
                super.addDirtyRegion(c, x, y, w, h);
            }
        }

        private AwtShellManager findShellManager(Component c) {
            if (c == null) {
                return null;
            }
            if (c instanceof AwtShellManager) {
                return (AwtShellManager)c;
            }
            return this.findShellManager(c.getParent());
        }

        private java.awt.Point translateToShell(java.awt.Point pnt, Component c) {
            if (c == null || c instanceof AwtShellManager) {
                return pnt;
            }
            pnt.translate(c.getX(), c.getY());
            return this.translateToShell(pnt, c.getParent());
        }
    }

    private final class GlassMouseListener
    extends MouseAdapter {
        private Container contentPane;
        private GlassPane glassPane;
        private boolean mouseDragged = false;
        private Component dragSource;
        private Component lastMouseEntered;

        private GlassMouseListener(Container contentPane, GlassPane glassPane) {
            this.contentPane = contentPane;
            this.glassPane = glassPane;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.redispatchMouseEvent(e);
        }

        private void redispatchMouseEvent(MouseEvent e) {
            AwtShellManager shellManager = BSwingWidget.this.getAwtShellManager();
            if (shellManager == null) {
                return;
            }
            shellManager.userActivity();
            MouseEvent shellEvent = SwingUtilities.convertMouseEvent(this.glassPane, e, shellManager);
            BWidget w = shellManager.widgetAt(new Point((double)shellEvent.getX(), (double)shellEvent.getY()), false);
            if (e.getID() == 504 || e.getID() == 505 || w == BSwingWidget.this && AwtShellManager.dragOperation == null) {
                Component deepestComponent;
                java.awt.Point containerPoint = SwingUtilities.convertPoint(this.glassPane, e.getPoint(), this.contentPane);
                if (e.getID() == 505 && this.lastMouseEntered != null) {
                    deepestComponent = this.lastMouseEntered;
                    this.lastMouseEntered = null;
                } else {
                    deepestComponent = SwingUtilities.getDeepestComponentAt(this.contentPane, containerPoint.x, containerPoint.y);
                    if (deepestComponent == null) {
                        deepestComponent = this.contentPane;
                    }
                }
                if (e.getID() == 504) {
                    this.lastMouseEntered = deepestComponent;
                }
                MouseEvent deepestComponentEvent = SwingUtilities.convertMouseEvent(this.glassPane, e, deepestComponent);
                Point translated = shellManager.shellToWidget(w, new Point((double)shellEvent.getX(), (double)shellEvent.getY()));
                deepestComponentEvent.translatePoint((int)(translated.x - (double)deepestComponentEvent.getX()), (int)(translated.y - (double)deepestComponentEvent.getY()));
                deepestComponent.dispatchEvent(deepestComponentEvent);
                if (!this.mouseDragged && e.getID() == 506) {
                    this.mouseDragged = true;
                    this.dragSource = deepestComponent;
                } else if (e.getID() == 502) {
                    this.mouseDragged = false;
                    this.dragSource = null;
                }
                BSwingWidget.this.setMouseCursor(new NMouseCursor(deepestComponent.getCursor()));
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                if (e.getID() == 503) {
                    shellManager.processMouseMotionEvent(shellEvent);
                } else {
                    shellManager.processMouseEvent(shellEvent);
                }
                if (e.getID() == 500) {
                    deepestComponent.requestFocus();
                }
            } else if (w instanceof BSwingWidget && w != BSwingWidget.this && ((BSwingWidget)w).rootPane != null && ((BSwingWidget)w).rootPane.getGlassPane() != this.glassPane && AwtShellManager.dragOperation == null) {
                BSwingWidget sw = (BSwingWidget)w;
                int zorder = shellManager.getComponentZOrder(sw.rootPane);
                if (zorder != 0) {
                    shellManager.setComponentZOrder(sw.rootPane, 0);
                }
                Component otherGlassPane = sw.rootPane.getGlassPane();
                MouseEvent otherGlassPaneEvent = SwingUtilities.convertMouseEvent(this.glassPane, e, otherGlassPane);
                otherGlassPane.dispatchEvent(otherGlassPaneEvent);
            } else if (e.getID() == 503) {
                shellManager.processMouseMotionEvent(shellEvent);
            } else {
                this.checkDragDrop(shellEvent);
                shellManager.processMouseEvent(shellEvent);
            }
        }

        private void checkDragDrop(MouseEvent e) {
            if (e.getID() == 502 && this.mouseDragged) {
                this.mouseDragged = false;
                if (this.dragSource != null) {
                    this.dragSource.dispatchEvent(e);
                }
            }
        }
    }

    private final class GlassPane
    extends JComponent {
        private GlassPane(Container contentPane) {
            GlassMouseListener mouseListener = new GlassMouseListener(contentPane, this);
            this.addMouseListener(mouseListener);
            this.addMouseMotionListener(mouseListener);
            this.addMouseWheelListener(mouseListener);
        }

        @Override
        public void paintComponent(java.awt.Graphics g) {
            if (!BSwingWidget.this.getEnabled()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
                g2.setColor(Color.lightGray);
                g2.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }
    }

    private static class NullPanel
    extends JPanel {
        private NullPanel() {
        }
    }
}

