/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.PreviewRenderer;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.ui.BWidget;

public class ImagePreviewRenderer
extends PreviewRenderer {
    BImage image;
    RectGeom imageBounds = new RectGeom();
    Point nameLoc = new Point();
    Point sizeLoc = new Point();
    String name = "";
    String size = "";

    public ImagePreviewRenderer(BWidget parent) {
        super(parent);
    }

    @Override
    public void doPaint(Graphics g) {
        g.setBrush(BColor.black);
        g.setFont(Theme.widget().getBoldText());
        g.drawString(this.name, this.nameLoc.x, this.nameLoc.y);
        g.setFont(Theme.widget().getTextFont());
        g.drawString(this.size, this.sizeLoc.x, this.sizeLoc.y);
        if (this.image != null) {
            g.drawImage(this.image, this.imageBounds.x, this.imageBounds.y);
        }
    }

    @Override
    public void doPrepare(double width, double height) {
        this.image = BImage.make((BOrd)this.file.getNavOrd());
        this.image.sync();
        this.name = this.file.getNavDisplayName(null);
        this.size = (int)this.image.getWidth() + "x" + (int)this.image.getHeight();
        BFont font = Theme.widget().getTextFont();
        BFont bold = Theme.widget().getBoldText();
        double ta = font.getAscent();
        double th = font.getHeight();
        double nw = bold.width(this.name);
        double sw = font.width(this.size);
        double iw = this.image.getWidth();
        double ih = this.image.getHeight();
        double cw = width - 2.0;
        double ch = height - 2.0 - th * 2.0;
        if (iw > cw || ih > ch) {
            double scaleX = cw / iw;
            double scaleY = ch / ih;
            double scale = Math.min(scaleX, scaleY);
            this.image = this.image.transform(BTransform.makeScale((double)scale, (double)scale));
        }
        iw = this.image.getWidth();
        ih = this.image.getHeight();
        this.imageBounds.set((width - iw) / 2.0, (height - ih - th * 2.0) / 2.0, iw, ih);
        this.nameLoc.set((width - nw) / 2.0, this.imageBounds.y + ih + ta);
        this.sizeLoc.set((width - sw) / 2.0, this.imageBounds.y + ih + th + ta);
    }
}

