/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class KeyboardLayout {
    private static HashMap<String, KeyboardLayout> layouts = new HashMap();
    private static final BOrd defLayout = BOrd.make((String)"module://bajaui/com/tridium/ui/keyboard.xml");
    private ArrayList<Key[]> rows;

    public static KeyboardLayout make() throws Exception {
        String lang = Sys.getLanguage();
        BOrd ord = null;
        ord = lang.equals("en") ? defLayout : BOrd.make((String)("file:~lexicon/" + lang + "/keyboard.xml"));
        return KeyboardLayout.make(ord);
    }

    public static KeyboardLayout make(BOrd ord) throws Exception {
        KeyboardLayout layout = layouts.get(ord.toString(null));
        if (layout == null) {
            layout = new KeyboardLayout();
            try {
                BIFile file = (BIFile)ord.resolve().get();
                InputStream in = file.getInputStream();
                layout.parse(in);
                layouts.put(ord.toString(null), layout);
            }
            catch (Exception e) {
                System.out.println("### Can't load keyboard for '" + ord.toString(null) + "', falling back to default.");
                BIFile file = (BIFile)defLayout.resolve().get();
                InputStream in = file.getInputStream();
                layout.parse(in);
                layouts.put(ord.toString(null), layout);
            }
        }
        return layout;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getKeyCount(int row) {
        return this.rows.get(row).length;
    }

    public Key getKey(int row, int col) {
        Key[] keys = this.rows.get(row);
        return keys[col];
    }

    public void parse(InputStream in) throws Exception {
        XElem root = XParser.make((InputStream)in).parse();
        if (!root.name().equals("keyboard")) {
            throw new XException("Expecting <keyboard> not <" + root.name() + ">", root);
        }
        if (root.attrSize() != 0) {
            throw new XException("No attributes allowed on <keyboard>", root);
        }
        this.parseRows(root.elems());
    }

    private void parseRows(XElem[] rows) {
        this.rows = new ArrayList();
        for (int i = 0; i < rows.length; ++i) {
            XElem row = rows[i];
            if (!row.name().equals("row")) {
                throw new XException("Expecting <row> not <" + row.name() + ">", row);
            }
            if (row.attrSize() != 0) {
                throw new XException("No attributes allowed on <row>", row);
            }
            this.rows.add(this.parseRow(row.elems()));
        }
    }

    private Key[] parseRow(XElem[] keys) {
        ArrayList<Key> row = new ArrayList<Key>();
        for (int i = 0; i < keys.length; ++i) {
            XElem key = keys[i];
            String c = null;
            String n = null;
            String s = null;
            String a = null;
            String l = null;
            if (!key.name().equals("key")) {
                throw new XException("Expecting <key> not <" + key.name() + ">", key);
            }
            if (key.elems().length != 0) {
                throw new XException("No children allowed in <key>", key);
            }
            for (int j = 0; j < key.attrSize(); ++j) {
                String name = key.attrName(j);
                String val = key.attrValue(j);
                if (name.equals("code")) {
                    c = val;
                    continue;
                }
                if (name.equals("normal")) {
                    n = val;
                    continue;
                }
                if (name.equals("shift")) {
                    s = val;
                    continue;
                }
                if (name.equals("alt")) {
                    a = val;
                    continue;
                }
                if (name.equals("label")) {
                    l = val;
                    continue;
                }
                throw new XException("Invalid attribute for <key>: '" + name + "'", key);
            }
            if (c == null) {
                throw new XException("'code' attribute required for <key>", key);
            }
            if (n == null) {
                throw new XException("'normal' attribute required for <key>", key);
            }
            Key k = new Key();
            try {
                k.code = Integer.parseInt(c);
            }
            catch (NumberFormatException e) {
                throw new XException("'code' value must be an integer: " + c, key);
            }
            if (n.length() != 1) {
                throw new XException("'normal' value must be 1 char long: " + n, key);
            }
            if (s != null && s.length() != 1) {
                throw new XException("'shift' value must be 1 char long: " + s, key);
            }
            if (a != null && a.length() != 1) {
                throw new XException("'alt' value must be 1 char long: " + a, key);
            }
            k.normal = n.charAt(0);
            k.shift = s == null ? k.normal : s.charAt(0);
            k.alt = a == null ? k.normal : a.charAt(0);
            k.label = l;
            row.add(k);
        }
        return row.toArray(new Key[row.size()]);
    }

    public static class Key {
        public int code;
        public char normal;
        public char shift;
        public char alt;
        public String label;
    }
}

