/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.sys.Nre;
import com.tridium.util.ArrayUtil;
import com.tridium.util.BBinderCacheScheme;
import com.tridium.util.BISubstitutableOrdScheme;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;

public class Binder
extends Subscriber {
    public static final long checkItemsDelay = AccessController.doPrivileged(() -> Long.getLong("bajaui.binder.checkItemsDelay", 500L));
    private static final boolean LEGACY_CACHE = AccessController.doPrivileged(() -> Boolean.getBoolean("bajaui.binder.legacyCache"));
    private static final boolean ORD_SUBSTITUTION_DISABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("bajaui.binder.disableOrdSubstitution"));
    public static final Logger log = Logger.getLogger("binder");
    private static final BFacets ENTITY_ENCODING_FACETS = BFacets.make((String)"jsonEntityEncoderShouldEncodeTags", (BIDataValue)BBoolean.FALSE, (String)"jsonEntityEncoderShouldEncodeRelations", (BIDataValue)BBoolean.FALSE);
    static final BOrd[] noOrds = new BOrd[0];
    static final BBinding[] noBindings = new BBinding[0];
    BWidget owner;
    HashMap<BBinding, Item> byBinding = new HashMap();
    HashMap<BOrd, Item> byOrd = new HashMap();
    HashMap<BComponent, Item[]> byTargetComponent = new HashMap();
    protected boolean isAlive = false;
    OrdTarget base;
    Worker worker = null;
    Context context;

    public Binder(BWidget owner) {
        this.owner = owner;
    }

    public synchronized void bind(BBinding binding) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("bind(" + (Object)((Object)binding) + ")");
        }
        BOrd ord = binding.getOrd();
        try {
            if (ord.hasVariables()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Item item = this.byOrd.get(ord);
        if (item == null) {
            item = new Item(ord);
            this.byOrd.put(ord, item);
        }
        item.bindings.add(binding);
        this.byBinding.put(binding, item);
        item.resolved = false;
        this.checkWorker();
    }

    public synchronized void unbind(BBinding binding) {
        Item item;
        if (log.isLoggable(Level.FINER)) {
            log.finer("unbind(" + (Object)((Object)binding) + ")");
        }
        if ((item = this.byBinding.get((Object)binding)) != null) {
            this.byBinding.remove((Object)binding);
            item.bindings.remove((Object)binding);
        }
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public OrdTarget getBase() {
        return this.base;
    }

    public BOrd[] getAllOrds() {
        if (this.byOrd.size() == 0) {
            return noOrds;
        }
        return this.byOrd.keySet().toArray(new BOrd[this.byOrd.size()]);
    }

    public BBinding[] getAllBindings() {
        if (this.byBinding.size() == 0) {
            return noBindings;
        }
        return this.byBinding.keySet().toArray(new BBinding[this.byBinding.size()]);
    }

    public BBinding[] getBindingsForOrd(BOrd ord) {
        Item item = this.byOrd.get(ord);
        if (item == null) {
            return noBindings;
        }
        List<BBinding> b = item.bindings;
        return b.toArray(new BBinding[b.size()]);
    }

    public boolean getAllResolved() {
        boolean resolved = true;
        BBinding[] binds = this.getAllBindings();
        for (int i = 0; i < binds.length; ++i) {
            if (binds[i].isBound()) continue;
            resolved = false;
        }
        return resolved;
    }

    public synchronized void start(OrdTarget base, Context context) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("start(" + base.getOrd() + ")");
        }
        this.base = base;
        this.context = new BasicContext(context, ENTITY_ENCODING_FACETS);
        this.isAlive = true;
        this.checkWorker();
    }

    public void stop() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("stop()");
        }
        this.unsubscribeAll();
        this.isAlive = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = null;
        this.byOrd = null;
        this.byBinding = null;
    }

    public void save(Context cx) throws Exception {
        Array noSpace = new Array(BBinding.class, 16);
        HashMap<BSpace, Array> spaceMap = new HashMap<BSpace, Array>();
        BBinding[] bindings = this.getAllBindings();
        for (int i = 0; i < bindings.length; ++i) {
            if (!bindings[i].isBound()) continue;
            BSpace space = bindings[i].getTarget().getSpace();
            if (space == null) {
                noSpace.add((Object)bindings[i]);
                continue;
            }
            Array spaceBindings = (Array)spaceMap.get(space);
            if (spaceBindings == null) {
                spaceBindings = new Array(BBinding.class);
                spaceMap.put(space, spaceBindings);
            }
            spaceBindings.add((Object)bindings[i]);
        }
        for (Map.Entry entry : spaceMap.entrySet()) {
            BSpace space = (BSpace)entry.getKey();
            Array spaceBindings = (Array)entry.getValue();
            if (space instanceof BComponentSpace) {
                Transaction tx = ((BComponentSpace)space).newTransaction(cx);
                ListIterator i = spaceBindings.iterator();
                while (i.hasNext()) {
                    ((BBinding)((Object)i.next())).save((Context)tx);
                }
                tx.commit();
                continue;
            }
            ListIterator i = spaceBindings.iterator();
            while (i.hasNext()) {
                ((BBinding)((Object)i.next())).save(cx);
            }
        }
    }

    public void event(BComponentEvent event) {
        Item[] items = this.byTargetComponent.get(event.getSourceComponent());
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                items[i].resolved = false;
            }
        }
    }

    protected synchronized void checkWorker() {
        if (this.byBinding.size() > 0 && this.isAlive && this.worker == null) {
            this.worker = new Worker("Ui:Binder:" + this.base.getOrd().toString());
            if (log.isLoggable(Level.FINE)) {
                log.fine("spawn worker; LEGACY_CACHE: " + LEGACY_CACHE + "; ORD_SUBSTITUTION_DISABLED: " + ORD_SUBSTITUTION_DISABLED);
            }
            this.worker.setDaemon(true);
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkItems() {
        Item[] items = null;
        Binder binder = this;
        synchronized (binder) {
            Array acc = new Array(Item.class);
            for (Item item : this.byOrd.values()) {
                BOrd ord = item.ord;
                if (item.resolved || ord == null || ord.isNull()) continue;
                acc.add((Object)item);
            }
            if (acc.size() == 0) {
                return;
            }
            items = (Item[])acc.trim();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("resolve #" + items.length);
        }
        BOrd[] ords = new BOrd[items.length];
        for (int i = 0; i < items.length; ++i) {
            ords[i] = items[i].getOrdToResolve();
        }
        BatchResolve batch = new BatchResolve(ords).resolve(this.base.get(), this.context);
        int len = items.length;
        HashMap<BComponent, BComponent> toSubscribe = new HashMap<BComponent, BComponent>(len * 2);
        for (int i = 0; i < len; ++i) {
            Item item = items[i];
            if (batch.isResolved(i)) {
                item.target = batch.getTarget(i);
                this.postResolve(item, toSubscribe);
            } else if (log.isLoggable(Level.WARNING)) {
                log.warning("unresolved: " + item.toDebugString());
            }
            item.resolved = true;
            item.cacheOrdIfSubstitutable();
        }
        int subscribeSize = toSubscribe.size();
        if (subscribeSize > 0) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("  subscribe #" + subscribeSize);
            }
            try {
                this.subscribe(toSubscribe.values().toArray(new BComponent[subscribeSize]), 0, null);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "subscribe", e);
            }
        }
        try {
            for (int i = 0; i < items.length; ++i) {
                Item item = items[i];
                if (item.target == null || item.targetComponent == null || item.targetComponent == item.target.get()) continue;
                if (this.isCacheable(item)) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("target is cached " + item.toDebugString() + " -> " + item.targetObject);
                    continue;
                }
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("target is not cached " + item.toDebugString() + " -> " + item.targetObject);
                    }
                    item.target = item.getOrdToResolve().resolve(this.base.get(), this.context);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < items.length; ++i) {
            try {
                this.updateBindings(items[i].bindings, items[i].target);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "update", e);
            }
        }
    }

    private boolean isCacheable(Item item) {
        if (LEGACY_CACHE || item.targetObject != item.target.get()) {
            return false;
        }
        return !(item.targetObject instanceof BValue) || BBinderCacheScheme.isCacheableOrd((BOrd)item.ord);
    }

    protected void postResolve(Item item, HashMap<BComponent, BComponent> toSubscribe) {
        BComponent comp;
        if (item.target == null) {
            return;
        }
        item.targetObject = item.target.get();
        if (log.isLoggable(Level.FINER)) {
            log.finer("resolved " + item.toDebugString() + " -> " + item.targetObject);
        }
        if ((comp = item.target.getComponent()) != null && !item.subscribed) {
            item.subscribed = true;
            item.targetComponent = comp;
            toSubscribe.put(comp, comp);
            Object[] itemsByComp = this.byTargetComponent.get(comp);
            itemsByComp = itemsByComp == null ? new Item[]{item} : (Item[])ArrayUtil.addOne((Object[])itemsByComp, (Object)item);
            this.byTargetComponent.put(comp, (Item[])itemsByComp);
        }
    }

    protected void unresolve() {
        Item[] items = this.byBinding.values().toArray(new Item[this.byBinding.size()]);
        for (int i = 0; i < items.length; ++i) {
            items[i].resolved = false;
        }
    }

    protected void updateBindings(List<BBinding> bindings, OrdTarget target) {
        for (int i = 0; i < bindings.size(); ++i) {
            Binder.updateBinding(bindings.get(i), target);
        }
    }

    protected static void updateBinding(BBinding binding, OrdTarget target) {
        block6: {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("  updateBinding " + (Object)((Object)binding));
                }
                binding.fw(303, target, null, null, null);
                binding.targetChanged();
                binding.fireTargetChanged(null);
            }
            catch (Throwable e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                if (!log.isLoggable(Level.WARNING)) break block6;
                log.log(Level.WARNING, e.toString());
            }
        }
        try {
            binding.getWidget().bindingsChanged();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "bindingsChanged", e);
        }
    }

    protected static class Item {
        BOrd ord;
        List<BBinding> bindings;
        boolean resolved;
        OrdTarget target;
        boolean subscribed;
        BComponent targetComponent;
        BObject targetObject;
        BOrd substituteOrd;

        Item(BOrd ord) {
            this.ord = ord;
            this.bindings = new ArrayList<BBinding>(4);
        }

        public String toString() {
            return this.ord.toString();
        }

        public OrdTarget getTarget() {
            return this.target;
        }

        public void removeTarget() {
            this.target = null;
        }

        public BOrd getOrdToResolve() {
            if (this.substituteOrd != null && !this.substituteOrd.isNull()) {
                return this.substituteOrd;
            }
            return this.ord;
        }

        public void cacheOrdIfSubstitutable() {
            if (!ORD_SUBSTITUTION_DISABLED && this.substituteOrd == null) {
                Optional substitutableOrdScheme = BISubstitutableOrdScheme.findSubstitutableOrdScheme((BOrd)this.ord);
                this.substituteOrd = substitutableOrdScheme.map(ordScheme -> ordScheme.convertToSubstituteOrd(this.ord, this.target, null)).orElse(BOrd.NULL);
            }
        }

        public String toDebugString() {
            String result = Objects.toString(this.ord);
            if (this.substituteOrd != null && !this.substituteOrd.isNull()) {
                result = result + " (substituted by " + this.substituteOrd + ')';
            } else if (!this.resolved && (result.startsWith("sys:|") || result.contains("|sys:|"))) {
                result = result + " (ensure the SystemDb is available and/or the base is indexed into the SystemDb)";
            }
            return result;
        }
    }

    class Worker
    extends Thread {
        Worker(String name) {
            super(Nre.mainThreadGroup, name);
        }

        @Override
        public void run() {
            while (Binder.this.isAlive) {
                try {
                    Binder.this.checkItems();
                    Thread.sleep(checkItemsDelay);
                }
                catch (Throwable e) {
                    if (!Binder.this.isAlive) continue;
                    e.printStackTrace();
                }
            }
        }
    }
}

