/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.ui.KeyboardLayout;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;

public class BKeyboard
extends BGridPane {
    public static final Type TYPE = Sys.loadType(BKeyboard.class);
    BTextEditor editor;
    ArrayList<BAbstractButton> buttons = new ArrayList();
    boolean shift = false;
    boolean alt = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BKeyboard() {
        throw new IllegalStateException();
    }

    public BKeyboard(BTextEditor editor, KeyboardLayout keyboard) {
        try {
            this.editor = editor;
            this.setColumnCount(1);
            this.setColumnAlign(BHalign.center);
            this.setRowGap(-1.0);
            KeyboardLayout kb = keyboard == null ? KeyboardLayout.make() : keyboard;
            for (int i = 0; i < kb.getRowCount(); ++i) {
                int kcount = kb.getKeyCount(i);
                BGridPane row = new BGridPane(kcount);
                row.setColumnGap(-1.0);
                if (kcount == 0) {
                    row.add(null, (BValue)new BLabel(""));
                }
                for (int j = 0; j < kcount; ++j) {
                    BAbstractButton button;
                    KeyboardLayout.Key key = kb.getKey(i, j);
                    if (key.code == 16) {
                        button = new BToggleButton(new ShiftCommand(this, key));
                    } else if (key.code == 18) {
                        button = new BToggleButton(new AltCommand(this, key));
                    } else if (key.code >= 37 && key.code <= 40) {
                        key.label = "";
                        button = new BButton(new KeyCommand(this, key));
                        switch (key.code) {
                            case 37: {
                                button.setImage(BImage.make((String)"module://icons/x16/arrowLeft.png"));
                                break;
                            }
                            case 38: {
                                button.setImage(BImage.make((String)"module://icons/x16/arrowUp.png"));
                                break;
                            }
                            case 39: {
                                button.setImage(BImage.make((String)"module://icons/x16/arrowRight.png"));
                                break;
                            }
                            case 40: {
                                button.setImage(BImage.make((String)"module://icons/x16/arrowDown.png"));
                            }
                        }
                    } else {
                        button = new BButton(new KeyCommand(this, key));
                    }
                    button.setPadding(BInsets.make((double)12.0, (double)17.0, (double)12.0, (double)17.0));
                    button.setFont(Theme.button().getFixedWidthBoldFont());
                    row.add(null, (BValue)button);
                    this.buttons.add(button);
                }
                this.add(null, (BValue)row);
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BKeyboard(BTextEditor editor) {
        this(editor, null);
    }

    @Override
    public void computePreferredSize() {
        super.computePreferredSize();
        this.setPreferredSize(this.getPreferredWidth() + 15.0, this.getPreferredHeight());
    }

    public static void main(String[] args) {
        BTextField field = new BTextField();
        BEdgePane pane = new BEdgePane();
        pane.setTop(field);
        pane.setCenter(new BKeyboard(field));
        BFrame f = new BFrame();
        f.setContent(pane);
        f.setScreenBounds(100.0, 200.0, 600.0, 250.0);
        f.open();
    }

    class AltCommand
    extends ToggleCommand {
        KeyboardLayout.Key key;

        AltCommand(BKeyboard owner, KeyboardLayout.Key key) {
            super(owner, key.label);
            this.key = key;
        }

        @Override
        public CommandArtifact doInvoke() {
            BKeyboard.this.alt = this.isSelected();
            for (int i = 0; i < BKeyboard.this.buttons.size(); ++i) {
                BAbstractButton b = BKeyboard.this.buttons.get(i);
                b.setCommand(b.getCommand(), true, false);
            }
            return null;
        }
    }

    class ShiftCommand
    extends ToggleCommand {
        KeyboardLayout.Key key;

        ShiftCommand(BKeyboard owner, KeyboardLayout.Key key) {
            super(owner, key.label);
            this.key = key;
        }

        @Override
        public CommandArtifact doInvoke() {
            BKeyboard.this.shift = this.isSelected();
            for (int i = 0; i < BKeyboard.this.buttons.size(); ++i) {
                BAbstractButton b = BKeyboard.this.buttons.get(i);
                b.setCommand(b.getCommand(), true, false);
            }
            return null;
        }
    }

    class KeyCommand
    extends Command {
        KeyboardLayout.Key key;

        KeyCommand(BKeyboard owner, KeyboardLayout.Key key) {
            super(owner, "");
            this.key = key;
        }

        @Override
        public String getLabel() {
            if (this.key.label != null) {
                return this.key.label;
            }
            if (BKeyboard.this.shift) {
                return "" + this.key.shift;
            }
            if (BKeyboard.this.alt) {
                return "" + this.key.alt;
            }
            return "" + this.key.normal;
        }

        @Override
        public CommandArtifact doInvoke() {
            BWidget owner = this.getOwner();
            int type = 400;
            char ch = this.key.normal;
            int mod = 0;
            if (BKeyboard.this.shift) {
                ch = this.key.shift;
                mod = 1;
            }
            if (BKeyboard.this.alt) {
                ch = this.key.alt;
            }
            if (this.key.label != null && this.key.code != 32 && this.key.code != 10) {
                type = 401;
            }
            if (this.key.code == 8) {
                mod = 0;
            }
            BKeyEvent event = new BKeyEvent(type, owner, mod, this.key.code, ch);
            BKeyboard.this.editor.fireKeyEvent(event);
            return null;
        }
    }
}

