/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import com.tridium.mbus.enums.BMbusUnit;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;

public final class MbusDateCalculator {
    public static BAbsTime calc(BAbsTime inputDate, BMbusUnit inputUnits, int intervalValue, int inputIntervalQty) {
        BAbsTime result = null;
        if (inputUnits.equals((Object)BMbusUnit.seconds)) {
            BRelTime intervalHold = BRelTime.makeSeconds((int)(intervalValue * inputIntervalQty));
            return BAbsTime.make((long)(inputDate.getMillis() - intervalHold.getMillis()));
        }
        if (inputUnits.equals((Object)BMbusUnit.minutes)) {
            BRelTime intervalHold = BRelTime.makeMinutes((int)(intervalValue * inputIntervalQty));
            return BAbsTime.make((long)(inputDate.getMillis() - intervalHold.getMillis()));
        }
        if (inputUnits.equals((Object)BMbusUnit.hours)) {
            BRelTime intervalHold = BRelTime.makeHours((int)(intervalValue * inputIntervalQty));
            return BAbsTime.make((long)(inputDate.getMillis() - intervalHold.getMillis()));
        }
        if (inputUnits.equals((Object)BMbusUnit.days)) {
            BRelTime intervalHold = BRelTime.makeHours((int)(intervalValue * inputIntervalQty * 24));
            return BAbsTime.make((long)(inputDate.getMillis() - intervalHold.getMillis()));
        }
        int year = inputDate.getYear();
        BMonth month = inputDate.getMonth();
        int day = inputDate.getDay();
        int hour = inputDate.getHour();
        int min = inputDate.getMinute();
        int sec = inputDate.getSecond();
        int milli = inputDate.getMillisecond();
        if (inputUnits.equals((Object)BMbusUnit.years)) {
            year -= intervalValue * inputIntervalQty;
        } else if (inputUnits.equals((Object)BMbusUnit.months)) {
            year += (month.getOrdinal() - intervalValue * inputIntervalQty - 11) / 12;
            int monthOrdinal = month.getOrdinal();
            if ((monthOrdinal = (monthOrdinal - intervalValue * inputIntervalQty) % 12) < 0) {
                monthOrdinal = 12 + monthOrdinal;
            }
            month = BMonth.make((int)monthOrdinal);
        }
        result = BAbsTime.make((int)year, (BMonth)month, (int)day, (int)hour, (int)min, (int)sec, (int)milli);
        return result;
    }
}

