/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.types;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.BMbusNetwork;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusCommandCodes;
import com.tridium.mbus.enums.BMbusCommandTypes;
import com.tridium.mbus.enums.BMbusModeChange;
import com.tridium.mbus.enums.BMbusVifCodes;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusTextUtil;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public final class BMbusCommand
extends BComponent {
    public static final Property commandType = BMbusCommand.newProperty((int)0, (BValue)BMbusCommandTypes.none, null);
    public static final Property command = BMbusCommand.newProperty((int)0, (String)"", null);
    public static final Property readoutModeNumber = BMbusCommand.newProperty((int)16, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property modeChange = BMbusCommand.newProperty((int)0, (BValue)BMbusModeChange.incapable, null);
    public static final Property presetDateAndTime = BMbusCommand.newProperty((int)0, (BValue)BAbsTime.now(), null);
    public static final Action execute = BMbusCommand.newAction((int)24, null);
    public static final Type TYPE = Sys.loadType(BMbusCommand.class);

    public BMbusCommandTypes getCommandType() {
        return (BMbusCommandTypes)this.get(commandType);
    }

    public void setCommandType(BMbusCommandTypes v) {
        this.set(commandType, (BValue)v, null);
    }

    public String getCommand() {
        return this.getString(command);
    }

    public void setCommand(String v) {
        this.setString(command, v, null);
    }

    public int getReadoutModeNumber() {
        return this.getInt(readoutModeNumber);
    }

    public void setReadoutModeNumber(int v) {
        this.setInt(readoutModeNumber, v, null);
    }

    public BMbusModeChange getModeChange() {
        return (BMbusModeChange)this.get(modeChange);
    }

    public void setModeChange(BMbusModeChange v) {
        this.set(modeChange, (BValue)v, null);
    }

    public BAbsTime getPresetDateAndTime() {
        return (BAbsTime)this.get(presetDateAndTime);
    }

    public void setPresetDateAndTime(BAbsTime v) {
        this.set(presetDateAndTime, (BValue)v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == execute) {
            this.getNetwork().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BMbusCommand || parent instanceof BMbusDevice;
    }

    public void doExecute() {
        BMbusDevice device = (BMbusDevice)this.getParent();
        if (this.getCommandType().equals((Object)BMbusCommandTypes.none)) {
            return;
        }
        if (device.getReadoutModeNumber() == this.getReadoutModeNumber() || this.getModeChange().equals((Object)BMbusModeChange.capable)) {
            this.doOutputCommand();
            device.setReadoutModeNumber(this.getReadoutModeNumber());
        } else if (this.changeMode(this.getReadoutModeNumber())) {
            this.doOutputCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOutputCommand() {
        BMbusDevice device = (BMbusDevice)this.getParent();
        BAbstractMbusNetwork network = (BAbstractMbusNetwork)((BMbusDevice)this.getParent()).getNetwork();
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace("COMMAND: outputing message");
        }
        String outputCmdLock = "outCmd" + this.getHandle() + "" + Clock.ticks();
        MBusTxTimings txTimingsRef = device.getTxTimingsReference();
        try {
            long minRxTxTimes;
            if (device.getAddressMode() != BMbusAddressing.primary) {
                MbusSndUdMessage message2 = new MbusSndUdMessage(device, network);
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                MbusResponseMessage resp = (MbusResponseMessage)network.sendMBusSync(device.getTxTimingsReference(), outputCmdLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)device.getBaudRate()));
                if (resp != null && resp.getCollisionDetected()) {
                    network.unlockSends(outputCmdLock);
                    throw new Exception("Secondary address selection collision");
                }
                device.setFcBitState(true);
            }
            MbusSndUdMessage message = new MbusSndUdMessage(device, network, this.getByteData());
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
            network.sendMBusSync(txTimingsRef, outputCmdLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)device.getBaudRate()));
            network.unlockSends(outputCmdLock);
        }
        catch (Throwable e) {
            network.unlockSends(outputCmdLock);
        }
        finally {
            network.unlockSends(outputCmdLock);
        }
        device.setReadoutModeNumber(this.getReadoutModeNumber());
    }

    private byte[] getByteData() {
        String outputCommand = this.getCommand().trim();
        int length = outputCommand.length() / 2;
        int outputHoldIndex = 0;
        String tempStringHold = "";
        BStatusNumeric timeHold = new BStatusNumeric((double)this.getPresetDateAndTime().getMillis(), BStatus.ok);
        byte[] outputHold = null;
        int dateLength = 0;
        BMbusCommandCodes currentOutputCode = BMbusCommandCodes.cp_32date;
        if (this.getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime)) {
            if (length > 1) {
                char charHold = outputCommand.charAt(1);
                if (charHold == '2') {
                    dateLength = 2;
                } else if (charHold == '3') {
                    dateLength = 3;
                } else if (charHold == '4') {
                    dateLength = 4;
                }
            }
        } else if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
            currentOutputCode = BMbusCommandCodes.cp_32date;
            timeHold = new BStatusNumeric((double)BAbsTime.now().getMillis(), BStatus.ok);
            if (length == 0) {
                length = 2;
            }
            dateLength = 4;
        } else if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDate)) {
            currentOutputCode = BMbusCommandCodes.cp_16date;
            timeHold = new BStatusNumeric((double)BAbsTime.now().getMillis(), BStatus.ok);
            if (length == 0) {
                length = 2;
            }
            dateLength = 2;
        }
        length += dateLength;
        BMbusCommand[] kids = (BMbusCommand[])this.getChildren(BMbusCommand.class);
        for (int i = 0; i < kids.length; ++i) {
            tempStringHold = kids[i].getCommand().trim();
            length += tempStringHold.length() / 2;
            if (kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
                if (length == 0) {
                    length += 6;
                    continue;
                }
                length += 4;
                continue;
            }
            if (kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDate)) {
                if (length == 0) {
                    length += 4;
                    continue;
                }
                length += 2;
                continue;
            }
            if (!kids[i].getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime) || tempStringHold.length() <= 1) continue;
            char charHold = tempStringHold.charAt(1);
            if (charHold == '2') {
                length += 2;
                continue;
            }
            if (charHold == '3') {
                length += 3;
                continue;
            }
            if (charHold != '4') continue;
            length += 4;
        }
        outputHold = new byte[length];
        for (int m = 0; m < outputCommand.length() / 2; ++m) {
            outputHold[m] = (byte)(MbusTextUtil.hexCharToInt(outputCommand.charAt(m * 2)) * 16 + MbusTextUtil.hexCharToInt(outputCommand.charAt(m * 2 + 1)) & 0xFF);
            if (!MbusLogInputOutput.log.isTraceOn()) continue;
            MbusLogInputOutput.log.trace("COMMAND: output hold= " + outputHold[m]);
        }
        if (outputHold.length > 0) {
            if (outputHold[0] == 2) {
                currentOutputCode = BMbusCommandCodes.cp_16date;
            } else if (outputHold[0] == 3) {
                currentOutputCode = BMbusCommandCodes.timeOfDay;
            }
        }
        outputHoldIndex = outputCommand.length() / 2;
        if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime) && outputCommand.length() < 2) {
            outputHold[0] = (byte)BMbusCommandCodes.mbus_integer32bit.getOrdinal();
            outputHold[1] = (byte)BMbusVifCodes.dateAndTime.getOrdinal();
            outputHoldIndex += 2;
        }
        if (this.getCommandType().equals((Object)BMbusCommandTypes.currentDate) && outputCommand.length() < 2) {
            outputHold[0] = (byte)BMbusCommandCodes.mbus_integer16bit.getOrdinal();
            outputHold[1] = (byte)BMbusVifCodes.date.getOrdinal();
            outputHoldIndex += 2;
        }
        if (this.getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime) || this.getCommandType().equals((Object)BMbusCommandTypes.currentDate) || this.getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
            byte[] outputBytes = MbusDataDecoderIEC870.encode((BStatusValue)timeHold, currentOutputCode);
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("COMMAND: outputBytesLength= " + outputBytes.length + " outputHold length = " + outputHold.length + " outputHoldIndex = " + outputHoldIndex);
            }
            for (int k = 0; k < outputBytes.length; ++k) {
                if (outputHoldIndex + k >= outputHold.length) continue;
                outputHold[k + outputHoldIndex] = outputBytes[k];
            }
            outputHoldIndex += outputBytes.length;
        }
        for (int i = 0; i < kids.length; ++i) {
            String commandHold = kids[i].getCommand().trim();
            int commandLength = commandHold.length() / 2;
            currentOutputCode = BMbusCommandCodes.mbus_integer32bit;
            timeHold = kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime) || kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDate) ? new BStatusNumeric((double)BAbsTime.now().getMillis(), BStatus.ok) : new BStatusNumeric((double)kids[i].getPresetDateAndTime().getMillis(), BStatus.ok);
            for (int j = 0; j < commandLength; ++j) {
                outputHold[j + outputHoldIndex] = (byte)(MbusTextUtil.hexCharToInt(commandHold.charAt(j * 2)) * 16 + MbusTextUtil.hexCharToInt(commandHold.charAt(j * 2 + 1)) & 0xFF);
            }
            if (commandLength > 1) {
                if (outputHold[outputHoldIndex] == 2) {
                    currentOutputCode = BMbusCommandCodes.cp_16date;
                } else if (outputHold[outputHoldIndex] == 3) {
                    currentOutputCode = BMbusCommandCodes.timeOfDay;
                }
                outputHoldIndex += commandLength;
            } else if (kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime)) {
                outputHold[outputHoldIndex] = (byte)BMbusCommandCodes.mbus_integer32bit.getOrdinal();
                outputHold[outputHoldIndex] = (byte)BMbusVifCodes.dateAndTime.getOrdinal();
                outputHoldIndex += 2;
            } else if (kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDate)) {
                outputHold[outputHoldIndex] = (byte)BMbusCommandCodes.mbus_integer16bit.getOrdinal();
                outputHold[outputHoldIndex] = (byte)BMbusVifCodes.date.getOrdinal();
                outputHoldIndex += 2;
            }
            if (!kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDateAndTime) && !kids[i].getCommandType().equals((Object)BMbusCommandTypes.currentDate) && !kids[i].getCommandType().equals((Object)BMbusCommandTypes.commandWithPresetDateAndTime)) continue;
            byte[] outputBytes = MbusDataDecoderIEC870.encode((BStatusValue)timeHold, currentOutputCode);
            for (int k = 0; k < outputBytes.length; ++k) {
                outputHold[k + outputHoldIndex] = outputBytes[k];
            }
            outputHoldIndex += outputBytes.length;
        }
        return outputHold;
    }

    public boolean changeMode(int inputModeNumber) {
        BMbusDevice device = (BMbusDevice)this.getParent();
        boolean validMode = true;
        if (device != null && device.getReadoutModeNumber() != inputModeNumber) {
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("COMMAND: We are trying to Change Mode, input = " + inputModeNumber);
            }
            validMode = false;
            BMbusCommand[] kids = (BMbusCommand[])device.getChildren(BMbusCommand.class);
            for (int i = 0; i < kids.length; ++i) {
                if (kids[i].getReadoutModeNumber() != inputModeNumber || !kids[i].getModeChange().equals((Object)BMbusModeChange.capable)) continue;
                kids[i].doExecute();
                validMode = true;
                break;
            }
        }
        return validMode;
    }

    private BMbusNetwork getNetwork() {
        return this.findNetwork((BComponent)this.getParent());
    }

    private BMbusNetwork findNetwork(BComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof BMbusNetwork) {
            return (BMbusNetwork)comp;
        }
        return this.findNetwork((BComponent)comp.getParent());
    }
}

