/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.types;

import com.tridium.mbus.utils.MbusTextUtil;
import com.tridium.mbus.utils.MbusToolkit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.BIEncodable;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BEncodableList
extends BSimple {
    public static final BEncodableList NULL;
    public static final BEncodableList DEFAULT;
    private BIEncodable[] ens = null;
    private static final char SEPARATOR = '|';
    private int hashCode = 0;
    public static final Type TYPE;

    private BEncodableList(BIEncodable[] ens) {
        this.ens = ens;
    }

    public static BEncodableList make(BIEncodable[] ens) {
        if (ens == null) {
            return NULL;
        }
        return new BEncodableList((BIEncodable[])ens.clone());
    }

    public static BEncodableList make(int[] nums) {
        if (nums == null) {
            return NULL;
        }
        BIEncodable[] newEns = new BIEncodable[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            newEns[i] = BInteger.make((int)nums[i]);
        }
        return BEncodableList.make(newEns);
    }

    public static BEncodableList make(long[] longs) {
        if (longs == null) {
            return NULL;
        }
        BIEncodable[] newEns = new BIEncodable[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            newEns[i] = BLong.make((long)longs[i]);
        }
        return BEncodableList.make(newEns);
    }

    public static BEncodableList make(String[] strs) {
        if (strs == null) {
            return NULL;
        }
        BIEncodable[] newEns = new BIEncodable[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            newEns[i] = BString.make((String)strs[i]);
        }
        return BEncodableList.make(newEns);
    }

    public static BEncodableList make(double[] doubles) {
        if (doubles == null) {
            return NULL;
        }
        BIEncodable[] newEns = new BIEncodable[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            newEns[i] = BDouble.make((double)doubles[i]);
        }
        return BEncodableList.make(newEns);
    }

    public static BEncodableList make(float[] floats) {
        if (floats == null) {
            return NULL;
        }
        BIEncodable[] newEns = new BIEncodable[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            newEns[i] = BFloat.make((float)floats[i]);
        }
        return BEncodableList.make(newEns);
    }

    public BIEncodable get(int index) {
        return this.ens[index];
    }

    public int size() {
        return this.ens.length;
    }

    public boolean isNull() {
        return this.ens.length == 0;
    }

    public BIEncodable[] toArray() {
        return (BIEncodable[])this.ens.clone();
    }

    public int[] toIntArray() {
        int[] ints = new int[this.ens.length];
        for (int i = 0; i < this.ens.length; ++i) {
            ints[i] = ((BInteger)this.ens[i]).getInt();
        }
        return ints;
    }

    public long[] toLongArray() {
        long[] longs = new long[this.ens.length];
        for (int i = 0; i < this.ens.length; ++i) {
            longs[i] = ((BLong)this.ens[i]).getLong();
        }
        return longs;
    }

    public String[] toStringArray() {
        String[] strs = new String[this.ens.length];
        for (int i = 0; i < this.ens.length; ++i) {
            strs[i] = ((BString)this.ens[i]).getString();
        }
        return strs;
    }

    public double[] toDoubleArray() {
        double[] doubles = new double[this.ens.length];
        for (int i = 0; i < this.ens.length; ++i) {
            doubles[i] = ((BDouble)this.ens[i]).getDouble();
        }
        return doubles;
    }

    public float[] toFloatArray() {
        float[] floats = new float[this.ens.length];
        for (int i = 0; i < this.ens.length; ++i) {
            floats[i] = ((BFloat)this.ens[i]).getFloat();
        }
        return floats;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int x = 11;
            for (int i = 0; i < this.ens.length; ++i) {
                x ^= this.ens[i].hashCode();
            }
            this.hashCode = x;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BIEncodable) {
            BIEncodable[] a = this.ens;
            BIEncodable[] b = ((BEncodableList)((Object)obj)).ens;
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() {
        StringBuffer buff = new StringBuffer();
        if (this.ens.length > 0) {
            try {
                buff.append(this.ens[0].getType().toString());
                for (int i = 0; i < this.ens.length; ++i) {
                    buff.append('|');
                    buff.append(this.ens[i].encodeToString());
                }
            }
            catch (IOException e) {
                MbusToolkit.error("Error encoding encodables to string");
            }
        }
        return buff.toString();
    }

    public BObject decodeFromString(String s) {
        if (s.length() <= 1) {
            return DEFAULT;
        }
        String[] strs = MbusTextUtil.splitAndTrim(s, '|');
        BIEncodable[] newEns = new BIEncodable[strs.length - 1];
        try {
            BIEncodable e = null;
            for (int i = 0; i < strs.length; ++i) {
                if (i == 0) {
                    e = (BIEncodable)Sys.getType((String)strs[i]).getInstance();
                    continue;
                }
                newEns[i - 1] = (BIEncodable)e.decodeFromString(strs[i]);
            }
        }
        catch (Exception e) {
            MbusToolkit.error("Error parsing encodables", e);
        }
        return new BEncodableList(newEns);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BEncodableList(new BIEncodable[0]);
        TYPE = Sys.loadType(BEncodableList.class);
    }
}

