/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BBasicPollGroup;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.point.BMbusProxyExt;
import com.tridium.mbus.types.BMbusCommand;
import com.tridium.mbus.utils.MbusDataSort;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusSortedDataInformation;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BMbusPollGroup
extends BBasicPollGroup
implements BIBasicPollable {
    public static final Type TYPE = Sys.loadType(BMbusPollGroup.class);
    private static Lexicon lex = Lexicon.make(BMbusProxyExt.class);
    private static int[] manufacturersData = null;
    private boolean sucessfulRead = false;

    public Type getType() {
        return TYPE;
    }

    public void poll() {
        String commLock = "pg" + Clock.ticks();
        BBasicProxyExt[] subscribedProxies = this.getSubscribedProxyExts();
        BAbstractMbusNetwork network = (BAbstractMbusNetwork)subscribedProxies[0].getNetwork();
        try {
            this.commsProtectedPoll(subscribedProxies, network, commLock);
            network.unlockSends(commLock);
        }
        catch (Throwable t) {
            network.unlockSends(commLock);
        }
    }

    public void commsProtectedPoll(BBasicProxyExt[] subscribedProxies, BAbstractMbusNetwork network, Object commlock) {
        MbusResponseMessage rsp;
        long minRxTxTimes;
        MbusSndUdMessage message2;
        boolean validMode = false;
        if (subscribedProxies.length == 0) {
            return;
        }
        BMbusDevice device = (BMbusDevice)subscribedProxies[0].getDevice();
        MBusTxTimings txTimings = device.getTxTimingsReference();
        if (device.getResetRequired()) {
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Poll Reset to Meter:- " + device.getPrimaryAddress() + "Sec Add= " + device.getSecondaryAddress());
            }
            if (device.getAddressMode() != BMbusAddressing.primary) {
                message2 = new MbusSndUdMessage(device, network);
                message2.setMessageBaudRate(device.getBaudRate());
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                rsp = (MbusResponseMessage)network.sendMBusSync(txTimings, commlock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)device.getBaudRate()));
                if (rsp == null || rsp != null && !rsp.getSuccessfulResponse() || rsp != null && rsp.getCollisionDetected()) {
                    if (device.isMounted() && MbusLogInputOutput.log.isLoggable(2)) {
                        MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Failed to get response to initial secondary address selection " + (rsp != null && rsp.getCollisionDetected() ? "(COLLISION)" : ""));
                    }
                } else {
                    device.setFcBitState(true);
                }
            }
            device.doSendNkeAndInitDelay(txTimings, commlock);
        }
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace("Handling group poll for device : " + (device.isMounted() ? device.getDisplayName(null) : "unknown"));
        }
        if (device.getAddressMode() != BMbusAddressing.primary) {
            message2 = new MbusSndUdMessage(device, network);
            message2.setMessageBaudRate(device.getBaudRate());
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
            minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)device.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Sending secondary address selector");
            }
            if ((rsp = (MbusResponseMessage)network.sendMBusSync(txTimings, commlock, message2, minRxTxTimes)) == null || rsp != null && !rsp.getSuccessfulResponse() || rsp != null && rsp.getCollisionDetected()) {
                if (MbusLogInputOutput.log.isLoggable(2) && device.isMounted()) {
                    if (rsp != null && rsp.getCollisionDetected()) {
                        MbusLogInputOutput.log.warning(device.getDisplayName(null) + " Bus collision detected - cannot select address for device - maybe secondary extended selection is required");
                    } else {
                        MbusLogInputOutput.log.warning(device.getDisplayName(null) + " Failed to select secondary addressing after reset - the device may require a longer reset time");
                    }
                }
                for (int j = 0; j < subscribedProxies.length; ++j) {
                    if (this.sucessfulRead) {
                        subscribedProxies[j].readReset();
                        continue;
                    }
                    if (rsp != null && rsp.getCollisionDetected()) {
                        subscribedProxies[j].readFail(lex.getText("BMbusGeneral.busSelectionFailure"));
                        continue;
                    }
                    subscribedProxies[j].readFail(lex.getText("BMbusPollGroup.readSecSelectFail"));
                }
                if (rsp != null && rsp.getCollisionDetected()) {
                    return;
                }
            } else {
                device.setFcBitState(true);
            }
        }
        BMbusCommand[] kids = (BMbusCommand[])device.getChildren(BMbusCommand.class);
        if (subscribedProxies.length > 0) {
            BMbusProxyExt initialProxy = (BMbusProxyExt)subscribedProxies[0];
            if (initialProxy.getDeviceMode() != device.getReadoutModeNumber()) {
                if (kids.length > 0 && kids[0].changeMode(initialProxy.getDeviceMode())) {
                    validMode = true;
                }
            } else {
                validMode = true;
            }
        }
        BBasicProxyExt[] proxiesToUpdate = new BBasicProxyExt[subscribedProxies.length];
        System.arraycopy(subscribedProxies, 0, proxiesToUpdate, 0, subscribedProxies.length);
        for (int msgIndex = 0; msgIndex < device.getCycleQuantity(); ++msgIndex) {
            byte[] byteHold;
            MbusReqUd2Message commandMessage = new MbusReqUd2Message(device, network);
            commandMessage.setMessageBaudRate(device.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Poll to Meter:- " + device.getPrimaryAddress() + " ,Sec Add= " + device.getSecondaryAddress() + "  Cycle= " + msgIndex);
            }
            MbusResponseMessage rsp2 = null;
            long minRxTxTimes2 = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)device.getBaudRate());
            minRxTxTimes2 += MBusTxTimings.calculateTxRxTime(commandMessage, (BBaudRate)device.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn() && device.isMounted()) {
                MbusLogInputOutput.log.trace(device.getDisplayName(null) + " Sending data request");
            }
            if ((rsp2 = (MbusResponseMessage)network.sendMBusSync(txTimings, commlock, commandMessage, minRxTxTimes2)) == null) {
                String errorMessage = lex.getText("BMbusPollGroup.readNull");
                for (int j = 0; j < subscribedProxies.length; ++j) {
                    subscribedProxies[j].readFail(errorMessage);
                }
                if (device.getInhibitPing()) {
                    device.pingFail("timeout");
                }
                return;
            }
            if (!rsp2.getSuccessfulResponse()) {
                for (int k = 0; k < subscribedProxies.length; ++k) {
                    String errorMessage = lex.getText("BMbusPollGroup.pollError");
                    subscribedProxies[k].readFail(errorMessage);
                }
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("POLL_GRP: read fail");
                }
                return;
            }
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("BMBUSPOLLGROUP: We have valid message");
            }
            if ((byteHold = rsp2.getBytes()).length <= 8) continue;
            MbusReceivedLongFrame longFrameMessage = null;
            longFrameMessage = new MbusReceivedLongFrame(rsp2, network, device, device.getAllowMultipleRecords(), device.getMaxSpecialFunctionReads());
            boolean addressErrorDetected = false;
            if (device.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                if (device.getPrimaryAddress() != longFrameMessage.getPrimaryAddress()) {
                    addressErrorDetected = true;
                }
            } else if (device.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
                if (!device.getSecondaryAddress().equals(longFrameMessage.getSecondaryAddress())) {
                    addressErrorDetected = true;
                }
            } else if (device.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended) && !device.getSecondaryAddress().equals(longFrameMessage.getSecondaryAddress())) {
                addressErrorDetected = true;
            }
            device.setMbusMeterStatusDescription(longFrameMessage.getStatus());
            device.setManufacturerStatusBit5(longFrameMessage.getStatusBit5());
            device.setManufacturerStatusBit6(longFrameMessage.getStatusBit6());
            device.setManufacturerStatusBit7(longFrameMessage.getStatusBit7());
            if (addressErrorDetected) {
                for (int k = 0; k < subscribedProxies.length; ++k) {
                    String errorMessage = lex.getText("BMbusPollGroup.AddressError");
                    subscribedProxies[k].readFail(errorMessage);
                }
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Response Message: Wrong Meter!");
                }
                return;
            }
            if (!network.savesActive()) {
                network.getNetworkDatabase().addDeviceData(null, longFrameMessage, msgIndex, device.getBaudRate(), device, device.getAddressMode(), null);
            } else if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Not updating database this time, as station save is in progress");
            }
            if (!longFrameMessage.getFabricationNumber().equals("")) {
                device.setFabricationNumber(longFrameMessage.getFabricationNumber());
            }
            if (longFrameMessage.getManufacturerIndex() != -1) {
                try {
                    int startOfManufacturersData = longFrameMessage.getManufacturerIndex();
                    int lengthOfManufSpecData = byteHold.length - startOfManufacturersData - 2;
                    if (lengthOfManufSpecData > 0) {
                        manufacturersData = new int[lengthOfManufSpecData];
                        for (int i = 0; i < lengthOfManufSpecData; ++i) {
                            BMbusPollGroup.manufacturersData[i] = byteHold[startOfManufacturersData + i];
                        }
                    }
                }
                catch (Throwable e) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Unexpected condition hit: when extracting manufacturers data");
                        MbusToolkit.trace("manufacturerIndex : " + longFrameMessage.getManufacturerIndex());
                        MbusToolkit.trace("lengthOfManufSpecData : " + byteHold.length + " - " + longFrameMessage.getManufacturerIndex() + " - 2");
                        MbusToolkit.trace("lengthOfManufSpecData = " + (byteHold.length - longFrameMessage.getManufacturerIndex() - 2));
                        MbusToolkit.trace("longFrameMessage : " + longFrameMessage.toDebugString());
                    }
                    return;
                }
            }
            for (int m = 0; m < proxiesToUpdate.length; ++m) {
                if (proxiesToUpdate[m] == null) continue;
                boolean inputValid = false;
                BMbusProxyExt proxyExt = (BMbusProxyExt)subscribedProxies[m];
                BStatusValue lastTimesValue = proxyExt.getReadValue();
                if (proxyExt.getDeviceMode() != device.getReadoutModeNumber()) {
                    validMode = false;
                }
                BStatusValue inputValue = null;
                if (proxyExt.getManuSpecDefElementOrd().isNull()) {
                    MbusSortedDataInformation[] sortedData = MbusDataSort.sort(longFrameMessage, proxyExt.getMbusUnit(), proxyExt.getDescription(), proxyExt.getOrthogonalDescription(), proxyExt.getMessageSlotNumber(), proxyExt.getRecordNumber(), proxyExt.getStorageNumber(), proxyExt.getFunction(), proxyExt.getExponent(), true);
                    if (sortedData != null && sortedData.length > 0) {
                        inputValue = sortedData[sortedData.length - 1].value;
                    }
                } else {
                    inputValue = ((BManuSpecDefElement)proxyExt.getManuSpecDefElementOrd().get((BObject)network)).getValue(manufacturersData);
                }
                if (inputValue != null && validMode) {
                    BStatusString hold;
                    BAbsTime timeHold;
                    if (inputValue instanceof BStatusString) {
                        proxyExt.readOk(inputValue);
                        inputValid = true;
                    } else if (lastTimesValue instanceof BStatusString) {
                        if (inputValue instanceof BStatusNumeric) {
                            if (proxyExt.getNumberType().equals((Object)BMbusNumberType.dateIp)) {
                                timeHold = BAbsTime.make((long)((long)((BStatusNumeric)inputValue).getValue()));
                                hold = new BStatusString(timeHold.encodeToString(), BStatus.ok);
                                proxyExt.readOk((BStatusValue)hold);
                                inputValid = true;
                            } else {
                                proxyExt.readFail("Input was Numeric and expected a String");
                                inputValid = true;
                            }
                        } else {
                            proxyExt.readFail("Input was Numeric and expected a String");
                            inputValid = true;
                        }
                    } else if (lastTimesValue instanceof BStatusNumeric && inputValue instanceof BStatusNumeric || lastTimesValue instanceof BStatusEnum && inputValue instanceof BStatusEnum || lastTimesValue instanceof BStatusBoolean && inputValue instanceof BStatusBoolean) {
                        if (inputValue instanceof BStatusNumeric) {
                            if (proxyExt.getNumberType().equals((Object)BMbusNumberType.dateIp)) {
                                timeHold = BAbsTime.make((long)((long)((BStatusNumeric)inputValue).getValue()));
                                hold = new BStatusString(timeHold.encodeToString(), BStatus.ok);
                                proxyExt.readOk((BStatusValue)hold);
                                inputValid = true;
                            } else {
                                proxyExt.readOk(inputValue);
                                inputValid = true;
                            }
                        } else {
                            proxyExt.readOk(inputValue);
                            inputValid = true;
                        }
                    } else {
                        proxyExt.readFail("Input was incorrect type");
                    }
                }
                if (!inputValid) continue;
                proxiesToUpdate[m] = null;
            }
        }
        for (int i = 0; i < proxiesToUpdate.length; ++i) {
            if (proxiesToUpdate[i] == null) continue;
            BStatusValue currentValue = proxiesToUpdate[i].getReadValue();
            currentValue.setStatus(16);
            proxiesToUpdate[i].readOk(currentValue);
        }
    }

    public BPollFrequency getPollFrequency() {
        BBasicProxyExt[] subscribedProxies = this.getSubscribedProxyExts();
        if (subscribedProxies.length == 0) {
            return BPollFrequency.normal;
        }
        for (int i = 0; i < subscribedProxies.length; ++i) {
            if (!subscribedProxies[i].isRunning()) continue;
            return ((BMbusDevice)subscribedProxies[0].getDevice()).getPollFrequency();
        }
        return BPollFrequency.normal;
    }
}

