/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.point;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.point.BMbusPointFolder;
import com.tridium.mbus.point.BMbusProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BMbusPointDeviceExt
extends BPointDeviceExt {
    public static final Type TYPE = Sys.loadType(BMbusPointDeviceExt.class);

    public Type getType() {
        return TYPE;
    }

    public final BAbstractMbusNetwork getMbusNetwork() {
        return (BAbstractMbusNetwork)this.getNetwork();
    }

    public final BMbusDevice getMbusDevice() {
        return (BMbusDevice)this.getDevice();
    }

    public Type getDeviceType() {
        return BMbusDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BMbusPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BMbusProxyExt.TYPE;
    }

    public int getMaxMessageRequired() {
        boolean cycleCountsRelevant = !this.getMbusDevice().getAllowMultipleRecords();
        BControlPoint[] points = this.getPoints();
        int maxMessageRequired = 0;
        for (int i = 0; i < points.length; ++i) {
            int cycleCount;
            BMbusProxyExt proxy = (BMbusProxyExt)points[i].getProxyExt();
            if (!proxy.getManuSpecDefElementOrd().isNull()) {
                return 1000;
            }
            int recordNumber0based = proxy.getRecordNumber();
            if (recordNumber0based > maxMessageRequired) {
                maxMessageRequired = recordNumber0based;
            }
            if (!cycleCountsRelevant || (cycleCount = proxy.getCycleNumber()) <= maxMessageRequired) continue;
            maxMessageRequired = cycleCount;
        }
        return maxMessageRequired;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BControlPoint && ((BControlPoint)oldValue).getProxyExt() instanceof BMbusProxyExt) {
            this.getMbusDevice().optimiseReads();
        }
    }
}

