/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.utils.MbusTextUtil;

public final class MbusSndUdMessage
extends MbusMessage {
    public MbusSndUdMessage(BMbusDevice device, BAbstractMbusNetwork network) {
        this.setCFieldNoFcb(67);
        this.setFcBitInUse(false);
        this.setFcBitState(false);
        if (device != null) {
            if (!device.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                this.setStartCode(104);
                this.setFrame(2);
                this.setAField(253);
                this.setCiField(82);
                String secondaryAddress = device.getSecondaryAddress().trim();
                if (device.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended)) {
                    secondaryAddress = secondaryAddress + "0C7800000000";
                }
                byte[] output = new byte[secondaryAddress.length() / 2];
                for (int i = 0; i < output.length; ++i) {
                    if (i > 3) {
                        output[i] = (byte)(MbusTextUtil.hexCharToInt(secondaryAddress.charAt(i * 2)) << 4 | MbusTextUtil.hexCharToInt(secondaryAddress.charAt(i * 2 + 1)));
                        continue;
                    }
                    output[3 - i] = (byte)(MbusTextUtil.hexCharToInt(secondaryAddress.charAt(i * 2)) << 4 | MbusTextUtil.hexCharToInt(secondaryAddress.charAt(i * 2 + 1)));
                }
                if (device.getAddressMode().equals((Object)BMbusAddressing.secondaryExtended)) {
                    String deviceFabricationNumberHold = device.getFabricationNumber();
                    for (int j = 0; j < 4; ++j) {
                        output[output.length - j - 1] = (byte)(MbusTextUtil.hexCharToInt(deviceFabricationNumberHold.charAt(j * 2)) << 4 | MbusTextUtil.hexCharToInt(deviceFabricationNumberHold.charAt(j * 2 + 1)));
                    }
                }
                this.setBytes(output);
                if (device.getFcBitInUse()) {
                    this.setFcBitInUse(true);
                    this.setFcBitState(device.getFcBitState());
                    network.setSearchFcBitState(!device.getFcBitState());
                }
            }
        } else if (network != null) {
            this.setAField(network.getPrimarySearchAddress());
            if (network.getSearchFcBitInUse()) {
                this.setFcBitInUse(true);
                this.setFcBitState(network.getSearchFcBitState());
                network.setSearchFcBitState(!network.getSearchFcBitState());
            }
        }
    }

    public MbusSndUdMessage(BMbusDevice device, BAbstractMbusNetwork network, byte[] inputData) {
        this.setCFieldNoFcb(67);
        this.setFcBitInUse(false);
        this.setFcBitState(false);
        if (device != null) {
            if (device.getFcBitInUse()) {
                this.setFcBitInUse(true);
                this.setFcBitState(device.getFcBitState());
                device.setFcBitState(!device.getFcBitState());
            }
            if (device.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                this.setAField(device.getPrimaryAddress());
            } else {
                this.setAField(253);
            }
            if (inputData != null) {
                this.setBytes(inputData);
                this.setFrame(2);
            }
        } else if (network != null) {
            this.setAField(network.getPrimarySearchAddress());
            if (network.getSearchFcBitInUse()) {
                this.setFcBitInUse(true);
                this.setFcBitState(network.getSearchFcBitState());
                network.setSearchFcBitState(!network.getSearchFcBitState());
            }
        }
    }

    public MbusSndUdMessage(byte[] outputData) {
        this.setCFieldNoFcb(83);
        this.setStartCode(104);
        this.setFrame(2);
        this.setAField(253);
        this.setCiField(82);
        this.setBytes(outputData);
    }
}

