/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.messages.MbusReceivedMessage;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.utils.MbusCrcGenerator;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import java.io.OutputStream;
import javax.baja.nre.util.ByteArrayUtil;

public abstract class MbusMessage
extends Message {
    protected byte[] outputData = new byte[5];
    protected byte[] data = null;
    int startCode = 16;
    int cField = 0;
    int ciField = 81;
    int aField = 0;
    int chksum = 0;
    int stop = 22;
    boolean fcBitInUse = false;
    boolean fcBitState = false;
    int startCodeIndex = 0;
    int cFieldIndex = 1;
    int aFieldIndex = 2;
    int chkSumIndex = 3;
    int stopIndex = 4;
    int ciFieldIndex = 0;
    int lFieldIndex = 0;
    BMbusBaudRate baudRate = BMbusBaudRate.baud2400;
    int frame = 0;
    String secondaryAdd = "";
    boolean allowForBusCollissions = false;

    public MbusMessage() {
        this.setResponseExpected(true);
    }

    public Message toResponse(ReceivedMessage input) {
        MbusResponseMessage responseMessage = new MbusResponseMessage((MbusReceivedMessage)input);
        return responseMessage;
    }

    public String toDebugString() {
        if (this.data != null) {
            return ByteArrayUtil.toHexString((byte[])this.data, (int)0, (int)this.data.length);
        }
        return "";
    }

    public byte[] getBytes() {
        return this.outputData;
    }

    public void setBytes(byte[] data) {
        this.data = data;
    }

    public int getLength() {
        return this.data.length;
    }

    public void setAField(int input) {
        this.aField = input;
    }

    public int getAField() {
        return this.aField;
    }

    public void setSecondaryAdd(String input) {
        this.secondaryAdd = input;
    }

    public String getSecondaryAdd() {
        return this.secondaryAdd;
    }

    public void setCFieldNoFcb(int input) {
        this.cField = input;
    }

    public void setCiField(int input) {
        this.ciField = input;
    }

    public int getCField() {
        return this.cField;
    }

    public boolean getFcBitInUse() {
        return this.fcBitInUse;
    }

    public void setFcBitInUse(boolean input) {
        this.fcBitInUse = input;
    }

    public boolean getFcBitState() {
        return this.fcBitState;
    }

    public void setFcBitState(boolean input) {
        this.fcBitState = input;
    }

    public void setMessageBaudRate(BMbusBaudRate input) {
        this.baudRate = input;
    }

    public BMbusBaudRate getMessageBaudRate() {
        return this.baudRate;
    }

    public void setFrame(int input) {
        this.frame = input;
    }

    public void setStartCode(int input) {
        this.startCode = input;
    }

    public int getWriteBytesLength() {
        if (this.frame == 0) {
            return 5;
        }
        if (this.frame == 1) {
            return 9;
        }
        if (this.frame == 2) {
            return 9 + this.data.length;
        }
        return 261;
    }

    public void write(OutputStream out) {
        try {
            int fcBit = 0;
            int fcBitValid = 0;
            if (this.fcBitInUse) {
                fcBitValid = 16;
                if (this.fcBitState) {
                    fcBit = 32;
                }
            }
            if (this.frame == 0) {
                this.outputData = new byte[5];
                this.outputData[0] = 16;
                this.outputData[1] = (byte)(this.cField | fcBit | fcBitValid);
                this.outputData[2] = (byte)this.aField;
            } else if (this.frame == 1) {
                this.outputData = new byte[9];
                this.outputData[0] = 104;
                this.outputData[1] = 3;
                this.outputData[2] = 3;
                this.outputData[3] = 104;
                this.outputData[4] = (byte)(this.cField | fcBit | fcBitValid);
                this.outputData[5] = (byte)this.aField;
                this.outputData[6] = (byte)this.ciField;
            } else if (this.frame == 2) {
                int outputLength = 9 + this.data.length;
                this.outputData = new byte[outputLength];
                this.outputData[0] = 104;
                this.outputData[1] = (byte)(this.outputData.length - 6);
                this.outputData[2] = (byte)(this.outputData.length - 6);
                this.outputData[3] = 104;
                this.outputData[4] = (byte)(this.cField | fcBit | fcBitValid);
                this.outputData[5] = (byte)this.aField;
                this.outputData[6] = (byte)this.ciField;
                for (int i = 0; i < this.data.length; ++i) {
                    this.outputData[i + 7] = this.data[i];
                }
            } else {
                return;
            }
            this.outputData[this.outputData.length - 2] = MbusCrcGenerator.mBus(this.outputData);
            this.outputData[this.outputData.length - 1] = 22;
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Output Message = " + ByteArrayUtil.toHexString((byte[])this.outputData, (int)0, (int)this.outputData.length));
            }
            out.write(this.outputData);
        }
        catch (Exception e) {
            MbusToolkit.error("Error writing bytes to output stream", e);
        }
    }

    public void handleCorruptBuffers() {
        this.allowForBusCollissions = true;
    }

    public boolean getHandleCorruptBuffers() {
        return this.allowForBusCollissions;
    }
}

