/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.jobs.BMbusDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusPrimaryDeviceSearchJob;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.driver.BDevice;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMbusUpdateDevicesJob
extends BMbusPrimaryDeviceSearchJob {
    public static final Type TYPE = Sys.loadType(BMbusUpdateDevicesJob.class);
    protected BMbusDevice[] devicesToUpdate = null;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BMbusUpdateDevicesJob() {
    }

    public BMbusUpdateDevicesJob(BAbstractMbusNetwork networkRef) {
        this.networkRef = networkRef;
    }

    public void setDevicesToUpdate(BMbusDevice[] devices) {
        if (Sys.getStation() == null) {
            throw new RuntimeException("Error: BMbusUpdateDevicesJob.setDevicesToUpdate called in non station based enviroment!");
        }
        this.devicesToUpdate = devices;
    }

    @Override
    public void run(Context cx) throws Exception {
        this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.starting"));
        BDevice[] devicesInNetwork = this.networkRef.getDevices();
        if (this.devicesToUpdate == null || this.devicesToUpdate.length == 0) {
            throw new Exception("No devices selected to be updated by primary address");
        }
        String updateDevicesCommLock = new String("UpdateDevicesJob" + this.getHandle());
        this.networkRef.lockSends(updateDevicesCommLock);
        this.networkRef.getNetworkDatabase().setActiveDiscovery((BJob)this);
        this.progressPerScan = 100.0 / (double)this.devicesToUpdate.length;
        for (int devNo = 0; devNo < this.devicesToUpdate.length && this.getJobState().equals((Object)BJobState.running); ++devNo) {
            this.networkRef.setSearchBaudRate(this.devicesToUpdate[devNo].getBaudRate());
            MBusTxTimings deviceTxTimings = this.devicesToUpdate[devNo].getTxTimingsReference();
            int devicesPrimaryAddress = this.devicesToUpdate[devNo].getPrimaryAddress();
            if (devicesPrimaryAddress < 0 || devicesPrimaryAddress > 250) {
                this.log().failed(MbusToolkit.lex.getText("BMbusUpdateDevicesJob.nonAllowedPrimaryAddress", new Object[]{String.valueOf(devicesPrimaryAddress), String.valueOf(0), String.valueOf(250)}));
                continue;
            }
            int count = 0;
            for (int netDevNo = 0; netDevNo < devicesInNetwork.length; ++netDevNo) {
                if (((BMbusDevice)devicesInNetwork[netDevNo]).getPrimaryAddress() != devicesPrimaryAddress) continue;
                ++count;
            }
            if (count > 1) {
                this.log().failed(MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.multiplePrimaryWarning", new Object[]{String.valueOf(devicesPrimaryAddress)}));
            }
            this.activeChildJob = new BMbusDeviceSearchJob(this.networkRef, new int[]{this.devicesToUpdate[devNo].getPrimaryAddress()}, this.log());
            ((BMbusDeviceSearchJob)this.activeChildJob).setOverrideTxTimings(deviceTxTimings);
            ((BMbusDeviceSearchJob)this.activeChildJob).overrideCommLock(updateDevicesCommLock);
            this.log().message(MbusToolkit.lex.getText("BMbusUpdateDevicesJob.runningUpdateOfDevice", new Object[]{this.devicesToUpdate[devNo].getDisplayName(null)}));
            this.activeChildJob.submit(cx);
            BJobState finalJobState = this.waitForFinalState((BJob)this.activeChildJob);
            while (finalJobState == BJobState.running) {
                finalJobState = this.waitForFinalState((BJob)this.activeChildJob);
            }
            switch (finalJobState.getOrdinal()) {
                case 4: {
                    this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.completed"));
                    break;
                }
                case 5: {
                    this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.failed"));
                    break;
                }
                case 3: {
                    this.log().message(MbusToolkit.getText("BMbusUpdateDevicesJob.cancelled"));
                }
            }
            this.baseProgress = this.progressPerScan * (double)(devNo + 1);
            this.progress((int)this.baseProgress);
        }
        this.networkRef.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
        this.networkRef.unlockSends(updateDevicesCommLock);
        this.currentScanBaudRate = null;
        this.networkRef = null;
        this.addressesToScan = null;
        this.currentScanBaudRate = null;
        this.activeChildJob = null;
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
    }
}

