/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.learn.BMbusDeviceEntry;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.HashSet;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMbusSecondarySearchJob
extends BSimpleJob {
    public static final Property networkOrd = BMbusSecondarySearchJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property optimisticScan = BMbusSecondarySearchJob.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BMbusSecondarySearchJob.class);
    protected BAbstractMbusNetwork network = null;
    protected BMbusNetworkDatabase networkManager = null;
    protected BMbusSecondaryAddressFilters filters = null;
    protected boolean cancelInProgress = true;
    protected JobLog log = null;
    protected MBusTxTimings overrideTxTimings = null;
    static final byte WILDCARD_ADDRESS_MARK = 15;
    protected HashSet<String> detectedDevices = new HashSet();
    protected Object commLock;

    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public void setNetworkOrd(BOrd v) {
        this.set(networkOrd, (BValue)v, null);
    }

    public boolean getOptimisticScan() {
        return this.getBoolean(optimisticScan);
    }

    public void setOptimisticScan(boolean v) {
        this.setBoolean(optimisticScan, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusSecondarySearchJob() {
    }

    public BMbusSecondarySearchJob(BAbstractMbusNetwork inputNetwork, BMbusSecondaryAddressFilters inputFilters, JobLog log) {
        if (inputFilters != null) {
            this.filters = inputFilters;
        }
        this.network = inputNetwork;
        this.networkManager = this.network.getNetworkDatabase();
        this.cancelInProgress = false;
        this.log = log;
    }

    protected String getCommLockPrefix() {
        return "secSearch";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        boolean independantJob;
        boolean bl = independantJob = this.commLock == null;
        if (this.networkManager != null) {
            if (independantJob) {
                this.commLock = this.getCommLockPrefix() + this.getHandle();
            }
            boolean filtersSetup = this.filters != null && (this.filters.getManufacturer().trim().length() != 0 || this.filters.getDeviceTypeId().getOrdinal() != new BMbusSecondaryAddressFilters().getDeviceTypeId().getOrdinal() || this.filters.getVersionNumber() != new BMbusSecondaryAddressFilters().getVersionNumber());
            try {
                this.doSecondarySearch(this.commLock, filtersSetup ? this.filters : null);
                if (independantJob) {
                    this.network.unlockSends(this.commLock);
                }
                this.network = null;
                this.networkManager = null;
                this.filters = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
            catch (Throwable t) {
                if (independantJob) {
                    this.network.unlockSends(this.commLock);
                }
                t.printStackTrace();
                this.network = null;
                this.networkManager = null;
                this.filters = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
            finally {
                if (independantJob) {
                    this.network.unlockSends(this.commLock);
                }
                this.network = null;
                this.networkManager = null;
                this.filters = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
        }
    }

    protected void doSecondarySearch(Object commlock, BMbusSecondaryAddressFilters inputFilters) {
        int i;
        this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.identSearchStarted"));
        MBusTxTimings searchTimings = new MBusTxTimings();
        if (this.overrideTxTimings != null) {
            searchTimings = this.overrideTxTimings;
        } else {
            searchTimings.intermessageDelay = 1000L;
            searchTimings.retryTransmission = 2;
            searchTimings.responseTimeout = BRelTime.makeSeconds((int)1);
            searchTimings.initalisationDelay = BRelTime.makeSeconds((int)2);
        }
        BMbusConfig txRxMbusConfig = new BMbusConfig();
        txRxMbusConfig.setInitialisationDelay(BRelTime.make((long)Math.max(searchTimings.initalisationDelay.getMillis(), 2000L)));
        txRxMbusConfig.setRetryCount(Math.max(searchTimings.retryTransmission, 2));
        txRxMbusConfig.setResponseTimeout(BRelTime.make((long)Math.max(searchTimings.responseTimeout.getMillis(), 2000L)));
        txRxMbusConfig.setInterMessageDelay(BRelTime.make((long)Math.max(300L, searchTimings.intermessageDelay)));
        int manufacturersCode = 0;
        int version = -1;
        int deviceId = -1;
        byte[] manuBytes = new byte[]{-1, -1};
        if (inputFilters != null) {
            String manufacturer = inputFilters.getManufacturer();
            if (manufacturer.length() == 3) {
                manufacturersCode = (manufacturer.charAt(0) - 64) * 32 * 32 + (manufacturer.charAt(1) - 64) * 32 + (manufacturer.charAt(2) - 64);
                manuBytes[0] = (byte)(manufacturersCode & 0xFF);
                manuBytes[1] = (byte)(manufacturersCode >> 8 & 0xFF);
            }
            deviceId = (byte)inputFilters.getDeviceTypeId().getOrdinal();
            if (inputFilters.getVersionNumber() != 0) {
                version = (byte)inputFilters.getVersionNumber();
            }
        }
        byte[] outputData = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        outputData[4] = manuBytes[0];
        outputData[5] = manuBytes[1];
        outputData[6] = version;
        outputData[7] = deviceId;
        long outputFilters = (manuBytes[0] & 0xFF) << 24 | (manuBytes[1] & 0xFF) << 16 | (version & 0xFF) << 8 | deviceId & 0xFF;
        outputFilters &= 0xFFFFFFFFL;
        MbusSndNkeMessage sendNkeMsg = new MbusSndNkeMessage(null, this.network, 255);
        sendNkeMsg.handleCorruptBuffers();
        sendNkeMsg.setResponseExpected(false);
        sendNkeMsg.setMessageBaudRate(this.network.getSearchBaudRate());
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.initNoReply"));
        }
        long minRxTxTimes = MBusTxTimings.calculateTxRxTime(sendNkeMsg, (BBaudRate)this.network.getSearchBaudRate());
        int reqSendNkes = Math.max(3, searchTimings.retryTransmission);
        this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.sendingSndNkes", new Object[]{String.valueOf(reqSendNkes)}));
        for (i = 0; i < reqSendNkes; ++i) {
            this.network.sendMBusSync(searchTimings, commlock, sendNkeMsg, minRxTxTimes);
        }
        this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.sentSndNkes", new Object[]{String.valueOf(reqSendNkes)}));
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.endInitNoReply"));
        }
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.initDelay"));
        }
        this.initialiseDelay(searchTimings.initalisationDelay.getSeconds());
        this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.initSecondsDelayDone", new Object[]{String.valueOf(searchTimings.initalisationDelay.getSeconds())}));
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.endInitDelay"));
        }
        this.network.setSearchFcBitState(true);
        if (!this.getOptimisticScan()) {
            this.logMessage(0, "Running slow & accurate scan");
        }
        this.progress(0);
        double progressPerSeg = 9.090909090909092;
        byte[] addressNibbles = new byte[8];
        for (i = 0; i < addressNibbles.length; ++i) {
            addressNibbles[i] = 15;
        }
        int nibblePos = 0;
        boolean runScan = true;
        while (runScan) {
            if (this.getCancelInProgress()) {
                return;
            }
            long addrLong = this.getBytesAsAddress(addressNibbles) | outputFilters;
            MbusResponseMessage rsp = null;
            if (addressNibbles[0] < 10) {
                int newProgress = (int)((double)addressNibbles[0] * progressPerSeg);
                if (this.getProgress() < newProgress) {
                    this.progress(newProgress);
                }
            }
            String scanAddress = Long.toHexString(addrLong).toUpperCase();
            while (scanAddress.length() < 16) {
                scanAddress = "0" + scanAddress;
            }
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.scanningWithSelector", new Object[]{scanAddress}));
            MbusSndUdMessage message = inputFilters == null ? new MbusSndUdMessage(this.getIntAsBytes((int)(addrLong >> 32))) : new MbusSndUdMessage(this.getLongAsBytes(addrLong));
            message.handleCorruptBuffers();
            message.setMessageBaudRate(this.network.getSearchBaudRate());
            long minRxTxTimes2 = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.network.getSearchBaudRate());
            rsp = (MbusResponseMessage)this.network.sendMBusSync(searchTimings, commlock, message, minRxTxTimes2 += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.network.getSearchBaudRate()));
            if (addressNibbles[0] < 10) {
                int newProgress = (int)(((double)addressNibbles[0] + 0.5) * progressPerSeg);
                if (this.getProgress() < newProgress) {
                    this.progress(newProgress);
                }
            }
            if (this.getCancelInProgress()) {
                return;
            }
            if (addressNibbles[0] == 15) {
                if (rsp != null) {
                    this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.possibleDevicesFound", new Object[]{String.valueOf((Object)this.network.getSearchBaudRate())}));
                    addressNibbles[0] = 0;
                    this.progress((int)progressPerSeg);
                    continue;
                }
                this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.noPossibleDevicesFound", new Object[]{String.valueOf((Object)this.network.getSearchBaudRate())}));
                this.progress(100);
                return;
            }
            if (rsp != null && rsp.getSuccessfulResponse()) {
                this.network.setSearchFcBitState(true);
                this.logMessage(0, MbusToolkit.getText("BMbusNetworkSecondarySearchJob.investigating"));
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Selector \"0x" + Long.toHexString(addrLong) + "\" accepted by 1 or more devices");
                }
                int numberOfValueTypes = 0;
                if (this.getOptimisticScan() || nibblePos == addressNibbles.length - 1) {
                    int n = numberOfValueTypes = rsp.getCollisionDetected() ? 0 : this.getAllTheData(commlock, txRxMbusConfig);
                }
                if (numberOfValueTypes > 0) {
                    if (MbusLogInputOutput.log.isTraceOn()) {
                        MbusLogInputOutput.log.trace("Device with selector \"0x" + Long.toHexString(addrLong) + "\" sucessfully learnt");
                    }
                    this.logMessage(3, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.deviceAcceptedSelector", new Object[]{Long.toHexString(addrLong).toUpperCase()}));
                    int n = nibblePos;
                    addressNibbles[n] = (byte)(addressNibbles[n] + 1);
                    if (addressNibbles[nibblePos] < 10) continue;
                    for (int i2 = nibblePos; i2 < addressNibbles.length; ++i2) {
                        addressNibbles[i2] = 15;
                    }
                    if (--nibblePos == -1) {
                        return;
                    }
                    int n2 = nibblePos;
                    addressNibbles[n2] = (byte)(addressNibbles[n2] + 1);
                    continue;
                }
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Multiple devices clash with selector \"0x" + Long.toHexString(addrLong) + "\"");
                }
                if (++nibblePos - 1 == addressNibbles.length - 1) {
                    if (MbusLogInputOutput.log.isLoggable(3)) {
                        MbusLogInputOutput.log.error("MBUS NOT FULLY ADDRESSABLE: Multiple devices clash with maximum selector (same id) \"0x" + Long.toHexString(addrLong) + "\"");
                    }
                    this.logMessage(4, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.unaddressableSelector", new Object[]{Long.toHexString(addrLong).toUpperCase()}));
                    for (int i3 = nibblePos - 1; i3 < addressNibbles.length; ++i3) {
                        addressNibbles[i3] = 15;
                    }
                    int n = nibblePos -= 2;
                    addressNibbles[n] = (byte)(addressNibbles[n] + 1);
                    continue;
                }
                addressNibbles[nibblePos] = 0;
                continue;
            }
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Device(s) with selector \"0x" + Long.toHexString(addrLong) + "\" did not reply");
            }
            int n = nibblePos;
            addressNibbles[n] = (byte)(addressNibbles[n] + 1);
            if (addressNibbles[nibblePos] < 10) continue;
            for (int i4 = nibblePos; i4 < addressNibbles.length; ++i4) {
                addressNibbles[i4] = 15;
            }
            if (--nibblePos == -1) {
                runScan = false;
                continue;
            }
            int n3 = nibblePos;
            addressNibbles[n3] = (byte)(addressNibbles[n3] + 1);
        }
        this.progress(99);
        BMbusDeviceData[] currentDevices = this.network.getNetworkDatabase().getDynamicDeviceData();
        for (int i5 = 0; i5 < currentDevices.length; ++i5) {
            BMbusDeviceData deviceInformation = currentDevices[i5];
            if (!deviceInformation.getJustDetected()) continue;
            BMbusDeviceEntry entry = new BMbusDeviceEntry();
            entry.setPrimaryAddress(deviceInformation.getPrimaryAddress());
            entry.setSecondaryAddress(deviceInformation.getSecondaryAddress());
            entry.setTxRxMbusConfig((BMbusConfig)deviceInformation.getTxRxMbusConfig().newCopy(true));
            entry.getTxRxMbusConfig().setOverrideNetwork(true);
            entry.setIdentNumber(deviceInformation.getIdentNumber());
            entry.setManufacturer(deviceInformation.getManufacturer());
            entry.setVersionNumber(deviceInformation.getVersionNumber());
            entry.setDeviceTypeId(deviceInformation.getDeviceTypeId());
            entry.setBaudRate(deviceInformation.getBaudRate());
            entry.setFcBitInUse(deviceInformation.getFcBitInUse());
            entry.setFcBitState(deviceInformation.getFcBitState());
            entry.setAddressMode(deviceInformation.getAddressMode());
            this.add(null, (BValue)entry);
        }
        this.progress(100);
        this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.secondarySearchFinished"));
    }

    protected int getAllTheData(Object commlock, BMbusConfig txRxMbusConfig) {
        MbusReceivedLongFrame longFrameMessage = null;
        MbusResponseMessage rsp = null;
        boolean fcBitState = true;
        MbusReqUd2Message message = new MbusReqUd2Message(253, this.network);
        message.handleCorruptBuffers();
        message.setMessageBaudRate(this.network.getSearchBaudRate());
        message.setFcBitState(fcBitState);
        int returnHold = 0;
        if (!this.getCancelInProgress()) {
            if (fcBitState) {
                this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.RecvdDataTypeFCBS"));
            } else {
                this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.RecvdDataTypeNoFCBS"));
            }
            long minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.network.getSearchBaudRate());
            rsp = (MbusResponseMessage)this.network.sendMBusSync(this.network.getTxTimingsReference(), commlock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.network.getSearchBaudRate()));
            if (rsp != null && rsp.getSuccessfulResponse() && rsp.getLength() > 10) {
                longFrameMessage = new MbusReceivedLongFrame(rsp, this.network, null, true, 0);
                this.networkManager.addDeviceData(this.detectedDevices, longFrameMessage, 0, this.network.getSearchBaudRate(), null, BMbusAddressing.secondary, txRxMbusConfig);
                ++returnHold;
            }
            fcBitState = !fcBitState;
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.searchCompleted"));
        }
        return returnHold;
    }

    public void success() {
        if (!this.cancelInProgress) {
            super.success();
        } else {
            this.setJobState(BJobState.canceled);
        }
    }

    public void doCancel(Context cx) {
        try {
            this.cancelInProgress = true;
            super.doCancel(cx);
        }
        catch (Exception e) {
            this.networkManager.setStatusMessage(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.Error Canceling"));
        }
    }

    public boolean getCancelInProgress() {
        return this.cancelInProgress;
    }

    public void initialiseDelay(int seconds) {
        long ticksAtDelayEnd = (long)(seconds * 1000) + Clock.ticks();
        try {
            long sleepTime = Math.min(ticksAtDelayEnd - Clock.ticks(), 1000L);
            while (sleepTime > 0L) {
                if (this.cancelInProgress) {
                    return;
                }
                Thread.sleep(sleepTime);
                sleepTime = Math.min(ticksAtDelayEnd - Clock.ticks(), 1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setOverrideTxTimings(MBusTxTimings newTimings) {
        this.overrideTxTimings = newTimings;
    }

    public void logMessage(int jLobItemId, String messageText) {
        this.log().add(new JobLogItem(jLobItemId, messageText));
        if (this.log != null) {
            String prefix = "--> ";
            this.log.add(new JobLogItem(jLobItemId, prefix + messageText));
        }
    }

    protected long getBytesAsAddress(byte[] identNibbles) {
        int address = identNibbles[0] << 28 | identNibbles[1] << 24 | identNibbles[2] << 20 | identNibbles[3] << 16 | identNibbles[4] << 12 | identNibbles[5] << 8 | identNibbles[6] << 4 | identNibbles[7];
        return (long)address << 32;
    }

    public byte[] getIntAsBytes(int noToConvert) {
        byte[] newBytes = new byte[]{(byte)((noToConvert & 0xFF000000) >> 24 & 0xFF), (byte)((noToConvert & 0xFF0000) >> 16 & 0xFF), (byte)((noToConvert & 0xFF00) >> 8 & 0xFF), (byte)(noToConvert & 0xFF)};
        return newBytes;
    }

    public byte[] getLongAsBytes(long longToConvert) {
        byte[] newBytes = new byte[]{(byte)((longToConvert & 0xFF00000000000000L) >> 56 & 0xFFL), (byte)((longToConvert & 0xFF000000000000L) >> 48 & 0xFFL), (byte)((longToConvert & 0xFF0000000000L) >> 40 & 0xFFL), (byte)((longToConvert & 0xFF00000000L) >> 32 & 0xFFL), (byte)((longToConvert & 0xFFFFFFFFFF000000L) >> 24 & 0xFFL), (byte)((longToConvert & 0xFF0000L) >> 16 & 0xFFL), (byte)((longToConvert & 0xFF00L) >> 8 & 0xFFL), (byte)(longToConvert & 0xFFL)};
        return newBytes;
    }

    public HashSet<String> getDetectedDevicesHandleOrds() {
        HashSet<String> result = this.detectedDevices;
        this.detectedDevices = null;
        return result;
    }

    public void overrideCommLock(Object newCommLock) {
        this.commLock = newCommLock;
    }
}

