/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BSecondaryDiscoverOptions;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.jobs.BMbusSecondarySearchJob;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.HashSet;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMbusSecondaryDeviceSearchJob
extends BSimpleJob {
    public static final Property discoveryOptions = BMbusSecondaryDeviceSearchJob.newProperty((int)0, (BValue)new BSecondaryDiscoverOptions(), null);
    public static final Action handleNewPrimaryAdddressFound = BMbusSecondaryDeviceSearchJob.newAction((int)0, (BValue)BInteger.make((int)-1), null);
    public static final Type TYPE = Sys.loadType(BMbusSecondaryDeviceSearchJob.class);
    private BBaudRate currentScanBaudRate = null;
    private Object addressesToScanLock = new Object();
    private Array<BInteger> addressesToScan = new Array(BInteger.class);
    private BSimpleJob activeChildJob = null;
    private BAbstractMbusNetwork networkRef;
    private double baseProgress = 0.0;
    private double progressPerScan = 100.0;

    public BSecondaryDiscoverOptions getDiscoveryOptions() {
        return (BSecondaryDiscoverOptions)this.get(discoveryOptions);
    }

    public void setDiscoveryOptions(BSecondaryDiscoverOptions v) {
        this.set(discoveryOptions, (BValue)v, null);
    }

    public void handleNewPrimaryAdddressFound(BInteger addressFound) {
        this.invoke(handleNewPrimaryAdddressFound, (BValue)addressFound, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusSecondaryDeviceSearchJob() {
    }

    public BMbusSecondaryDeviceSearchJob(BAbstractMbusNetwork networkRef) {
        this.networkRef = networkRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleNewPrimaryAdddressFound(BInteger addr) {
        if (addr.getInt() < 0 || addr.getInt() > 250) {
            return;
        }
        Object object = this.addressesToScanLock;
        synchronized (object) {
            this.addressesToScan.remove((Object)addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        String secondaryDiscoverCommLock = new String("SecondaryDeviceSearch" + this.getHandle());
        try {
            this.doCommsLockedRun(cx, secondaryDiscoverCommLock);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.networkRef.unlockSends(secondaryDiscoverCommLock);
            this.networkRef = null;
            this.activeChildJob = null;
            if (e instanceof JobCancelException) {
                throw (JobCancelException)e;
            }
        }
        finally {
            this.networkRef.unlockSends(secondaryDiscoverCommLock);
            this.networkRef = null;
            this.activeChildJob = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doCommsLockedRun(Context cx, Object commLock) throws Exception {
        this.log().message(MbusToolkit.getText("MbusNetworkDeviceSearch.startingScan"));
        Object[] baudRatesToScan = this.getDiscoveryOptions().getBaudRates().getChildren(BBaudRate.class);
        this.networkRef.getNetworkDatabase().clearJustDetected();
        this.networkRef.getNetworkDatabase().setActiveDiscovery((BJob)this);
        if (baudRatesToScan.length == 0) {
            if (!(this.networkRef instanceof BMbusTcpIpNetwork)) {
                this.log().message(MbusToolkit.getText("MbusNetworkDeviceSearch.noBaudRatesSpecified"));
                throw new Exception("Baud rates must be set");
            }
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.tcpipConverterSlowBaudSet", new Object[]{BMbusBaudRate.baud300.getTypeDisplayName(null)}));
            baudRatesToScan = new BBaudRate[]{BMbusBaudRate.baud300};
        } else {
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.baudRatesToScan", new Object[]{String.valueOf(baudRatesToScan.length)}));
            for (int i = 0; i < baudRatesToScan.length; ++i) {
                this.log().message("-> " + ((BBaudRate)baudRatesToScan[i]).getDisplayTag(cx));
            }
        }
        this.networkRef.lockSends(commLock);
        HashSet<String> databaseEntries = new HashSet<String>();
        this.progressPerScan = 100.0 / (double)baudRatesToScan.length;
        for (int brIdx = 0; brIdx < baudRatesToScan.length && this.getJobState().equals((Object)BJobState.running); ++brIdx) {
            this.currentScanBaudRate = (BBaudRate)baudRatesToScan[brIdx];
            this.activeChildJob = this.getDiscoveryOptions().getIdentScanOnly() ? new BMbusSecondarySearchJob(this.networkRef, null, this.log()) : new BMbusSecondarySearchJob(this.networkRef, this.getDiscoveryOptions().getFilters(), this.log());
            ((BMbusSecondarySearchJob)this.activeChildJob).setOverrideTxTimings(this.getDiscoveryOptions().getTxRxProfile().getMBusTxTimings());
            ((BMbusSecondarySearchJob)this.activeChildJob).overrideCommLock(commLock);
            if (this.currentScanBaudRate instanceof BMbusBaudRate) {
                this.networkRef.setSearchBaudRate((BMbusBaudRate)this.currentScanBaudRate);
            }
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.startingBaudRateScan", new Object[]{this.currentScanBaudRate}));
            this.activeChildJob.submit(cx);
            BJobState finalJobState = this.waitForFinalState((BJob)this.activeChildJob);
            while (finalJobState == BJobState.running) {
                finalJobState = this.waitForFinalState((BJob)this.activeChildJob);
            }
            switch (finalJobState.getOrdinal()) {
                case 4: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.completedScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
                case 5: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.failedScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
                case 3: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.cancelledScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
            }
            this.baseProgress = 100.0 / (double)baudRatesToScan.length * (double)(brIdx + 1);
            this.progress((int)this.baseProgress);
            databaseEntries.addAll(((BMbusSecondarySearchJob)this.activeChildJob).getDetectedDevicesHandleOrds());
        }
        this.networkRef.getNetworkDatabase().clearJustDetected();
        Object[] dbHandleOrds = databaseEntries.toArray();
        for (int i = 0; i < dbHandleOrds.length; ++i) {
            ((BMbusDeviceData)BOrd.make((String)((String)dbHandleOrds[i])).get((BObject)this)).setJustDetected(true);
        }
        this.networkRef.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
        this.currentScanBaudRate = null;
        this.addressesToScan = null;
        this.currentScanBaudRate = null;
        this.activeChildJob = null;
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
    }

    public BJobState waitForFinalState(BJob jobToMonitor) {
        switch (jobToMonitor.getJobState().getOrdinal()) {
            case 3: {
                return BJobState.canceled;
            }
            case 4: {
                return BJobState.success;
            }
            case 5: {
                return BJobState.failed;
            }
            case 0: {
                return BJobState.unknown;
            }
        }
        jobMonitor jobMon = new jobMonitor(jobToMonitor, (BJob)this);
        jobMon.subscribe((BComponent)jobToMonitor);
        jobMon.waitForFinalState();
        jobMon.unsubscribe((BComponent)jobToMonitor);
        return jobToMonitor.getJobState();
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
        if (this.activeChildJob != null) {
            this.activeChildJob.doCancel(cx);
        }
        super.doCancel(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getAddressesToScan() {
        int[] result;
        if (this.addressesToScan == null) {
            return new int[0];
        }
        Object object = this.addressesToScanLock;
        synchronized (object) {
            result = new int[this.addressesToScan.size()];
            Object[] internalArrayRef = this.addressesToScan.array();
            for (int i = 0; i < this.addressesToScan.size(); ++i) {
                result[i] = ((BInteger)internalArrayRef[i]).getInt();
            }
        }
        return result;
    }

    protected class jobMonitor
    extends Subscriber {
        Object threadLock = new Object();
        BJob jobToMonitor;
        BJob blockedJob;

        public jobMonitor(BJob jobToMonitor, BJob blockedJob) {
            this.jobToMonitor = jobToMonitor;
            this.blockedJob = blockedJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(BComponentEvent event) {
            if (event.getSlotName().equals(BJob.jobState.getName())) {
                Object object = this.threadLock;
                synchronized (object) {
                    this.threadLock.notifyAll();
                }
            } else if (event.getSlotName().equals(BJob.progress.getName())) {
                int progress = (int)(BMbusSecondaryDeviceSearchJob.this.baseProgress + BMbusSecondaryDeviceSearchJob.this.progressPerScan / 100.0 * ((BInteger)event.getValue()).getDouble());
                if (((BInteger)event.getValue()).getDouble() > 100.0) {
                    progress = (int)(BMbusSecondaryDeviceSearchJob.this.baseProgress + 100.0 / BMbusSecondaryDeviceSearchJob.this.progressPerScan);
                }
                this.blockedJob.progress(progress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForFinalState() {
            Object object = this.threadLock;
            synchronized (object) {
                while (this.jobToMonitor.getJobState() == BJobState.running) {
                    try {
                        this.threadLock.wait(10000L);
                        this.blockedJob.heartbeat();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

