/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.actionArgSets.BLivePointSearchDiscoverOptions;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusDecodeVariableFrame;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMbusLivePointSearchDiscoveryJob
extends BSimpleJob {
    public static final Property discoveryOptions = BMbusLivePointSearchDiscoveryJob.newProperty((int)0, (BValue)new BLivePointSearchDiscoverOptions(), null);
    public static final Type TYPE = Sys.loadType(BMbusLivePointSearchDiscoveryJob.class);
    protected BMbusDevice deviceRef;
    protected BAbstractMbusNetwork networkRef;
    protected double baseProgress = 0.0;
    protected double progressPerScan = 100.0;

    public BLivePointSearchDiscoverOptions getDiscoveryOptions() {
        return (BLivePointSearchDiscoverOptions)this.get(discoveryOptions);
    }

    public void setDiscoveryOptions(BLivePointSearchDiscoverOptions v) {
        this.set(discoveryOptions, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusLivePointSearchDiscoveryJob() {
    }

    public BMbusLivePointSearchDiscoveryJob(BMbusDevice deviceRef) {
        this.deviceRef = deviceRef;
        this.networkRef = deviceRef.getMbusNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        String commLock = new String("LivePointSearch" + this.getHandle());
        try {
            this.doCommsLockedRun(cx, commLock);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.networkRef.unlockSends(commLock);
            this.networkRef = null;
            this.deviceRef = null;
            if (e instanceof JobCancelException) {
                throw (JobCancelException)e;
            }
        }
        finally {
            this.networkRef.unlockSends(commLock);
            this.networkRef = null;
            this.deviceRef = null;
        }
    }

    public void doCommsLockedRun(Context cx, Object commLock) throws Exception {
        this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.startingScan"));
        this.networkRef.getNetworkDatabase().setActiveDiscovery((BJob)this);
        this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.awaitingComms"));
        MBusTxTimings txTimings = this.deviceRef.getTxTimingsReference();
        this.heartbeat();
        BMbusNetworkDatabase networkManager = this.networkRef.getNetworkDatabase();
        this.networkRef.lockSends(commLock);
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
        this.heartbeat();
        this.progress(1);
        if (this.deviceRef.getResetRequired()) {
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.resettingAndInitStart"));
            this.deviceRef.doSendNkeAndInitDelay(txTimings, commLock);
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.resettingAndInitEnd"));
        }
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
        this.progress(3);
        if (this.deviceRef.getAddressMode() != BMbusAddressing.primary) {
            MbusResponseMessage rsp;
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.selectingSecondaryAddress"));
            MbusSndUdMessage message2 = new MbusSndUdMessage(this.deviceRef, this.networkRef);
            message2.setMessageBaudRate(this.deviceRef.getBaudRate());
            long minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.deviceRef.getBaudRate());
            minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.deviceRef.getBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Sending secondary address selector");
            }
            if ((rsp = (MbusResponseMessage)this.networkRef.sendMBusSync(txTimings, commLock, message2, minRxTxTimes)) == null || rsp != null && !rsp.getSuccessfulResponse() || rsp != null && rsp.getCollisionDetected()) {
                if (MbusLogInputOutput.log.isLoggable(2) && this.deviceRef.isMounted()) {
                    if (rsp != null && rsp.getCollisionDetected()) {
                        MbusLogInputOutput.log.warning(this.deviceRef.getDisplayName(null) + " Failed to select secondary addressing - collision detected - try extended secondary addressing");
                    } else {
                        MbusLogInputOutput.log.warning(this.deviceRef.getDisplayName(null) + " Failed to select secondary addressing after reset - the device may require a longer reset time");
                    }
                }
                if (rsp != null && rsp.getCollisionDetected()) {
                    this.log().message(MbusToolkit.getText("BMbusGeneral.busSelectionFailure"));
                } else {
                    this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.failedSecondaryAddressSelection"));
                }
                throw new Exception(MbusToolkit.getText("MbusNetworkPointSearch.failedSecondaryAddressSelection"));
            }
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.selectedSecondaryAddress"));
            this.networkRef.setSearchFcBitState(true);
        }
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
        this.progress(5);
        MbusReqUd2Message message = null;
        MbusResponseMessage rsp = null;
        int totalFramesToReadTo = this.getDiscoveryOptions().getMaxSequentialReads();
        this.log().message(MbusToolkit.lex.getText("MbusNetworkPointSearch.scanningUpToResp", new Object[]{String.valueOf(totalFramesToReadTo)}));
        double scanPercentage = 95.0;
        double percentagePerFrameRead = 95.0 / (double)totalFramesToReadTo;
        long minRxTxTimes = -1L;
        MbusDecodeVariableFrame.DecoderOverrides decoderOverrides = new MbusDecodeVariableFrame.DecoderOverrides();
        block4: for (int i = 0; i < totalFramesToReadTo; ++i) {
            message = new MbusReqUd2Message(this.deviceRef, this.networkRef);
            if (minRxTxTimes == -1L) {
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.deviceRef.getBaudRate());
                minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.deviceRef.getBaudRate());
            }
            if (this.getJobState().equals((Object)BJobState.canceling)) {
                throw new JobCancelException();
            }
            rsp = (MbusResponseMessage)this.networkRef.sendMBusSync(this.deviceRef.getTxTimingsReference(), commLock, message, minRxTxTimes);
            if (this.getJobState().equals((Object)BJobState.canceling)) {
                throw new JobCancelException();
            }
            if (rsp == null || !rsp.getSuccessfulResponse() || rsp.getLength() <= 10) continue;
            decoderOverrides.recordNumber = i + 1;
            MbusReceivedLongFrame longFrameMessage = new MbusReceivedLongFrame(rsp, this.networkRef, this.deviceRef, false, 0, decoderOverrides);
            switch (longFrameMessage.getCIField()) {
                case 118: {
                    break;
                }
                case 114: {
                    break;
                }
                default: {
                    this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.endOfVDS"));
                    i = totalFramesToReadTo;
                    continue block4;
                }
            }
            this.log().message(MbusToolkit.lex.getText("MbusNetworkPointSearch.processingResponse", new Object[]{String.valueOf(i + 1)}));
            this.progress((int)((double)(i + 1) * percentagePerFrameRead + 5.0));
            boolean moreDataExpected = longFrameMessage.getFurtherDataIndicated();
            int recordsAdded = networkManager.addDeviceData(null, longFrameMessage, 0, this.deviceRef.getBaudRate(), this.deviceRef, this.deviceRef.getAddressMode(), this.deviceRef.getMbusConfig());
            if (recordsAdded > 0) {
                this.log().message(MbusToolkit.lex.getText("MbusNetworkPointSearch.addedNewPointDefs", new Object[]{String.valueOf(recordsAdded)}));
            }
            if (moreDataExpected) continue;
            this.log().message(MbusToolkit.getText("MbusNetworkPointSearch.noMoreDataToBeRead"));
            break;
        }
        this.progress(100);
        this.networkRef.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
    }

    public BJobState waitForFinalState(BJob jobToMonitor) {
        switch (jobToMonitor.getJobState().getOrdinal()) {
            case 3: {
                return BJobState.canceled;
            }
            case 4: {
                return BJobState.success;
            }
            case 5: {
                return BJobState.failed;
            }
            case 0: {
                return BJobState.unknown;
            }
        }
        jobMonitor jobMon = new jobMonitor(jobToMonitor, (BJob)this);
        jobMon.subscribe((BComponent)jobToMonitor);
        jobMon.waitForFinalState();
        jobMon.unsubscribe((BComponent)jobToMonitor);
        return jobToMonitor.getJobState();
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    protected class jobMonitor
    extends Subscriber {
        Object threadLock = new Object();
        BJob jobToMonitor;
        BJob blockedJob;

        public jobMonitor(BJob jobToMonitor, BJob blockedJob) {
            this.jobToMonitor = jobToMonitor;
            this.blockedJob = blockedJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(BComponentEvent event) {
            if (event.getSlotName().equals(BJob.jobState.getName())) {
                Object object = this.threadLock;
                synchronized (object) {
                    this.threadLock.notifyAll();
                }
            } else if (event.getSlotName().equals(BJob.progress.getName())) {
                int progress = (int)(BMbusLivePointSearchDiscoveryJob.this.baseProgress + BMbusLivePointSearchDiscoveryJob.this.progressPerScan / 100.0 * ((BInteger)event.getValue()).getDouble());
                if (((BInteger)event.getValue()).getDouble() > 100.0) {
                    progress = (int)(BMbusLivePointSearchDiscoveryJob.this.baseProgress + 100.0 / BMbusLivePointSearchDiscoveryJob.this.progressPerScan);
                }
                this.blockedJob.progress(progress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForFinalState() {
            Object object = this.threadLock;
            synchronized (object) {
                while (this.jobToMonitor.getJobState() == BJobState.running) {
                    try {
                        this.threadLock.wait(10000L);
                        this.blockedJob.heartbeat();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

