/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.db;

import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BMbusDeviceData
extends BComponent {
    public static final Property modelName = BMbusDeviceData.newProperty((int)0, (String)"", null);
    public static final Property primaryAddress = BMbusDeviceData.newProperty((int)0, (int)0, null);
    public static final Property secondaryAddress = BMbusDeviceData.newProperty((int)1, (String)"", null);
    public static final Property addressMode = BMbusDeviceData.newProperty((int)0, (BValue)BMbusAddressing.primary, null);
    public static final Property identNumber = BMbusDeviceData.newProperty((int)1, (String)"", null);
    public static final Property manufacturer = BMbusDeviceData.newProperty((int)1, (String)"", null);
    public static final Property versionNumber = BMbusDeviceData.newProperty((int)1, (int)0, null);
    public static final Property deviceTypeId = BMbusDeviceData.newProperty((int)1, (BValue)BMbusDeviceTypeId.other, null);
    public static final Property baudRate = BMbusDeviceData.newProperty((int)1, (BValue)BMbusBaudRate.baud300, null);
    public static final Property pointData = BMbusDeviceData.newProperty((int)0, (BValue)new BMbusPointData(), null);
    public static final Property pointDataInvalid = BMbusDeviceData.newProperty((int)4, (boolean)false, null);
    public static final Property fcBitState = BMbusDeviceData.newProperty((int)4, (boolean)false, null);
    public static final Property fcBitInUse = BMbusDeviceData.newProperty((int)0, (boolean)false, null);
    public static final Property justDetected = BMbusDeviceData.newProperty((int)0, (boolean)false, null);
    public static final Property txRxMbusConfig = BMbusDeviceData.newProperty((int)0, (BValue)new BMbusConfig(), null);
    public static final Type TYPE = Sys.loadType(BMbusDeviceData.class);

    public String getModelName() {
        return this.getString(modelName);
    }

    public void setModelName(String v) {
        this.setString(modelName, v, null);
    }

    public int getPrimaryAddress() {
        return this.getInt(primaryAddress);
    }

    public void setPrimaryAddress(int v) {
        this.setInt(primaryAddress, v, null);
    }

    public String getSecondaryAddress() {
        return this.getString(secondaryAddress);
    }

    public void setSecondaryAddress(String v) {
        this.setString(secondaryAddress, v, null);
    }

    public BMbusAddressing getAddressMode() {
        return (BMbusAddressing)this.get(addressMode);
    }

    public void setAddressMode(BMbusAddressing v) {
        this.set(addressMode, (BValue)v, null);
    }

    public String getIdentNumber() {
        return this.getString(identNumber);
    }

    public void setIdentNumber(String v) {
        this.setString(identNumber, v, null);
    }

    public String getManufacturer() {
        return this.getString(manufacturer);
    }

    public void setManufacturer(String v) {
        this.setString(manufacturer, v, null);
    }

    public int getVersionNumber() {
        return this.getInt(versionNumber);
    }

    public void setVersionNumber(int v) {
        this.setInt(versionNumber, v, null);
    }

    public BMbusDeviceTypeId getDeviceTypeId() {
        return (BMbusDeviceTypeId)this.get(deviceTypeId);
    }

    public void setDeviceTypeId(BMbusDeviceTypeId v) {
        this.set(deviceTypeId, (BValue)v, null);
    }

    public BMbusBaudRate getBaudRate() {
        return (BMbusBaudRate)this.get(baudRate);
    }

    public void setBaudRate(BMbusBaudRate v) {
        this.set(baudRate, (BValue)v, null);
    }

    public BMbusPointData getPointData() {
        return (BMbusPointData)this.get(pointData);
    }

    public void setPointData(BMbusPointData v) {
        this.set(pointData, (BValue)v, null);
    }

    public boolean getPointDataInvalid() {
        return this.getBoolean(pointDataInvalid);
    }

    public void setPointDataInvalid(boolean v) {
        this.setBoolean(pointDataInvalid, v, null);
    }

    public boolean getFcBitState() {
        return this.getBoolean(fcBitState);
    }

    public void setFcBitState(boolean v) {
        this.setBoolean(fcBitState, v, null);
    }

    public boolean getFcBitInUse() {
        return this.getBoolean(fcBitInUse);
    }

    public void setFcBitInUse(boolean v) {
        this.setBoolean(fcBitInUse, v, null);
    }

    public boolean getJustDetected() {
        return this.getBoolean(justDetected);
    }

    public void setJustDetected(boolean v) {
        this.setBoolean(justDetected, v, null);
    }

    public BMbusConfig getTxRxMbusConfig() {
        return (BMbusConfig)this.get(txRxMbusConfig);
    }

    public void setTxRxMbusConfig(BMbusConfig v) {
        this.set(txRxMbusConfig, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMbusDeviceData() {
    }

    public BMbusDeviceData(int inputPrimaryAddress, String inputSecondaryAddress, String inputIdentNumber, String inputManufacturer, int inputVersionNumber, BMbusDeviceTypeId inputDeviceTypeId, BMbusBaudRate inputBaudRate, BMbusPointData[] inputPointData, boolean inputFcBitState, boolean inputFcBitInUse, BMbusAddressing inputAddressMode) {
        this.setPrimaryAddress(inputPrimaryAddress);
        this.setSecondaryAddress(inputSecondaryAddress);
        this.setIdentNumber(inputIdentNumber);
        this.setManufacturer(inputManufacturer);
        this.setVersionNumber(inputVersionNumber);
        this.setDeviceTypeId(inputDeviceTypeId);
        this.setBaudRate(inputBaudRate);
        this.setFcBitState(inputFcBitState);
        this.setFcBitInUse(inputFcBitInUse);
        this.setAddressMode(inputAddressMode);
        for (int i = 0; i < inputPointData.length; ++i) {
            String inputDescriptionHold = inputPointData[i].getDescription();
            BMbusOrthogonalDescription inputOrthoDescriptionHold = inputPointData[i].getOrthogonalDescription();
            BMbusFunction inputFunction = inputPointData[i].getFunction();
            BMbusUnit inputUnitHold = inputPointData[i].getUnit();
            int inputRecordNumberHold = inputPointData[i].getRecordNumber();
            int inputExponent = inputPointData[i].getExponent();
            int inputCycleNumberHold = inputPointData[i].getCycleNumber();
            int inputStorageNumberHold = inputPointData[i].getStorageNumber();
            int inputMessageSlotNumber = inputPointData[i].getMessageSlotNumber();
            int inputReadoutModeNumber = inputPointData[i].getDeviceMode();
            BMbusPointData[] currentPointData = this.getDynamicPointData();
            boolean match = false;
            for (int j = 0; j < currentPointData.length; ++j) {
                if (!currentPointData[j].getUnit().equals((Object)inputUnitHold) || !currentPointData[j].getDescription().equals(inputDescriptionHold) || !currentPointData[j].getOrthogonalDescription().equals((Object)inputOrthoDescriptionHold) || !currentPointData[j].getFunction().equals((Object)inputFunction) || currentPointData[j].getStorageNumber() != inputStorageNumberHold || currentPointData[j].getCycleNumber() != inputCycleNumberHold || currentPointData[j].getDeviceMode() != inputReadoutModeNumber || currentPointData[j].getRecordNumber() != inputRecordNumberHold) continue;
                match = true;
                break;
            }
            if (!match) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("BMbusDeviceData: adding in " + inputDescriptionHold + ", unit= " + (Object)((Object)inputUnitHold) + ", ortho= " + (Object)((Object)inputOrthoDescriptionHold) + ", function= " + (Object)((Object)inputFunction) + ", exponent= " + inputExponent + ", store= " + inputStorageNumberHold + ", rec= " + inputRecordNumberHold + ", cycle= " + inputCycleNumberHold + ", slot= " + inputMessageSlotNumber + ", mode= " + inputReadoutModeNumber);
                }
                this.add(pointData.getName() + "?", (BValue)inputPointData[i], 1);
                continue;
            }
            if (!MbusToolkit.isTraceOn()) continue;
            MbusToolkit.trace("BMbusDeviceData: Duplicate records, Units = " + (Object)((Object)inputUnitHold) + " ; Desc = " + inputDescriptionHold);
        }
    }

    public BMbusPointData[] getDynamicPointData() {
        Property[] props = this.getDynamicPropertiesArray();
        Array a = new Array(BMbusPointData.class);
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getType().equals(BMbusPointData.TYPE)) continue;
            a.add((Object)((BMbusPointData)this.get(props[i])));
        }
        return (BMbusPointData[])a.trim();
    }
}

