/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.serial.SerialComm;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusCommTransmitter;
import com.tridium.mbus.comm.MbusCommUtil;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

public final class MbusSerialComm
extends SerialComm
implements IMbusComm {
    private BAbstractMbusNetwork mbusNetwork = null;
    private long lastSentMessageTicks = 0L;
    private long lastRecvTicks = 0L;

    public MbusSerialComm(BAbstractMbusNetwork network, MbusCommReceiver commReceiver, MbusCommTransmitter commTransmitter) {
        super((BSerialNetwork)network, (CommReceiver)commReceiver, (CommTransmitter)commTransmitter);
        this.mbusNetwork = network;
    }

    public Message transmit(Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        return MbusCommUtil.transmit((Comm)this, msg, responseTimeout, retryCount);
    }

    public void receive(ReceivedMessage msg) {
        this.setReceivedMessageTicks(Clock.ticks());
        this.lastRecvTicks = Clock.ticks();
        super.receive(msg);
    }

    public BAbstractMbusNetwork getCommsNetwork() {
        return this.mbusNetwork;
    }

    @Override
    public void messageSent() {
        this.lastSentMessageTicks = Clock.ticks();
    }

    @Override
    public void performNetworkInterMessageDelay() {
        MbusCommUtil.performNetworkInterMessageDelay((Comm)this);
    }

    @Override
    public Message processNetworkTransmit(Message msg, BRelTime responseTimeout) throws BasicException {
        return this.processTransmit(msg, responseTimeout);
    }

    @Override
    public long getLastMessageTicks() {
        return Math.max(this.lastRecvTicks, this.lastSentMessageTicks);
    }
}

