/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.device;

import com.tridium.lonworks.datatypes.BAppDownloadParameter;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.datatypes.BMatchParameter;
import com.tridium.lonworks.netmgmt.BLonCommissionJob;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonReplaceJob;
import com.tridium.lonworks.netmgmt.BLonServicePinJob;
import com.tridium.lonworks.ui.BCommReplDialog;
import com.tridium.lonworks.ui.ServicePinMonitor;
import com.tridium.lonworks.ui.device.BAppDownLoadPane;
import com.tridium.lonworks.ui.device.BLonDeviceManager;
import com.tridium.lonworks.ui.tool.BLonXmlOptions;
import com.tridium.lonworks.util.DeviceDef;
import com.tridium.lonworks.util.LonStringUtil;
import com.tridium.lonworks.util.NxeUtil;
import com.tridium.lonworks.util.XLonUtil;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.ui.BOptionDialog;
import java.util.ArrayList;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.view.BWbComponentView;

public class LonDeviceController
extends DeviceController {
    public final MgrController.MgrCommand lonDiscover;
    public final MgrController.MgrCommand commission;
    public final MgrController.MgrCommand replace;
    public final MgrController.MgrCommand quikLearn;
    public final MgrController.MgrCommand appDownLoad;
    public final MgrController.MgrCommand clearTable;
    public final UseNetAddressToggle useNetAddrToggle;
    public final UseDbAddressToggle useDbAddrToggle;
    BLonXmlOptions opts = BLonXmlOptions.make();

    LonDeviceController(BLonDeviceManager manager) {
        super((BDeviceManager)manager);
        this.commission = new Commission((BWidget)manager);
        this.replace = new Replace((BWidget)manager);
        this.quikLearn = new QuikLearn((BWidget)manager);
        this.appDownLoad = new AppDownLoad((BWidget)manager);
        this.useNetAddrToggle = new UseNetAddressToggle((BWidget)manager);
        this.useDbAddrToggle = new UseDbAddressToggle((BWidget)manager);
        this.clearTable = new ClearTable((BWidget)manager);
        this.lonDiscover = new LonDiscover((BWidget)manager);
        this.lonDiscover.setFlags(7);
        this.commission.setFlags(7);
        this.replace.setFlags(7);
        this.quikLearn.setFlags(7);
        this.appDownLoad.setFlags(7);
        this.useNetAddrToggle.setFlags(1);
        this.useDbAddrToggle.setFlags(1);
        this.clearTable.setFlags(16);
        this.setUseNetAddress(manager.isUseNetAddress());
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants, this.newCommand, this.edit, this.learnMode, this.lonDiscover, this.cancel, this.add, this.match, this.quickMatch, this.quickAdd, this.templateMode, this.commission, this.replace, this.quikLearn, this.appDownLoad, this.useNetAddrToggle, this.useDbAddrToggle, this.clearTable};
    }

    public void updateCommands() {
        super.updateCommands();
        BLonDevice[] devs = this.getSelectedDevices();
        boolean sels = devs.length > 0;
        boolean local = false;
        boolean disable = !this.netmgmt().getEnabled() || !this.getNetwork().getEnabled();
        boolean enableDwnLd = true;
        if (sels) {
            BProgramId pid = devs[0].getDeviceData().getProgramId();
            for (int i = 0; i < devs.length; ++i) {
                BLonDevice dev = devs[i];
                BDeviceData dd = dev.getDeviceData();
                BStatus status = dev.getStatus();
                if (status.isDown()) {
                    enableDwnLd = false;
                }
                if (status.isFault() || status.isDisabled()) {
                    enableDwnLd = false;
                    disable = true;
                }
                if (dd.getNeuronId().isZero() || dev.isLocal() || dd.getHosted() || i > 0 && !pid.getMfgId().equals((Object)dd.getProgramId().getMfgId())) {
                    enableDwnLd = false;
                }
                if (!dev.isLocal()) continue;
                local = true;
            }
        }
        this.appDownLoad.setEnabled(!disable && sels && enableDwnLd);
        this.commission.setEnabled(!disable && sels);
        this.replace.setEnabled(!disable && sels && !local);
        this.quikLearn.setEnabled(!disable && !local);
        this.lonDiscover.setEnabled(this.getNetwork().getEnabled());
    }

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] cmds = new MgrController.IMgrCommand[]{this.newFolder, this.newCommand, this.edit, this.learnMode, this.lonDiscover, this.cancel, this.add, this.match};
        MgrController.IMgrCommand[] cmds2 = new MgrController.IMgrCommand[]{this.commission, this.replace, this.quikLearn, this.appDownLoad};
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.makeActionPane(cmds));
        pane.setCenter((BWidget)new BBorderPane(this.makeActionPane(cmds2)));
        return pane;
    }

    public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
        if (command == this.match) {
            return new MgrController.IMgrCommand[]{this.useNetAddrToggle, this.useDbAddrToggle};
        }
        return null;
    }

    public CommandArtifact doMatch(final Object discovery, final BComponent database, Context cx) throws Exception {
        MgrEdit edit = new MgrEdit(this.getManager(), this.match.getLabel()){

            public CommandArtifact commit() throws Exception {
                return LonDeviceController.this.doMatchCommit(discovery, database, this);
            }
        };
        MgrEditRow row = edit.addRow(database);
        this.getManager().getLearn().toRow(discovery, row);
        return edit.invoke(cx);
    }

    private CommandArtifact doMatchCommit(Object discovery, BComponent database, MgrEdit edit) throws Exception {
        BLonDeviceManager mgr = (BLonDeviceManager)this.getManager();
        MgrEditRow row = edit.getRows()[0];
        BLonDevice dbDev = (BLonDevice)database;
        int subnet = ((BInteger)row.getCell(mgr.colSubnet)).getInt();
        int node = ((BInteger)row.getCell(mgr.colNode)).getInt();
        BProgramId pid = (BProgramId)row.getCell(mgr.colProgramId);
        boolean auth = ((BDeviceEntry)discovery).getAuthenticate();
        BDeviceEntry editEntry = new BDeviceEntry(row.getName(), (BLonNodeState)row.getCell(mgr.colState), subnet, node, (BNeuronId)row.getCell(mgr.colNeuronId), pid, ((BInteger)row.getCell(mgr.colChannelId)).getInt(), auth, ((BInteger)row.getCell(mgr.colWorkDomain)).getInt());
        BSubnetNode devAdr = dbDev.getDeviceData().getSubnetNodeId();
        BMatchParameter param = new BMatchParameter(devAdr, editEntry);
        if (!this.netmgmt().match(param).getBoolean()) {
            throw new BajaRuntimeException("Address " + subnet + "/" + node + " already in use.");
        }
        BDeviceEntryTable entryTab = this.netmgmt().getDeviceDiscoverTable();
        entryTab.removeEntry((BDeviceEntry)discovery);
        if (dbDev.getType().is(BDynamicDevice.TYPE)) {
            BDynamicDevice dynDev = (BDynamicDevice)dbDev;
            dynDev.getDeviceData().setAuthenticate(auth);
            if (dynDev.getXmlFile() == BOrd.NULL) {
                DeviceDef def = new DeviceDef(pid);
                BOrd ord = null;
                if (def.isXml()) {
                    ord = def.getXmlOrd();
                }
                if (ord != null) {
                    dynDev.setXmlFile(ord);
                    BProgramId pi = dynDev.getDeviceData().getProgramId();
                    BImportParameters p = new BImportParameters(false, this.netmgmt().getUseLonObjects());
                    dynDev.doImportXml(p, this.getNetwork().log());
                    if (!pi.isZero()) {
                        dynDev.getDeviceData().setProgramId(pi);
                    }
                    mgr.registerForComponentEvents((BComponent)dynDev.getDeviceData(), 0);
                }
            }
        }
        mgr.reloadValue();
        return null;
    }

    public void doAllDescendants(boolean selected) {
        if (selected) {
            ((BLonDeviceManager)this.getManager()).loadDescendants();
        }
        ((BLonDeviceManager)this.getManager()).getModel().getTable().reload();
    }

    public CommandArtifact doClearDiscover() {
        this.netmgmt().getDeviceDiscoverTable().clearEntries();
        ((BLonDeviceManager)this.getManager()).updateDiscoveryRows(this.netmgmt().getDeviceDiscoverTable());
        return null;
    }

    public CommandArtifact doCommission() {
        BLonNetmgmt net = this.netmgmt();
        int[] s = this.getSelectedRows();
        if (s.length == 0) {
            return null;
        }
        BLonDevice[] devs = this.getSelectedDevices();
        if (devs.length == 1) {
            BNeuronId nId;
            int retVal;
            BLonDevice dev = devs[0];
            BDeviceData dd = dev.getDeviceData();
            if (dev.isLocal()) {
                retVal = 1;
                nId = dd.getNeuronId();
            } else {
                BCommReplDialog commReplPane = this.devicePopup("Commission", dd);
                retVal = commReplPane.getResult();
                nId = commReplPane.getSelectedNeuronId();
            }
            if (retVal == 1) {
                this.setJob(net.commissionDevice(new BCommissionParameter(dd.getSubnetNodeId(), nId, false)));
            } else if (retVal == BCommReplDialog.SERVICE_PIN) {
                BLonCommissionJob job = (BLonCommissionJob)this.setJob(net.commissionDevice(new BCommissionParameter(dd.getSubnetNodeId(), true)));
                this.getManager().attach((BWbComponentView.Attachable)new ServicePinMonitor((BWbComponentView)this.getManager(), (BLonServicePinJob)job));
            }
        } else {
            BSubnetNode[] sns = this.getSubnetNodes(devs);
            this.setJob(net.commissionDevice(new BCommissionParameter(sns)));
        }
        return null;
    }

    public CommandArtifact doReplace() {
        BLonNetmgmt net = this.netmgmt();
        int[] s = this.getSelectedRows();
        if (s.length == 0) {
            return null;
        }
        BLonDevice[] devs = this.getSelectedDevices();
        if (devs.length == 1) {
            BLonDevice dev = devs[0];
            BDeviceData dd = dev.getDeviceData();
            BCommReplDialog commReplPane = this.devicePopup("Replace", dd);
            int retVal = commReplPane.getResult();
            BNeuronId nId = commReplPane.getSelectedNeuronId();
            if (retVal == 1) {
                this.setJob(net.replaceDevice(new BCommissionParameter(dd.getSubnetNodeId(), nId, false)));
            } else if (retVal == BCommReplDialog.SERVICE_PIN) {
                BLonReplaceJob job = (BLonReplaceJob)this.setJob(net.replaceDevice(new BCommissionParameter(dd.getSubnetNodeId(), true)));
                this.getManager().attach((BWbComponentView.Attachable)new ServicePinMonitor((BWbComponentView)this.getManager(), (BLonServicePinJob)job));
            }
        } else {
            BSubnetNode[] sns = new BSubnetNode[devs.length];
            for (int i = 0; i < devs.length; ++i) {
                sns[i] = devs[i].getDeviceData().getSubnetNodeId();
            }
            this.setJob(net.replaceDevice(new BCommissionParameter(sns)));
        }
        return null;
    }

    public CommandArtifact doAppDownLoad() {
        BLonNetmgmt net = this.netmgmt();
        int[] s = this.getSelectedRows();
        if (s.length == 0) {
            return null;
        }
        BLonDevice[] devs = this.getSelectedDevices();
        try {
            BAppDownLoadPane app = new BAppDownLoadPane(this.lex(), this.opts);
            int retVal = BDialog.open((BWidget)this.getManager(), (String)"Enter Download Files", (Object)((Object)app), (int)3);
            if (retVal == 2) {
                return null;
            }
            BOrd appOrd = app.getAppOrd();
            BOrd xifOrd = app.getXifOrd();
            BOrd lnmlOrd = app.getLnmlOrd();
            BIFile appFile = null;
            BIFile xifFile = null;
            BIFile lnmlFile = null;
            if (appOrd != BOrd.NULL && !this.verifyFileType(appFile = (BIFile)appOrd.resolve().get(), "nxe")) {
                appFile = null;
            }
            if (xifOrd != BOrd.NULL && !this.verifyFileType(xifFile = (BIFile)xifOrd.resolve().get(), "xif")) {
                xifFile = null;
            }
            if (lnmlOrd != BOrd.NULL && !this.verifyFileType(lnmlFile = (BIFile)lnmlOrd.resolve().get(), "lnml")) {
                lnmlFile = null;
            }
            boolean useZero = app.useZeroCb();
            this.opts.setUseZeroBased(useZero);
            this.opts.save();
            if (appFile == null) {
                return null;
            }
            BGridPane msg = new BGridPane(1);
            msg.setRowGap(10.0);
            if (appFile != null) {
                msg.add(null, (BValue)new BLabel("This action will download " + appFile.getFileName() + "."));
            }
            if (xifFile != null) {
                msg.add(null, (BValue)new BLabel("This action will update device from " + xifFile.getFileName() + "."));
            } else if (lnmlFile != null) {
                msg.add(null, (BValue)new BLabel("This action will update device from " + lnmlFile.getFileName() + "."));
            }
            msg.add(null, (BValue)new BLabel("This is an irreversible action."));
            msg.add(null, (BValue)new BLabel("Is this the desired operation and correct file(s) ."));
            if (BDialog.confirm((BWidget)this.getManager(), (String)"Confirm Application Download", (Object)msg) != 4) {
                return null;
            }
            BSubnetNode[] sns = this.getSubnetNodes(devs);
            BAppDownloadParameter param = new BAppDownloadParameter(sns);
            byte[] a = NxeUtil.nxeFileToByteArray((BIFile)appFile);
            BProgramId appPid = NxeUtil.findProgramId((byte[])a);
            param.setAppFile(BBlob.make((byte[])a));
            XLonInterfaceFile xfile = null;
            XLonDevice xxdev = null;
            if (xifFile != null) {
                xxdev = XLonUtil.xifToXDevice((BIFile)xifFile);
                xxdev.useZeroBasedArrays = useZero;
                BProgramId xifPid = BProgramId.make((byte[])xxdev.deviceData.programID);
                if (!appPid.equals((Object)xifPid)) {
                    BDialog.error((BWidget)this.getManager(), (Object)"Specified files are for different device types.");
                    return null;
                }
                param.setNvDirFile(BBlob.make((byte[])NxeUtil.getNvDirectionByteArray((XLonDevice)xxdev)));
            } else if (lnmlFile != null) {
                xfile = LonXMLReader.decode((BIFile)lnmlFile);
                XLonDevice xdev = xfile.getLonDevice();
                BProgramId xmlPid = BProgramId.make((byte[])xdev.deviceData.programID);
                if (!appPid.equals((Object)xmlPid)) {
                    BDialog.error((BWidget)this.getManager(), (Object)"Specified files are for different device types.");
                    return null;
                }
                param.setNvDirFile(BBlob.make((byte[])NxeUtil.getNvDirectionByteArray((XLonDevice)xdev)));
            }
            if (!this.verifyProgramId(appPid, devs)) {
                return null;
            }
            for (int i = 0; i < devs.length; ++i) {
                BProgramId origPid = devs[i].getDeviceData().getProgramId();
                if (xxdev != null) {
                    NxeUtil.updateDevice((BLonDevice)devs[i], (XLonDevice)xxdev);
                } else if (xfile != null) {
                    NxeUtil.updateDevice((BLonDevice)devs[i], (XLonInterfaceFile)xfile);
                } else {
                    devs[i].getDeviceData().setProgramId(appPid);
                }
                if (!(devs[i] instanceof BDynamicDevice) || origPid.equals((Object)appPid)) continue;
                ((BDynamicDevice)devs[i]).setXmlFile(lnmlOrd);
            }
            param.setBind(app.isBindSelected());
            this.setJob(net.appDownLoad(param));
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getManager(), (String)"Error:", (Object)e, (Throwable)e);
            return null;
        }
        return null;
    }

    private boolean verifyFileType(BIFile file, String ext) {
        if (!file.getExtension().equalsIgnoreCase(ext)) {
            BDialog.error((BWidget)this.getManager(), (Object)("Invalid file extension. Expected \"." + ext + "\""));
            return false;
        }
        return true;
    }

    private boolean verifyProgramId(BProgramId appPid, BLonDevice[] devs) {
        for (int i = 0; i < devs.length; ++i) {
            int resp;
            BProgramId devPid = devs[i].getDeviceData().getProgramId();
            if (appPid.equals((Object)devPid)) continue;
            if (!appPid.getMfgId().equals((Object)devPid.getMfgId())) {
                resp = this.confirm((BWidget)this.getManager(), "Confirm Manufacturers Change", "Application for " + devs[i].getDisplayName(null) + " is by diferent Manufacturer\nThe device may not be able to execute this application.\n\nContinue operation.");
                if (resp == 8) {
                    return false;
                }
                if (resp != 2) continue;
                return true;
            }
            resp = this.confirm((BWidget)this.getManager(), "Confirm ProgramId Change", "Application for " + devs[i].getDisplayName(null) + " has different ProgramId than device.\n\nContinue operation.");
            if (resp == 8) {
                return false;
            }
            if (resp != 2) continue;
            return true;
        }
        return true;
    }

    private int confirm(BWidget parent, String title, Object content) {
        int buttons = 14;
        BImage icon = BDialog.QUESTION_ICON;
        String details = null;
        BLabel c = new BLabel(String.valueOf(content), BHalign.left);
        BOptionDialog dialog = new BOptionDialog(parent, title, (BWidget)c, buttons, icon, details);
        dialog.getCancelButton().setText("Yes To All");
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.getResult();
    }

    public CommandArtifact doQuikLearn() {
        BLonNetmgmt net = this.netmgmt();
        int[] s = this.getSelectedRows();
        boolean selectDevices = s.length > 0;
        BGridPane pane = new BGridPane(1);
        BCheckBox unmanaged = new BCheckBox(this.lex().getText("learnPopup.unmanaged"));
        BCheckBox learnLinks = new BCheckBox(this.lex().getText("learnPopup.learnLinks"));
        BCheckBox upload = new BCheckBox(this.lex().getText("learnPopup.upload"), true);
        if (selectDevices) {
            pane.add(null, (BValue)new BLabel(this.lex().getText("learnPopup.learnLinksSelected")));
        } else {
            pane.add(null, (BValue)unmanaged);
            pane.add(null, (BValue)learnLinks);
            pane.add(null, (BValue)upload);
        }
        int retVal = BDialog.open((BWidget)this.getManager(), (String)"Learn", (Object)pane, (int)3);
        if (retVal == 2) {
            return null;
        }
        BLearnParameter learnParam = new BLearnParameter();
        learnParam.setUnmanagedNetwork(unmanaged.isSelected());
        learnParam.setLearnLinks(learnLinks.isSelected());
        learnParam.setUploadConfigData(upload.isSelected());
        learnParam.setContainer(((BComponent)this.getManager().getCurrentValue()).getOrdInSession());
        if (selectDevices) {
            BLonDevice[] devs = this.getSelectedDevices();
            BSubnetNode[] sn = new BSubnetNode[devs.length];
            for (int i = 0; i < devs.length; ++i) {
                sn[i] = devs[i].getDeviceData().getSubnetNodeId();
            }
            learnParam.setSubnetNodeArray(LonStringUtil.toString((BSimple[])sn));
            this.setJob(net.learn(learnParam));
        } else {
            this.setJob(net.learn(learnParam));
        }
        return null;
    }

    public void setUseNetAddress(boolean selected) {
        ((BLonDeviceManager)this.getManager()).setUseNetAddress(selected);
        this.useNetAddrToggle.doSetSelected(selected);
        this.useDbAddrToggle.doSetSelected(!selected);
    }

    private BLonNetmgmt netmgmt() {
        return ((BLonDeviceManager)this.getManager()).getNetwork().netmgmt();
    }

    private BLonNetwork getNetwork() {
        return ((BLonDeviceManager)this.getManager()).getNetwork();
    }

    private BSubnetNode[] getSubnetNodes(BLonDevice[] devs) {
        BSubnetNode[] sns = new BSubnetNode[devs.length];
        for (int i = 0; i < devs.length; ++i) {
            sns[i] = devs[i].getDeviceData().getSubnetNodeId();
        }
        return sns;
    }

    private UiLexicon lex() {
        return BLonDeviceManager.lexicon;
    }

    private BCommReplDialog devicePopup(String label, BDeviceData dd) {
        BNeuronId[] nids;
        BNeuronId nid = dd.getNeuronId();
        BProgramId pId = dd.getProgramId();
        if (!nid.equals((Object)BNeuronId.DEFAULT)) {
            nids = new BNeuronId[]{nid};
        } else {
            ArrayList<BNeuronId> unnamedEntries = new ArrayList<BNeuronId>();
            BDeviceEntry[] a = this.netmgmt().getDeviceDiscoverTable().getDeviceEntries();
            for (int i = 0; i < a.length; ++i) {
                BDeviceEntry entry = a[i];
                if (entry.getDevName() != null && !entry.getDevName().equals("") || pId != null && !entry.getProgramId().equals((Object)pId)) continue;
                unnamedEntries.add(entry.getNeuronId());
            }
            BNeuronId[] unnamed = new BNeuronId[unnamedEntries.size()];
            nids = unnamedEntries.toArray(unnamed);
        }
        BCommReplDialog commReplPane = new BCommReplDialog((BWidget)this.getManager(), label, nids);
        commReplPane.setBoundsCenteredOnOwner();
        commReplPane.open();
        return commReplPane;
    }

    private BJob setJob(BOrd jobOrd) {
        try {
            BComponent base = (BComponent)this.getManager().getCurrentValue();
            base.getComponentSpace().sync();
            BJob job = (BJob)jobOrd.get((BObject)base);
            this.getManager().registerForComponentEvents((BComponent)job);
            ((BLonDeviceManager)this.getManager()).getJobBar().load(job);
            return job;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private BLonDevice[] getSelectedDevices() {
        if (this.getTable() == null) {
            return new BLonDevice[0];
        }
        BComponent[] a = this.getTable().getSelectedComponents();
        Array al = new Array(BLonDevice.class);
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].getType().is(BLonDevice.TYPE)) continue;
            al.add((Object)((BLonDevice)a[i]));
        }
        return (BLonDevice[])al.trim();
    }

    class UseDbAddressToggle
    extends MgrController.MgrToggleCommand {
        UseDbAddressToggle(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.useDbAddress");
        }

        public void setSelected(boolean sel) {
            LonDeviceController.this.setUseNetAddress(!sel);
        }

        public void doSetSelected(boolean sel) {
            super.setSelected(sel);
        }
    }

    class UseNetAddressToggle
    extends MgrController.MgrToggleCommand {
        UseNetAddressToggle(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.useNetAddress");
        }

        public void setSelected(boolean sel) {
            LonDeviceController.this.setUseNetAddress(sel);
        }

        public void doSetSelected(boolean sel) {
            super.setSelected(sel);
        }
    }

    class QuikLearn
    extends MgrController.MgrCommand {
        QuikLearn(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.quikLearn");
        }

        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doQuikLearn();
        }
    }

    class AppDownLoad
    extends MgrController.MgrCommand {
        AppDownLoad(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.appDownLoad");
        }

        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doAppDownLoad();
        }
    }

    class Replace
    extends MgrController.MgrCommand {
        Replace(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.replace");
        }

        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doReplace();
        }
    }

    class Commission
    extends MgrController.MgrCommand {
        Commission(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.commission");
        }

        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doCommission();
        }
    }

    class ClearTable
    extends MgrController.MgrCommand {
        ClearTable(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.clearDiscoverTable");
        }

        public CommandArtifact doInvoke() throws Exception {
            return LonDeviceController.this.doClearDiscover();
        }
    }

    class LonDiscover
    extends MgrController.MgrCommand {
        LonDiscover(BWidget owner) {
            super(owner, (Lexicon)LonDeviceController.this.lex(), "commands.discover");
        }

        public CommandArtifact doInvoke() throws Exception {
            LonDeviceController.this.learnMode.setSelected(true);
            LonDeviceController.this.setJob(LonDeviceController.this.netmgmt().discover());
            return null;
        }
    }
}

