/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.device;

import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.local.BLocalNci;
import com.tridium.lonworks.local.BLocalNv;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUtil;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonSnvtType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BLocalNvManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BLocalNvManager.class);
    Hashtable<MgrEditRow, BFacets> rowFacetHash = new Hashtable();
    public static BWbEditor xeditor = null;
    private static String LNML_ORD = "LnmlOrd";
    private static String XTYPE = "XType";
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BLocalNvManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colNvSum = new MgrColumn.ToString(lexicon.getText("manager.summary"), 0);
    MgrColumn colNvNdx = new NvIndexCol();
    MgrColumn colNvDir = new NvDirectionCol();
    MgrColumn colSelector = new MgrColumn.PropPath(new Property[]{BLocalNv.nvConfigData, BNvConfigData.selector}, 2);
    MgrColumn colSnvtTyp = new SnvtTypeCol();
    MgrColumn colSelfDoc = new SelfDocCol();
    MgrColumn colXmlFile = new XmlColumn();
    MgrColumn colNvTyp = new XTypeCol();
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colNvSum, this.colNvNdx, this.colNvDir, this.colSelector, this.colSnvtTyp, this.colSelfDoc, this.colXmlFile, this.colNvTyp};

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new LocalNvModel(this);
    }

    private void removeAllDataProps(BLonComponent c) {
        Property[] a = c.getPropertiesArray();
        for (int i = 0; i < a.length; ++i) {
            if (!BLonData.isDataProp((Property)a[i])) continue;
            c.remove(a[i]);
        }
    }

    private static BOrd getOrd(BComponent c) {
        BString lnml;
        if (!c.isMounted()) {
            return null;
        }
        BFacets f = c.getPropertyInParent().getFacets();
        if (f != null && (lnml = (BString)f.get(LNML_ORD)) != null) {
            return BOrd.make((String)lnml.getString());
        }
        return null;
    }

    private static String getType(BComponent c) {
        BString xtyp;
        if (!c.isMounted()) {
            return null;
        }
        BFacets f = c.getPropertyInParent().getFacets();
        if (f != null && (xtyp = (BString)f.get(XTYPE)) != null) {
            return xtyp.getString();
        }
        return null;
    }

    private static BDynamicEnum getTypeEnum(BOrd xmlOrd) {
        XLonInterfaceFile root = LonXMLReader.decode((BOrd)xmlOrd);
        if (root == null) {
            return BDynamicEnum.DEFAULT;
        }
        Array aTag = new Array(String.class);
        BLocalNvManager.scanTypeEnum(root, (Array<String>)aTag);
        BEnumRange er = BEnumRange.make((String[])((String[])aTag.trim()));
        return BDynamicEnum.make((int)0, (BEnumRange)er);
    }

    private static void scanTypeEnum(XLonInterfaceFile root, Array<String> aTag) {
        Vector types = root.types;
        for (int i = 0; i < types.size(); ++i) {
            String xtyp = ((XTypeDef)types.elementAt(i)).getName();
            aTag.add((Object)xtyp);
        }
        Vector imports = root.imports;
        for (int i = 0; i < imports.size(); ++i) {
            XLonInterfaceFile xfile = (XLonInterfaceFile)imports.elementAt(i);
            BLocalNvManager.scanTypeEnum(xfile, aTag);
        }
    }

    class XTypeCol
    extends LocalColumn {
        public XTypeCol() {
            super(lexicon.getText("local.xType"), 1);
        }

        @Override
        public BValue load(MgrEditRow row) {
            return ((BValue)this.get(row.getTarget())).newCopy();
        }

        public Object get(Object tgt) {
            String xtyp;
            BOrd ord = BLocalNvManager.getOrd((BComponent)tgt);
            if (ord == null) {
                return BDynamicEnum.DEFAULT;
            }
            BDynamicEnum e = BLocalNvManager.getTypeEnum(ord);
            BEnumRange rng = e.getRange();
            if (rng.isTag(xtyp = BLocalNvManager.getType((BComponent)tgt))) {
                e = (BDynamicEnum)rng.get(xtyp);
            }
            return e;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent c = row.getTarget();
            String xtyp = ((BEnum)value).getTag();
            boolean typeChanged = true;
            if (c.isMounted()) {
                Property p = c.getPropertyInParent();
                BFacets f = p.getFacets();
                if (xtyp.length() == 0 || xtyp.equals("0")) {
                    if (f != null && f.get(XTYPE) != null) {
                        f = BFacets.makeRemove((BFacets)f, (String)XTYPE);
                        ((BComponent)c.getParent()).setFacets((Slot)p, f);
                    }
                    return;
                }
                if (f == null) {
                    f = BFacets.make((String)XTYPE, (BIDataValue)BString.make((String)xtyp));
                } else {
                    BString xf = (BString)f.get(XTYPE);
                    if (xf != null && xtyp.equals(xf.getString())) {
                        typeChanged = false;
                    } else {
                        f = BFacets.make((BFacets)f, (String)XTYPE, (BIDataValue)BString.make((String)xtyp));
                    }
                }
                c.getParent().setFacets((Slot)p, f);
            } else {
                BFacets f = BLocalNvManager.this.rowFacetHash.get(row);
                f = f == null ? BFacets.make((String)XTYPE, (BIDataValue)BString.make((String)xtyp)) : BFacets.make((BFacets)f, (String)XTYPE, (BIDataValue)BString.make((String)xtyp));
                BLocalNvManager.this.rowFacetHash.put(row, f);
            }
            int snvtType = ((BLonSnvtType)row.getCell(((BLocalNvManager)this.getManager()).colSnvtTyp)).getOrdinal();
            if (snvtType > 0 || !typeChanged) {
                return;
            }
            if (c instanceof BLonComponent) {
                BLonComponent lc = (BLonComponent)c;
                BOrd ord = (BOrd)row.getCell(BLocalNvManager.this.colXmlFile);
                if (ord == null || ord.equals((Object)BOrd.DEFAULT)) {
                    return;
                }
                XLonInterfaceFile xfile = LonXMLReader.decode((BOrd)ord);
                XLonInterfaceFile st = XUtil.getStandard();
                if (st != null) {
                    xfile.addAttribute("standard", (Object)st);
                }
                XTypeDef xdef = xfile.resolveTypeDef(xtyp);
                BLocalNvManager.this.removeAllDataProps(lc);
                lc.setData(xdef.getLonData(xfile));
            }
        }

        @Override
        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor e) {
            BWbEditor ed;
            xeditor = ed = super.toEditor(rows, colIndex, e);
            return ed;
        }
    }

    class XmlColumn
    extends LocalColumn {
        public XmlColumn() {
            super(lexicon.getText("local.xmlFile"), 1);
        }

        public Object get(Object tgt) {
            BOrd ord = BLocalNvManager.getOrd((BComponent)tgt);
            return ord != null ? ord : BOrd.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent c = row.getTarget();
            BOrd xml = (BOrd)row.getCell(BLocalNvManager.this.colXmlFile);
            if (c.isMounted()) {
                Property p = c.getPropertyInParent();
                BFacets f = p.getFacets();
                if (xml.equals((Object)BOrd.DEFAULT)) {
                    if (f != null && f.get(LNML_ORD) != null) {
                        f = BFacets.makeRemove((BFacets)f, (String)LNML_ORD);
                        ((BComponent)c.getParent()).setFacets((Slot)p, f);
                    }
                } else {
                    f = f == null ? BFacets.make((String)LNML_ORD, (BIDataValue)BString.make((String)xml.encodeToString())) : BFacets.make((BFacets)f, (String)LNML_ORD, (BIDataValue)BString.make((String)xml.encodeToString()));
                    ((BComponent)c.getParent()).setFacets((Slot)p, f);
                }
            } else if (!xml.equals((Object)BOrd.DEFAULT)) {
                BFacets f = BFacets.make((String)LNML_ORD, (BIDataValue)BString.make((String)xml.encodeToString()));
                BLocalNvManager.this.rowFacetHash.put(row, f);
            }
        }

        @Override
        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BLocalNvManager mgr = (BLocalNvManager)this.getManager();
            BWbFieldEditor e = (BWbFieldEditor)editor;
            BValue val = (BValue)e.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                boolean changed = !rows[i].getCell(colIndex).equals((Object)val);
                rows[i].setCell(colIndex, val);
                if (!changed) continue;
                BDynamicEnum de = BLocalNvManager.getTypeEnum((BOrd)val);
                rows[i].setCell(mgr.colNvTyp, (BValue)de);
                if (xeditor == null) continue;
                xeditor.loadValue((BObject)de);
            }
        }
    }

    class SnvtTypeCol
    extends LocalColumn {
        public SnvtTypeCol() {
            super(lexicon.getText("local.snvtType"), 1);
        }

        public Object get(Object tgt) {
            int snvtNdx = ((BINetworkVariable)tgt).getSnvtType();
            if (!BLonSnvtType.SnvtXxx.getRange().isOrdinal(snvtNdx)) {
                return BLonSnvtType.SnvtAmp;
            }
            return BLonSnvtType.make((int)snvtNdx);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            int snvtType = ((BLonSnvtType)value).getOrdinal();
            BComponent tgt = row.getTarget();
            if (tgt.getType().is(BLocalNv.TYPE)) {
                BLocalNv lnv = (BLocalNv)tgt;
                if (lnv.getNvProps().getSnvtType() == snvtType) {
                    return;
                }
                BLocalNvManager.this.removeAllDataProps((BLonComponent)lnv);
                lnv.getNvProps().setSnvtType(snvtType);
                BLonData dat = SnvtUtil.getLonData((int)snvtType, (int)2);
                DynaDev.setNonCritical((BLonData)dat);
                if (snvtType > 0) {
                    lnv.setData(dat);
                }
            } else if (tgt.getType().is(BLocalNci.TYPE)) {
                BLocalNci lnc = (BLocalNci)tgt;
                if (lnc.getNcProps().getSnvtType() == snvtType) {
                    return;
                }
                BLocalNvManager.this.removeAllDataProps((BLonComponent)lnc);
                lnc.getNcProps().setSnvtType(snvtType);
                if (snvtType > 0) {
                    lnc.setData(SnvtUtil.getLonData((int)snvtType, (int)2));
                }
            }
            if (snvtType > 0) {
                Property p;
                BFacets f;
                BLocalNvManager mgr = (BLocalNvManager)this.getManager();
                row.setCell(mgr.colXmlFile, (BValue)BOrd.DEFAULT);
                row.setCell(mgr.colNvTyp, (BValue)BDynamicEnum.DEFAULT);
                if (tgt.isMounted() && (f = (p = tgt.getPropertyInParent()).getFacets()) != null) {
                    f = BFacets.makeRemove((BFacets)f, (String)LNML_ORD);
                    f = BFacets.makeRemove((BFacets)f, (String)XTYPE);
                    ((BComponent)tgt.getParent()).setFacets((Slot)p, f);
                }
            }
        }
    }

    static class SelfDocCol
    extends LocalColumn {
        public SelfDocCol() {
            super(lexicon.getText("local.selfDoc"), 1);
        }

        public Object get(Object tgt) {
            if (tgt instanceof BLocalNv) {
                BLocalNv lnv = (BLocalNv)tgt;
                return BString.make((String)lnv.getSelfDoc());
            }
            if (tgt instanceof BLocalNci) {
                BLocalNci lnc = (BLocalNci)tgt;
                return BString.make((String)lnc.getSelfDoc());
            }
            return null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            String val = ((BString)value).getString();
            BComponent tgt = row.getTarget();
            if (tgt instanceof BLocalNv) {
                BLocalNv lnv = (BLocalNv)tgt;
                lnv.setSelfDoc(val);
            } else if (tgt instanceof BLocalNci) {
                BLocalNci lnc = (BLocalNci)tgt;
                lnc.setSelfDoc(val);
            }
        }
    }

    static class NvDirectionCol
    extends LocalColumn {
        Type tgtType = null;

        public NvDirectionCol() {
            super(lexicon.getText("local.direction"), 1);
        }

        @Override
        public BValue load(MgrEditRow row) {
            this.tgtType = row.getTarget().getType();
            return super.load(row);
        }

        public Object get(Object tgt) {
            return ((BINetworkVariable)tgt).getNvConfigData().getDirection();
        }

        public boolean isReadonly() {
            if (this.tgtType == null) {
                return super.isReadonly();
            }
            return this.tgtType.is(BLocalNci.TYPE);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BLonNvDirection dir = (BLonNvDirection)value;
            ((BINetworkVariable)row.getTarget()).getNvConfigData().setDirection(dir);
        }
    }

    static class NvIndexCol
    extends LocalColumn {
        public NvIndexCol() {
            super(lexicon.getText("local.nvIndex"), 0);
        }

        public Object get(Object tgt) {
            int nvIndex = ((BINetworkVariable)tgt).getNvIndex();
            return BInteger.make((int)nvIndex);
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            int nvIndex = ((BInteger)value).getInt();
            ((BINetworkVariable)row.getTarget()).setNvIndex(nvIndex);
        }
    }

    static abstract class LocalColumn
    extends MgrColumn {
        public LocalColumn(String displayName, int flags) {
            super(displayName, flags);
        }

        public BValue load(MgrEditRow row) {
            return ((BValue)this.get(row.getTarget())).newCopy();
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor e) {
            BValue v = rows[0].getCell(colIndex);
            if (e == null) {
                e = BWbFieldEditor.makeFor((BObject)v);
            }
            e.loadValue((BObject)v);
            return e;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            LocalColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, null);
        }
    }

    public class LocalNvModel
    extends MgrModel {
        public LocalNvModel(BLocalNvManager manager) {
            super((BAbstractManager)manager);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BLocalNv.TYPE, BLocalNci.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BLocalNv.TYPE), MgrTypeInfo.make((Type)BLocalNci.TYPE)};
        }

        protected MgrColumn[] makeColumns() {
            return BLocalNvManager.this.cols;
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            BComponent container = rows[0].getTargetParent();
            Context tx = Transaction.start((BComponent)container, null);
            for (int i = 0; i < rows.length; ++i) {
                MgrEditRow r = rows[i];
                this.add(r, container, cx);
            }
            Transaction.end((BComponent)container, (Context)tx);
            return null;
        }

        private void add(MgrEditRow row, BComponent parent, Context cx) throws Exception {
            BComponent tgt = row.getTarget();
            BFacets typFacets = BLocalNvManager.this.rowFacetHash.get(row);
            parent.add(row.getName(), (BValue)tgt, 0, typFacets, cx);
        }
    }
}

