/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.changeable;

import com.tridium.lonworks.datatypes.BChangeNvTypeParameter;
import com.tridium.lonworks.util.LonStringUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.control.BControlPoint;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonSnvtType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.util.ScptUtil;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BChangeableNvManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BChangeableNvManager.class);
    private BLonDevice dev;
    private BTable nvTable = new BTable();
    private NvTableModel nvTableModel;
    private BButton updateBtn;
    private BButton editBtn;
    private BJobBar jobBar;
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BChangeableNvManager.class);

    public Type getType() {
        return TYPE;
    }

    public BChangeableNvManager() {
        this.nvTable.setController((TableController)new Controller());
        this.autoRegisterForComponentEvents = false;
    }

    public void doLoadValue(BObject value, Context context) {
        this.dev = (BLonDevice)value;
        this.registerForComponentEvents((BComponent)this.dev, 4);
        Command editCommand = new Command((BWidget)this.getWbShell(), BChangeableNvManager.lexicon.module, "change.editType"){

            public CommandArtifact doInvoke() {
                BChangeableNvManager.this.editType();
                return null;
            }
        };
        this.editBtn = new BButton(editCommand, true, true);
        this.editBtn.setEnabled(false);
        Command updateCommand = new Command((BWidget)this.getWbShell(), BChangeableNvManager.lexicon.module, "change.updateType"){

            public CommandArtifact doInvoke() {
                BChangeableNvManager.this.updateType();
                return null;
            }
        };
        this.updateBtn = new BButton(updateCommand, true, true);
        this.updateBtn.setEnabled(true);
        this.nvTableModel = new NvTableModel();
        this.nvTable.setModel((TableModel)this.nvTableModel);
        this.nvTable.setMultipleSelection(true);
        BFlowPane buttonPane = new BFlowPane(BHalign.center);
        buttonPane.add("editType", (BValue)this.editBtn);
        buttonPane.add("updateType", (BValue)this.updateBtn);
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        BEdgePane bottomPane = new BEdgePane();
        bottomPane.setCenter((BWidget)buttonPane);
        BEdgePane mainPane = new BEdgePane();
        mainPane.setCenter((BWidget)BTitlePane.makePane((String)lexicon.getText("changeableNv"), (BTable)this.nvTable));
        mainPane.setBottom((BWidget)new BBorderPane((BWidget)bottomPane));
        mainPane.setTop((BWidget)jobPane);
        this.setContent((BWidget)mainPane);
        this.refreshTable();
    }

    private void refreshTable() {
        this.nvTableModel.removeAllRows();
        this.dev.refreshNvList();
        BINetworkVariable[] nvs = this.dev.getNetworkVariables();
        for (int i = 0; i < nvs.length; ++i) {
            BNetworkVariable nv;
            if (nvs[i] == null || !nvs[i].isNetworkVariable() || !(nv = (BNetworkVariable)nvs[i]).getNvProps().getChangeableType()) continue;
            this.nvTableModel.addRow(nv.getDisplayName(null), i, BLonSnvtType.make((int)nv.getNvProps().getSnvtType()));
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        if (event.getId() == 0 && event.getSlot() == BNetworkVariable.nvProps && ((BNvProps)event.getValue()).getChangeableType() || event.getId() == 5 && event.getSlot() == BDynamicDevice.dynamicOpComplete) {
            this.refreshTable();
        }
    }

    private void updateType() {
        int[] nvs;
        TableSelection sel = this.nvTable.getSelection();
        if (sel.getRows().length > 0) {
            int[] rows = sel.getRows();
            nvs = new int[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                nvs[i] = this.nvTableModel.getEntry((int)rows[i]).nvIndex;
            }
        } else {
            int cnt = this.nvTableModel.getRowCount();
            nvs = new int[cnt];
            for (int i = 0; i < cnt; ++i) {
                nvs[i] = this.nvTableModel.getEntry((int)i).nvIndex;
            }
        }
        this.changeNvType(this.dev, nvs, null, 0, 0, true);
    }

    private void editType() {
        int n;
        TableSelection sel = this.nvTable.getSelection();
        if (sel.getRows().length < 1) {
            return;
        }
        int[] rows = sel.getRows();
        BGridPane p = new BGridPane(2);
        p.add("label", (BValue)new BLabel(lexicon.getText("change.editTypeText")));
        BListDropDown nvType = new BListDropDown();
        BList blist = nvType.getList();
        BLonSnvtType snvt = this.nvTableModel.getEntry((int)rows[0]).nvType;
        String selSnvt = this.fillNvTypeList(blist, snvt);
        nvType.setSelectedItem((Object)selSnvt);
        p.add("comboBox", (BValue)nvType);
        p.add(null, (BValue)new BWidget());
        int retVal = BDialog.open((BWidget)this, (String)lexicon.getText("change.editType.description"), (Object)p, (int)3);
        if (retVal == 2) {
            return;
        }
        int[] nvs = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            nvs[i] = this.nvTableModel.getEntry((int)rows[i]).nvIndex;
        }
        int snvtType = this.getSnvtTypeFromDisplayString((String)blist.getSelectedItem());
        BLonData ld = SnvtUtil.getLonData((int)snvtType);
        int newLen = ld.getByteLength();
        for (n = 0; n < nvs.length; ++n) {
            BLonComponent lc = ScptUtil.findScptForNv((BLonDevice)this.dev, (int)nvs[n], (int)255);
            int maxLen = 10;
            if (lc == null || (maxLen = lc.getLonInt("maxNVLength")) >= newLen) continue;
            BDialog.error((BWidget)this, (String)"Max Length Error", (Object)"Length of selected type exceeds max.", (String)("Selected type has length of " + newLen + ".\nMaximum length specified in " + lc.getDisplayName(null) + " = " + maxLen + "."));
            return;
        }
        for (n = 0; n < nvs.length; ++n) {
            BNetworkVariable nv = this.dev.getNetworkVariable(nvs[n]);
            if (this.checkLinks(nv)) {
                return;
            }
            if (this.checkProxyPoints((BLonComponent)nv)) {
                return;
            }
            BLonComponent[] lcs = ScptUtil.findInheritedConfigsForNv((BLonDevice)this.dev, (int)nvs[n]);
            for (int i = 0; i < lcs.length; ++i) {
                if (!this.checkProxyPoints(lcs[i])) continue;
                return;
            }
        }
        this.changeNvType(this.dev, nvs, ld, 0, snvtType, false);
    }

    private boolean checkLinks(BNetworkVariable nv) {
        BLink[] lks = this.dev.getLinks((Slot)nv.getPropertyInParent());
        if (lks.length > 0) {
            int resp = BDialog.open((BWidget)this, (String)"Linked Nv", (Object)(nv.getDisplayName(null) + " is linked.\n \nPress OK to delete links.\n"), (int)3, (BImage)BDialog.WARNING_ICON);
            if (resp != 1) {
                return true;
            }
            for (int j = 0; j < lks.length; ++j) {
                this.dev.remove((BComplex)lks[j]);
            }
        }
        return false;
    }

    private boolean checkProxyPoints(BLonComponent lc) {
        BControlPoint[] pxs = this.dev.getLonProxies(lc);
        if (pxs.length > 0) {
            String title = lc.isNetworkVariable() ? "Nv has proxies " : "Inherited cp has proxies";
            int resp = BDialog.open((BWidget)this, (String)title, (Object)(lc.getDisplayName(null) + " has proxies.\n \nPress OK to delete proxies.\n"), (int)3, (BImage)BDialog.WARNING_ICON);
            if (resp != 1) {
                return true;
            }
            for (int j = 0; j < pxs.length; ++j) {
                ((BComponent)pxs[j].getParent()).remove((BComplex)pxs[j]);
            }
        }
        return false;
    }

    private void changeNvType(BLonDevice dev, int[] nvs, BLonData data, int typeScope, int typeIndex, boolean update) {
        Action act = dev.getAction("ChangeNvTypeAction");
        if (act == null) {
            throw new RuntimeException("No ChangeNvType action on dev " + dev.getDisplayName(null));
        }
        String[] cnfs = new String[nvs.length];
        BNetworkConfig[] ncis = dev.getNetworkConfigs();
        BConfigParameter[] cps = dev.getConfigParameters();
        for (int n = 0; n < nvs.length; ++n) {
            BNcProps ncProps;
            int i;
            int nvIndex = nvs[n];
            BNetworkConfig nvTypeCnfg = null;
            for (i = 0; i < ncis.length; ++i) {
                BNetworkConfig nci = ncis[i];
                ncProps = nci.getNcProps();
                if (!ncProps.getScope().equals((Object)BLonConfigScope.nv) || !ScptUtil.doesSelectContain((int)nvIndex, (String)ncProps.getSelect()) || ncProps.getConfigIndex() != 254) continue;
                nvTypeCnfg = nci;
                break;
            }
            if (nvTypeCnfg == null) {
                for (i = 0; i < cps.length; ++i) {
                    BConfigParameter cp = cps[i];
                    ncProps = cp.getConfigProps();
                    if (!ncProps.getScope().equals((Object)BLonConfigScope.nv) || !ScptUtil.doesSelectContain((int)nvIndex, (String)ncProps.getSelect()) || ncProps.getConfigIndex() != 254) continue;
                    nvTypeCnfg = cp;
                    break;
                }
            }
            if (nvTypeCnfg == null) {
                throw new RuntimeException("No NvType Scpt for nv" + nvIndex);
            }
            cnfs[n] = nvTypeCnfg.getName();
        }
        BChangeNvTypeParameter chngParm = new BChangeNvTypeParameter();
        chngParm.setNvIndex(LonStringUtil.toString((int[])nvs));
        chngParm.setNvTypeScpt(LonStringUtil.toString((String[])cnfs));
        chngParm.setUpdate(update);
        if (!update) {
            chngParm.setTypeScope(typeScope);
            chngParm.setTypeIndex(typeIndex);
            chngParm.updateNvTypePara(data);
        }
        BOrd ord = (BOrd)dev.invoke(act, (BValue)chngParm);
        this.setJob(ord);
    }

    private void setJob(BOrd jobOrd) {
        try {
            BComponent base = (BComponent)this.getCurrentValue();
            base.getComponentSpace().sync();
            BJob job = (BJob)jobOrd.get((BObject)base);
            this.registerForComponentEvents((BComponent)job);
            this.jobBar.load(job);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private String fillNvTypeList(BList blist, BLonSnvtType selNv) {
        BEnumRange range = BLonSnvtType.SnvtXxx.getRange();
        int[] ords = range.getOrdinals();
        Array a = new Array(String.class, ords.length);
        String selNvObj = null;
        for (int i = 0; i < ords.length; ++i) {
            String e = range.getTag(ords[i]) + " " + ords[i];
            a.add((Object)e);
            if (range.get(ords[i], false) != selNv) continue;
            selNvObj = e;
        }
        a = a.sort();
        String[] sa = (String[])a.array();
        for (int i = 0; i < sa.length; ++i) {
            blist.addItem((Object)sa[i]);
        }
        return selNvObj;
    }

    private int getSnvtTypeFromDisplayString(String s) {
        return Integer.parseInt(s.substring(s.indexOf(32) + 1));
    }

    static class NvType {
        public String nvName;
        public int nvIndex;
        public BLonSnvtType nvType;

        NvType() {
        }
    }

    static class NvTableModel
    extends DefaultTableModel {
        public NvTableModel() {
            this(new String[]{"nvName", "nvIndex", "type"});
        }

        private NvTableModel(String[] colNames) {
            super(colNames);
        }

        public void addRow(String nvName, int nvIndex, BLonSnvtType nvType) {
            Object[] obj = new Object[]{nvName, new Integer(nvIndex), nvType};
            this.addRow(obj);
        }

        public NvType getEntry(int row) {
            NvType entry = new NvType();
            entry.nvName = (String)this.getValueAt(row, 0);
            entry.nvIndex = (Integer)this.getValueAt(row, 1);
            entry.nvType = (BLonSnvtType)this.getValueAt(row, 2);
            return entry;
        }

        public void setEntry(int row, NvType entry) {
            this.set(row, 0, entry.nvName);
            this.set(row, 1, new Integer(entry.nvIndex));
            this.set(row, 2, entry.nvType);
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void focusGained(BFocusEvent event) {
            this.checkEdit();
            this.getTable().repaint();
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            this.checkEdit();
            this.getTable().repaint();
        }

        protected void backgroundReleased(BMouseEvent event) {
            super.backgroundReleased(event);
            BChangeableNvManager.this.editBtn.setEnabled(false);
        }

        private void checkEdit() {
            BTable table = this.getTable();
            TableSelection sel = table.getSelection();
            boolean edit = sel.getRows().length > 0;
            BChangeableNvManager.this.editBtn.setEnabled(edit);
        }
    }
}

