/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BUtilCmdJob;
import com.tridium.lonworks.datatypes.BUtilitiesCommand;
import com.tridium.lonworks.enums.BUtilCommandEnum;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.ui.BLonDeviceFE;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RunnableCommand;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BLonUtilitiesManager
extends BWbComponentView {
    public static final Action updateSubCommands = BLonUtilitiesManager.newAction((int)4, null);
    public static final Action updateCommands = BLonUtilitiesManager.newAction((int)4, null);
    public static final Action updateAux = BLonUtilitiesManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BLonUtilitiesManager.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BLonUtilitiesManager.class);
    BLonNetwork lonNetwork;
    BJobBar jobBar;
    BTextEditor textArea;
    BLonDeviceFE deviceFE;
    BTextDropDown command;
    BTextDropDown subCommand;
    BButton executeButton;
    BGridPane memoryPane;
    BGridPane subCmdPane;
    BTextField memAddress;
    BTextField memLength;
    BLabel otherFileLabel;
    BTextField otherFile;
    Context context;
    Command executeCmd;
    boolean routerSelected = false;
    boolean discoveredSelected = false;
    boolean localSelected = false;

    public void updateSubCommands() {
        this.invoke(updateSubCommands, null, null);
    }

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public void updateAux() {
        this.invoke(updateAux, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        boolean update = false;
        if (event.getId() == 1 || event.getId() == 2) {
            Type srcTyp = event.getSlot().asProperty().getType();
            update = srcTyp.is(BLonDevice.TYPE) || srcTyp.is(BLonRouter.TYPE);
        } else if (event.getId() == 5 && (event.getSlot() == BLonNetmgmt.deviceDiscoveryUpdated || event.getSlot() == BLonNetmgmt.routerDiscoveryUpdated)) {
            update = true;
        }
        if (update) {
            this.deviceFE.doLoadValue();
        }
    }

    private void myLoadValue(BLonNetwork lon, Context cx) {
        this.registerFolder((BComponent)lon);
        BLonDeviceFolder[] fds = (BLonDeviceFolder[])lon.getChildren(BLonDeviceFolder.class);
        for (int i = 0; i < fds.length; ++i) {
            this.registerFolder((BComponent)fds[i]);
        }
        this.registerForComponentEvents((BComponent)lon.netmgmt(), 1);
    }

    private void registerFolder(BComponent c) {
        this.registerForComponentEvents(c, 1);
        BLonDevice[] devices = (BLonDevice[])c.getChildren(BLonDevice.class);
        BComponent[] a = new BComponent[devices.length];
        int n = 0;
        for (int i = 0; i < devices.length; ++i) {
            a[n++] = devices[i].getDeviceData();
        }
        this.registerForComponentEvents(a, 0);
    }

    public void doLoadValue(BObject value, Context context) {
        this.context = context;
        this.lonNetwork = (BLonNetwork)value;
        this.myLoadValue(this.lonNetwork, context);
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        this.textArea = new BTextEditor();
        this.textArea.setEditable(false);
        BGridPane controlPane = new BGridPane(2);
        controlPane.setColumnAlign(BHalign.fill);
        controlPane.add("devLabel", (BValue)new BLabel("Device:  "));
        this.deviceFE = new BLonDeviceFE(this.lonNetwork);
        controlPane.add("dev", (BValue)this.deviceFE);
        this.linkTo((BComponent)this.deviceFE, (Slot)BLonDeviceFE.setModified, (Slot)updateCommands);
        controlPane.add("cmdLabel", (BValue)new BLabel("Command:"));
        BGridPane cmdPane = new BGridPane(2);
        this.command = new BTextDropDown();
        cmdPane.add("cmd", (BValue)this.command);
        BGridPane auxCmdPane = new BGridPane(1);
        cmdPane.add("aux", (BValue)auxCmdPane);
        this.subCmdPane = new BGridPane(2);
        this.subCmdPane.add("subCmdLabel", (BValue)new BLabel("SubCommand:"));
        this.subCommand = new BTextDropDown();
        this.subCmdPane.add("subCmd", (BValue)this.subCommand);
        auxCmdPane.add("scp", (BValue)this.subCmdPane);
        this.otherFile = new BTextField("", 5);
        this.otherFileLabel = new BLabel("OtherFile:");
        this.subCmdPane.add("otherFileLabel", (BValue)this.otherFileLabel);
        this.subCmdPane.add("otherFile", (BValue)this.otherFile);
        this.setOtherFileVisible(false);
        cmdPane.setColumnGap(20.0);
        controlPane.add("cp", (BValue)cmdPane);
        this.command.getEditor().setEditable(false);
        this.subCommand.getEditor().setEditable(false);
        this.linkTo((BComponent)this.command, (Slot)BTextDropDown.listActionPerformed, (Slot)updateSubCommands);
        this.linkTo((BComponent)this.subCommand, (Slot)BTextDropDown.listActionPerformed, (Slot)updateAux);
        this.memoryPane = new BGridPane(4);
        this.memAddress = new BTextField("", 10);
        this.memLength = new BTextField("", 10);
        this.memoryPane.add("lenLabel", (BValue)new BLabel("address:"));
        this.memoryPane.add("address", (BValue)this.memAddress);
        this.memoryPane.add("idLabel", (BValue)new BLabel(" len:"));
        this.memoryPane.add("len", (BValue)this.memLength);
        this.memoryPane.setVisible(false);
        auxCmdPane.add("memPane", (BValue)this.memoryPane);
        BGridPane buttonPane = new BGridPane(3);
        this.executeCmd = new Command((BWidget)this.getWbShell(), BLonUtilitiesManager.lexicon.module, "commands.execute"){

            public CommandArtifact doInvoke() throws Exception {
                BLonUtilitiesManager.this.sendCommands();
                return null;
            }
        };
        this.executeButton = new BButton(this.executeCmd);
        buttonPane.add("ex", (BValue)this.executeButton);
        BGridPane bottomPane = new BGridPane(2);
        bottomPane.add("cp", (BValue)controlPane);
        bottomPane.add("bp", (BValue)buttonPane);
        bottomPane.setColumnGap(20.0);
        BBorderPane textPane = new BBorderPane((BWidget)this.textArea, BBorder.solid, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        textPane.setFill(Theme.widget().getWindowBackground());
        textPane = new BBorderPane((BWidget)textPane, BBorder.inset, BInsets.DEFAULT);
        BEdgePane mainPane = new BEdgePane();
        mainPane.setTop((BWidget)jobPane);
        mainPane.setCenter((BWidget)new BTitlePane("Results", (BWidget)new BScrollPane((BWidget)textPane)));
        mainPane.setBottom((BWidget)bottomPane);
        this.setContent((BWidget)mainPane);
        this.deviceFE.doLoadValue();
        this.routerSelected = false;
        this.discoveredSelected = false;
        this.loadCommands();
        this.loadSubCommands(BUtilCommandEnum.status);
    }

    public void doUpdateAux() {
        BUtilCommandEnum cmd = (BUtilCommandEnum)this.subCommand.getList().getSelectedItem();
        this.setOtherFileVisible(cmd == BUtilCommandEnum.other);
    }

    private void setOtherFileVisible(boolean v) {
        this.otherFile.setVisible(v);
        this.otherFileLabel.setVisible(v);
    }

    public void doUpdateSubCommands() {
        BUtilCommandEnum cmd = (BUtilCommandEnum)this.command.getList().getSelectedItem();
        this.loadSubCommands(cmd);
    }

    public void doUpdateCommands() {
        BComplex entry = this.deviceFE.getSelectedEntry();
        if (entry == null) {
            return;
        }
        boolean isRouterSelected = entry.getType().is(BLonRouter.TYPE) || entry.getType().is(BRouterEntry.TYPE);
        boolean isDiscoveredSelected = entry.getType().is(BDeviceEntry.TYPE) || entry.getType().is(BRouterEntry.TYPE);
        boolean isLocalSelected = entry.getType().is(BLocalLonDevice.TYPE);
        if (isRouterSelected != this.routerSelected || isDiscoveredSelected != this.discoveredSelected || isLocalSelected != this.localSelected) {
            this.routerSelected = isRouterSelected;
            this.discoveredSelected = isDiscoveredSelected;
            this.localSelected = isLocalSelected;
            this.loadCommands();
            this.doUpdateSubCommands();
        }
    }

    private void loadCommands() {
        BList list = this.command.getList();
        list.removeAllItems();
        list.addItem((Object)BUtilCommandEnum.status);
        list.addItem((Object)BUtilCommandEnum.dataStructs);
        if (!this.routerSelected && !this.discoveredSelected) {
            list.addItem((Object)BUtilCommandEnum.file);
        }
        list.addItem((Object)BUtilCommandEnum.identify);
        list.addItem((Object)BUtilCommandEnum.reports);
        list.addItem((Object)BUtilCommandEnum.readMem);
        list.addItem((Object)BUtilCommandEnum.find);
        if (list.getItemCount() > 0) {
            list.setSelectedIndex(0);
            this.command.setText(list.getItem(0).toString());
        } else {
            this.command.setText("");
        }
    }

    private void loadSubCommands(BUtilCommandEnum cmd) {
        BList list = this.subCommand.getList();
        list.removeAllItems();
        boolean visibleMemPane = false;
        switch (cmd.getOrdinal()) {
            case 1: 
            case 5: 
            case 8: {
                break;
            }
            case 0: {
                list.addItem((Object)BUtilCommandEnum.display);
                list.addItem((Object)BUtilCommandEnum.clear);
                list.addItem((Object)BUtilCommandEnum.setUnconfigured);
                list.addItem((Object)BUtilCommandEnum.setOnline);
                list.addItem((Object)BUtilCommandEnum.reset);
                if (!this.allowCalcChecksum() || this.localSelected) break;
                list.addItem((Object)BUtilCommandEnum.recalcChecksum);
                break;
            }
            case 3: {
                list.addItem((Object)BUtilCommandEnum.fileDirectory);
                list.addItem((Object)BUtilCommandEnum.configTemplateFile);
                list.addItem((Object)BUtilCommandEnum.configValueFile);
                list.addItem((Object)BUtilCommandEnum.other);
                break;
            }
            case 2: {
                list.addItem((Object)BUtilCommandEnum.wink);
                list.addItem((Object)BUtilCommandEnum.servicePin);
                list.addItem((Object)BUtilCommandEnum.clearServicePin);
                break;
            }
            case 4: {
                list.addItem((Object)BUtilCommandEnum.addressTable);
                list.addItem((Object)BUtilCommandEnum.domainTable);
                list.addItem((Object)BUtilCommandEnum.readOnlyStructure);
                list.addItem((Object)BUtilCommandEnum.configStructure);
                if (!this.localSelected && !this.routerSelected) {
                    list.addItem((Object)BUtilCommandEnum.nvAliasTable);
                }
                if (!this.localSelected && !this.routerSelected) {
                    list.addItem((Object)BUtilCommandEnum.nvConfig);
                }
                if (!this.localSelected && !this.routerSelected) {
                    list.addItem((Object)BUtilCommandEnum.nvValue);
                }
                if (!this.localSelected) {
                    list.addItem((Object)BUtilCommandEnum.selfDocumentation);
                }
                if (!this.routerSelected) break;
                list.addItem((Object)BUtilCommandEnum.routeTables);
                break;
            }
            case 6: {
                list.addItem((Object)BUtilCommandEnum.netmgmtSummary);
                list.addItem((Object)BUtilCommandEnum.programIds);
                list.addItem((Object)BUtilCommandEnum.transmitErrors);
                list.addItem((Object)BUtilCommandEnum.transmitErrorsNoClear);
                if (!this.discoveredSelected) {
                    list.addItem((Object)BUtilCommandEnum.verify);
                }
                list.addItem((Object)BUtilCommandEnum.verifyChannels);
                list.addItem((Object)BUtilCommandEnum.networkSummary);
                break;
            }
            case 7: {
                visibleMemPane = true;
            }
        }
        if (list.getItemCount() > 0) {
            list.setSelectedIndex(0);
            this.subCommand.setText(list.getItem(0).toString());
        } else {
            this.subCommand.setText("");
        }
        this.subCmdPane.setVisible(!visibleMemPane);
        this.memoryPane.setVisible(visibleMemPane);
        this.setOtherFileVisible(false);
    }

    private boolean allowCalcChecksum() {
        BFacets f = this.lonNetwork.getParent().getSlotFacets((Slot)this.lonNetwork.getPropertyInParent());
        return f.getb("AllowCalcChecksum", false);
    }

    protected void sendCommands() throws Exception {
        BUtilitiesCommand utilCmd;
        Action a;
        BUtilCommandEnum subCmd;
        BUtilCommandEnum cmd = (BUtilCommandEnum)this.command.getList().getSelectedItem();
        try {
            subCmd = (BUtilCommandEnum)this.subCommand.getList().getSelectedItem();
        }
        catch (Exception e) {
            subCmd = null;
        }
        if (subCmd != null) {
            cmd = subCmd;
        }
        if ((a = this.lonNetwork.getAction("executeCommand")) == null) {
            return;
        }
        this.textArea.setText(BAbsTime.now().toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)) + "\n\n");
        this.executeButton.setEnabled(false);
        BWbShell shell = this.getWbShell();
        BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)("service:" + BLonNetwork.TYPE.toString()));
        this.lonNetwork.loadSlots();
        BComplex select = this.deviceFE.getSelectedEntry();
        if (select.getType().is(BDeviceEntry.TYPE)) {
            BDeviceEntry entry = (BDeviceEntry)select;
            BSubnetNode sn = BSubnetNode.make((int)entry.getSubnet(), (int)entry.getNode());
            utilCmd = new BUtilitiesCommand(cmd, true, sn, entry.getNeuronId(), entry.getUtilName());
        } else if (select.getType().is(BRouterEntry.TYPE)) {
            BRouterEntry entry = (BRouterEntry)select;
            utilCmd = new BUtilitiesCommand(cmd, false, entry.getNearAddress(), entry.getNeuronId(), entry.getUtilName());
        } else {
            BComponent dev = (BComponent)select;
            boolean isLonDevice = dev.getType().is(BLonDevice.TYPE);
            dev.loadSlots();
            BDeviceData dd = isLonDevice ? ((BLonDevice)dev).getDeviceData() : ((BLonRouter)dev).getNearDeviceData();
            dd.loadSlots();
            utilCmd = new BUtilitiesCommand(cmd, isLonDevice, dd.getSubnetNodeId(), dd.getNeuronId(), dev.getName());
            try {
                utilCmd.setMemAddr(Integer.parseInt(this.memAddress.getText(), 16));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                utilCmd.setCount(Integer.parseInt(this.memLength.getText(), 16));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                utilCmd.setFileNum(Integer.parseInt(this.otherFile.getText(), 16));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ord = (BOrd)this.lonNetwork.invoke(a, (BValue)utilCmd);
        this.setJob(ord);
    }

    private void setJob(BOrd jobOrd) {
        try {
            BComponent base = (BComponent)this.getCurrentValue();
            base.getComponentSpace().sync();
            BJob job = (BJob)jobOrd.get((BObject)base);
            this.registerForComponentEvents((BComponent)job);
            this.jobBar.load(job);
            this.getData((BUtilCmdJob)job);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void getData(BUtilCmdJob job) {
        RunnableCommand r = new RunnableCommand(job){

            public void run() {
                BLonUtilitiesManager.this.receiveData((BUtilCmdJob)this.arg1);
            }
        };
        Thread t = new Thread((Runnable)r, "lon.utilManager");
        t.start();
    }

    void receiveData(BUtilCmdJob job) {
        BString bstr;
        while ((bstr = job.getText()) != null) {
            this.textArea.setText(this.textArea.getText() + bstr.toString());
            NmUtil.wait((int)100);
        }
        this.executeButton.setEnabled(true);
    }
}

