/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BDomainIdFE
extends BWbFieldEditor {
    public static final Action updateIdField = BDomainIdFE.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDomainIdFE.class);
    private BListDropDown domLen = new BListDropDown();
    private BTextField domainId = new BTextField("", 19);
    private BLabel domainIdLabel;
    private static Lexicon lex = Lexicon.make(BDomainIdFE.class);
    private static final String[] szLens = new String[]{"0", "1", "3", "6"};

    public void updateIdField() {
        this.invoke(updateIdField, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDomainIdFE() {
        BGridPane pane = new BGridPane(5);
        pane.add("lenLabel", (BValue)new BLabel(lex.getText("DomainIdFE.length")));
        pane.add("len", (BValue)this.domLen);
        pane.add("space", (BValue)new BLabel("  "));
        this.domainIdLabel = new BLabel(lex.getText("DomainIdFE.id"));
        pane.add("idLabel", (BValue)this.domainIdLabel);
        pane.add("id", (BValue)this.domainId);
        this.setContent((BWidget)pane);
        BList list = this.domLen.getList();
        for (int i = 0; i < szLens.length; ++i) {
            list.addItem((Object)szLens[i]);
        }
        this.linkTo("lk0", (BComponent)this.domLen, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.domLen, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk4", (BComponent)this.domLen, (Slot)BListDropDown.listActionPerformed, (Slot)updateIdField);
        this.linkTo("lk2", (BComponent)this.domainId, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.domainId, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.domLen.setEnabled(!readonly);
        this.domainId.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BDomainId domId = (BDomainId)value;
        int len = domId.getLength();
        this.domLen.setSelectedItem((Object)this.getLengthIndex(len));
        this.domainId.setText(LonByteArrayUtil.toString((byte[])domId.getDomainId()));
        this.domainId.setVisibleColumns(len * 3);
        this.domainIdLabel.setVisible(domId.getLength() != 0);
        this.domainId.setVisible(domId.getLength() != 0);
    }

    public void doUpdateIdField(Context cx) {
        int len = Integer.decode((String)this.domLen.getSelectedItem());
        byte[] id = LonByteArrayUtil.getBytes((String)"         ", (int)len);
        BDomainId domId = BDomainId.make((int)len, (byte[])id);
        this.doLoadValue((BObject)domId, null);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int len = Integer.decode((String)this.domLen.getSelectedItem());
        byte[] id = LonByteArrayUtil.getBytes((String)this.domainId.getText(), (int)len);
        BDomainId domId = BDomainId.make((int)len, (byte[])id);
        this.doLoadValue((BObject)domId, null);
        return domId;
    }

    private String getLengthIndex(int len) {
        switch (len) {
            case 0: {
                return szLens[0];
            }
            case 1: {
                return szLens[1];
            }
            case 3: {
                return szLens[2];
            }
            case 6: {
                return szLens[3];
            }
        }
        return szLens[0];
    }
}

