/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import java.io.IOException;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;

public class BCommReplDialog
extends BDialog {
    public static final Action buttonPressed = BCommReplDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BCommReplDialog.class);
    BTextDropDown idSelect;
    BButton applyButton;
    BButton cancelButton;
    BButton servicePinButton;
    int result = 0;
    public static int SERVICE_PIN = 12;

    public void buttonPressed(BWidgetEvent event) {
        this.invoke(buttonPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCommReplDialog() {
    }

    public BCommReplDialog(BWidget parent, String title, BNeuronId[] neuronIds) {
        super(parent, title, true);
        this.applyButton = new BButton("Apply");
        this.linkTo((BComponent)this.applyButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.cancelButton = new BButton("Cancel");
        this.linkTo((BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.servicePinButton = new BButton("Service Pin");
        this.linkTo((BComponent)this.servicePinButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.idSelect = new BTextDropDown();
        BList list = this.idSelect.getList();
        if (neuronIds.length == 0) {
            list.getModel().addItem((Object)BNeuronId.DEFAULT.toString());
        } else {
            for (int i = 0; i < neuronIds.length; ++i) {
                list.getModel().addItem((Object)neuronIds[i].toString());
            }
        }
        list.setSelectedIndex(0);
        this.idSelect.setText(list.getSelectedItem().toString());
        BFlowPane center = new BFlowPane();
        center.setAlign(BHalign.center);
        BFlowPane bottom = new BFlowPane();
        bottom.setAlign(BHalign.center);
        center.add("label", (BValue)new BLabel("Neuron ID"));
        center.add("comboBox", (BValue)this.idSelect);
        bottom.add("applyButton", (BValue)this.applyButton);
        bottom.add("cancelButton", (BValue)this.cancelButton);
        bottom.add("servicePinButton", (BValue)this.servicePinButton);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)center));
        pane.setBottom((BWidget)new BBorderPane((BWidget)bottom));
        this.setContent((BWidget)pane);
    }

    public BNeuronId getSelectedNeuronId() {
        String id = this.idSelect.getText();
        try {
            return (BNeuronId)BNeuronId.DEFAULT.decodeFromString(id);
        }
        catch (IOException e) {
            return BNeuronId.DEFAULT;
        }
    }

    public int getResult() {
        return this.result;
    }

    public void doButtonPressed(BWidgetEvent event) {
        this.close();
        if (event.getWidget().equals((Object)this.servicePinButton)) {
            this.result = SERVICE_PIN;
        } else if (event.getWidget().equals((Object)this.applyButton)) {
            this.result = 1;
        } else if (event.getWidget().equals((Object)this.cancelButton)) {
            this.result = 2;
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.result = 2;
        this.close();
    }
}

