/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.nd.history.BNiagaraHistoryImport;
import com.tridium.nv.NiagaraVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.history.BArchiveFolder;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BHistoryImportTag
extends BNiagaraExportTag {
    public static final Property stationSlotPath = BHistoryImportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:histories"), (BFacets)BHistoryImportTag.makeStationSlotPathFacets());
    public static final Property historyImportName = BHistoryImportTag.newProperty((int)0, (BValue)BFormat.make((String)"%defaultHistoryImportName%"), null);
    public static final Property executionTime = BHistoryImportTag.newProperty((int)0, (BValue)BDailyTriggerMode.make(), null);
    public static final Property configOverrides = BHistoryImportTag.newProperty((int)0, (BValue)new BComponent(), null);
    public static final Property onDemandPollEnabled = BHistoryImportTag.newProperty((int)0, (boolean)true, null);
    public static final Property onDemandPollFrequency = BHistoryImportTag.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property useCategoryMask = BHistoryImportTag.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BHistoryImportTag.class);
    private String cachedHistoryImportName = "";

    public BFormat getHistoryImportName() {
        return (BFormat)this.get(historyImportName);
    }

    public void setHistoryImportName(BFormat v) {
        this.set(historyImportName, (BValue)v, null);
    }

    public BTriggerMode getExecutionTime() {
        return (BTriggerMode)this.get(executionTime);
    }

    public void setExecutionTime(BTriggerMode v) {
        this.set(executionTime, (BValue)v, null);
    }

    public BComponent getConfigOverrides() {
        return (BComponent)this.get(configOverrides);
    }

    public void setConfigOverrides(BComponent v) {
        this.set(configOverrides, (BValue)v, null);
    }

    public boolean getOnDemandPollEnabled() {
        return this.getBoolean(onDemandPollEnabled);
    }

    public void setOnDemandPollEnabled(boolean v) {
        this.setBoolean(onDemandPollEnabled, v, null);
    }

    public BPollFrequency getOnDemandPollFrequency() {
        return (BPollFrequency)this.get(onDemandPollFrequency);
    }

    public void setOnDemandPollFrequency(BPollFrequency v) {
        this.set(onDemandPollFrequency, (BValue)v, null);
    }

    public boolean getUseCategoryMask() {
        return this.getBoolean(useCategoryMask);
    }

    public void setUseCategoryMask(boolean v) {
        this.setBoolean(useCategoryMask, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BComponent overrides = this.getConfigOverrides();
        if (overrides.get("capacity") == null) {
            overrides.add("capacity", (BValue)BCapacity.UNLIMITED);
        }
        if (overrides.get("fullPolicy") == null) {
            overrides.add("fullPolicy", BHistoryConfig.fullPolicy.getDefaultValue());
        }
    }

    @Override
    protected Type getFolderType() {
        return BArchiveFolder.TYPE;
    }

    @Override
    protected void doJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        BHistoryService srv = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = srv.getDatabase();
        BComponent comp = (BComponent)this.getParent();
        sub.subscribe(comp);
        BHistoryConfig[] historyConfigs = comp instanceof BHistoryConfig ? new BHistoryConfig[]{(BHistoryConfig)comp} : (BHistoryConfig[])comp.getChildren(BHistoryConfig.class);
        sub.subscribe((BComponent[])historyConfigs, 0, null);
        if (historyConfigs.length <= 0) {
            throw new ExportTagException("histImpExpTag.noHistoryConfigsFound");
        }
        BCategoryService categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        for (BHistoryConfig historyCfg : historyConfigs) {
            BHistoryId id = historyCfg.getId();
            if (!id.isValid()) {
                job.log().failed(this.getType().getModule().getModuleName(), "histImpExpTag.invalidHistoryConfig", historyCfg.toPathString());
                continue;
            }
            if (id.getDeviceName().equals(station.getStationName())) {
                id = BHistoryId.make((String)"^", (String)id.getHistoryName());
                this.cachedHistoryImportName = "Remote_" + id.getHistoryName();
            } else {
                this.cachedHistoryImportName = id.getDeviceName() + "_" + id.getHistoryName();
            }
            String importName = this.getHistoryImportName().format((Object)this);
            if (!SlotPath.isValidName((String)importName)) {
                importName = SlotPath.escape((String)importName);
            }
            BNiagaraHistoryImport imp = (BNiagaraHistoryImport)NiagaraVirtualUtil.findInstance((BComponent)this.getTargetParent(), (String)importName, (Type)BNiagaraHistoryImport.TYPE);
            imp.set(BNiagaraHistoryImport.historyId, (BValue)id, cx);
            sub.subscribe(this.getConfigOverrides());
            this.configImport(imp, cx);
            this.addTarget(importName, (BComplex)imp, cx);
            BHistoryConfig updatedConfig = imp.makeLocalConfig(historyCfg);
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                if (conn.getHistory(historyCfg.getId()) == null) {
                    conn.createHistory(updatedConfig);
                } else {
                    conn.reconfigureHistory(updatedConfig);
                }
            }
            if (this.getUseCategoryMask()) {
                categoryService.setOrdMap(categoryService.getOrdMap().setCategoryMask(BOrd.make((String)("history:" + updatedConfig.getId())), mask));
            }
            imp.invoke(BNiagaraHistoryImport.execute, null, cx);
        }
    }

    protected final void configImport(BNiagaraHistoryImport imp, Context cx) {
        imp.getExecutionTime().set(BTimeTrigger.triggerMode, (BValue)this.getExecutionTime(), cx);
        imp.setBoolean(BNiagaraHistoryImport.onDemandPollEnabled, this.getOnDemandPollEnabled(), cx);
        imp.set(BNiagaraHistoryImport.onDemandPollFrequency, (BValue)this.getOnDemandPollFrequency(), cx);
        BComponent impOverrides = imp.getConfigOverrides();
        BComponent overrides = this.getConfigOverrides();
        for (Property prop : overrides.getPropertiesArray()) {
            Property p = impOverrides.getProperty(prop.getName());
            if (p == null) {
                impOverrides.add(prop.getName(), overrides.get(prop).newCopy(true), cx);
                continue;
            }
            impOverrides.set(p, overrides.get(prop).newCopy(true), cx);
        }
    }

    public String getDefaultHistoryImportName() {
        return this.cachedHistoryImportName;
    }
}

