/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags;

import com.tridium.data.BDataTable;
import com.tridium.exporttags.util.ExportTagUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BJoinJob
extends BJob
implements Runnable {
    public static final Property currentProgress = BJoinJob.newProperty((int)5, (String)"", null);
    public static final Property logLimit = BJoinJob.newProperty((int)1, (int)600, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-1), (BFacets)BFacets.make((String)"max", (int)10000)));
    public static final Type TYPE = Sys.loadType(BJoinJob.class);
    private volatile Context cx;

    public String getCurrentProgress() {
        return this.getString(currentProgress);
    }

    public void setCurrentProgress(String v) {
        this.setString(currentProgress, v, null);
    }

    public int getLogLimit() {
        return this.getInt(logLimit);
    }

    public void setLogLimit(int v) {
        this.setInt(logLimit, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCancel(Context cx) throws Exception {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    public void doRun(Context cx) throws Exception {
        this.cx = cx;
        this.postAsync();
    }

    @Override
    public final void run() {
        block4: {
            try {
                this.log().setLimit(this.getLogLimit());
                this.run(this.cx);
                if (this.getJobState() == BJobState.canceling) {
                    this.canceled();
                } else {
                    this.success();
                }
            }
            catch (Throwable e) {
                this.failed(e);
                if (!ExportTagUtil.log.isTraceOn()) break block4;
                ExportTagUtil.log.trace("Join Job Failed", e);
            }
        }
    }

    protected abstract void postAsync();

    public abstract void run(Context var1) throws Exception;

    public JobLog readJoinJobLog() {
        JobLog log = new JobLog();
        try {
            return BJoinJob.createJobLog((BITable)BJoinJob.createExportJobToTableOrd(this.getHandleOrd()).get((BObject)this));
        }
        catch (Exception e) {
            e.printStackTrace();
            return log;
        }
    }

    static BOrd createExportJobToTableOrd(BOrd jobOrd) {
        return BOrd.make((String)(jobOrd + "|bql:exportTags:JoinJob.exportJobLogToTable()"));
    }

    static JobLog createJobLog(BITable<?> table) throws Exception {
        JobLog log = new JobLog();
        if (table.getColumns().size() > 0) {
            Column col = table.getColumns().get(0);
            try (TableCursor c = table.cursor();){
                while (c.next()) {
                    log.add(JobLogItem.decode((String)c.cell(col).toString()));
                }
            }
        }
        return log;
    }

    public static BITable<?> exportJobLogToTable(BObject job) {
        JobLog log = ((BJob)job).log();
        BDataTable table = new BDataTable();
        table.addColumn("log", BString.TYPE, 0, BFacets.NULL);
        table.startRows();
        for (JobLogItem item : log.getItems()) {
            table.startRow();
            table.set(item.encode(), BFacets.NULL);
            table.endRow();
        }
        table.endRows();
        return table;
    }
}

