/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.batch;

import com.tridium.program.batch.BBatchRoutine;
import java.io.PrintWriter;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="slotName", type="String", defaultValue=""), @NiagaraProperty(name="slotValue", type="BValue", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="setIfExists", type="boolean", defaultValue="true")})
public class BAddSlotBatchRoutine
extends BBatchRoutine {
    public static final Property slotName = BAddSlotBatchRoutine.newProperty((int)0, (String)"", null);
    public static final Property slotValue = BAddSlotBatchRoutine.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property setIfExists = BAddSlotBatchRoutine.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BAddSlotBatchRoutine.class);

    public String getSlotName() {
        return this.getString(slotName);
    }

    public void setSlotName(String v) {
        this.setString(slotName, v, null);
    }

    public BValue getSlotValue() {
        return this.get(slotValue);
    }

    public void setSlotValue(BValue v) {
        this.set(slotValue, v, null);
    }

    public boolean getSetIfExists() {
        return this.getBoolean(setIfExists);
    }

    public void setSetIfExists(boolean v) {
        this.setBoolean(setIfExists, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BAddSlotBatchRoutine make(String name, BValue value, boolean setIfExists) {
        BAddSlotBatchRoutine routine = new BAddSlotBatchRoutine();
        routine.setSlotName(name);
        routine.setSlotValue(value);
        routine.setSetIfExists(setIfExists);
        return routine;
    }

    @Override
    public void run(BComponent component, PrintWriter log, Lexicon lex, Context cx) {
        String name = this.getSlotName();
        BValue value = this.getSlotValue().newCopy(true);
        boolean setIfExists = this.getSetIfExists();
        if (component.getProperty(name) != null && setIfExists) {
            if (Flags.isReadonly((BComplex)component, (Slot)component.getProperty(name))) {
                log.println(lex.getText("batchEditor.log.set") + ' ' + lex.getText("batchEditor.log.skippingReadonly") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name));
                return;
            }
            if (component.get(name).getType() != value.getType()) {
                return;
            }
            if (value instanceof BFacets) {
                value = BAddSlotBatchRoutine.mergeFacets((BFacets)component.get(name), (BFacets)value);
            }
            component.set(name, value);
            log.println(lex.getText("batchEditor.log.set") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name) + " -> " + value);
        } else if (component.getProperty(name) == null) {
            component.add(name, value, cx);
            log.println(lex.getText("batchEditor.log.add") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name) + " -> " + value);
        }
    }
}

