/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import com.tridium.program.BProgramAction;
import com.tridium.program.BProgramCode;
import com.tridium.program.ProgramBase;
import com.tridium.sys.resource.ResourceReport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.file.BajaFileUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BProgram
extends BComponent {
    public static final Property code = BProgram.newProperty((int)0, (BValue)new BProgramCode(), null);
    public static final Action execute = BProgram.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BProgram.class);
    private static final BIcon icon = BIcon.std((String)"script.png");
    static final Logger log = Logger.getLogger("sys.program");
    ProgramBase impl = new ProgramBase();

    public BProgramCode getCode() {
        return (BProgramCode)this.get(code);
    }

    public void setCode(BProgramCode v) {
        this.set(code, (BValue)v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.loadImpl();
    }

    public void stopped() {
        this.unloadImpl();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop == code) {
            this.loadImpl();
        } else if (Flags.isExecuteOnChange((BComplex)this, (Slot)prop)) {
            this.execute();
        }
    }

    public void doExecute() {
        try {
            this.impl.onExecute();
        }
        catch (Throwable e) {
            this.error("onExecute", e);
        }
    }

    private void loadImpl() {
        this.unloadImpl();
        this.impl = this.getCode().newProgramInstance();
        this.impl.program = this;
        this.updateActionParameters(this.impl);
        try {
            this.impl.onStart();
        }
        catch (Throwable e) {
            this.error("onStart", e);
        }
    }

    public final void updateActionParameters() {
        this.impl = this.getCode().newProgramInstance();
        this.impl.program = this;
        this.updateActionParameters(this.impl);
    }

    private void updateActionParameters(ProgramBase impl) {
        SlotCursor c = this.getProperties();
        while (c.nextObject()) {
            BValue kid = c.get();
            if (!(kid instanceof BProgramAction)) continue;
            ((BProgramAction)kid).updateParameter(impl);
        }
    }

    private void unloadImpl() {
        try {
            this.impl.onStop();
        }
        catch (Throwable e) {
            this.error("onStop", e);
        }
        this.impl = new ProgramBase();
    }

    public void error(String method, Throwable e) {
        log.log(Level.SEVERE, "\"" + this.toPathString() + "." + method + "\"", e);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 21: {
                ((ResourceReport)a).add("program", 3000);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("workbench:PropertySheet");
        return agents;
    }

    public BIcon getIcon() {
        return icon;
    }

    public static boolean isSpecialModule(String name) {
        return BajaFileUtil.isSpecialModule((String)name);
    }
}

