/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.points;

import com.vykon.vykonProUtil.points.BAbsStringOverride;
import javax.baja.control.BStringPoint;
import javax.baja.control.util.BStringOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAbsStringWritableCommand
extends BComponent {
    public static final Property pointOrd = BAbsStringWritableCommand.newProperty((int)64, (BValue)BOrd.NULL, null);
    public static final Property defaultTime = BAbsStringWritableCommand.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property facets = BAbsStringWritableCommand.newProperty((int)7, (BValue)BFacets.NULL, null);
    public static final Property fallback = BAbsStringWritableCommand.newProperty((int)7, (String)"", null);
    public static final Property out = BAbsStringWritableCommand.newProperty((int)7, (String)"", null);
    public static final Action emergencyOverride = BAbsStringWritableCommand.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action emergencyAuto = BAbsStringWritableCommand.newAction((int)0, null);
    public static final Action override = BAbsStringWritableCommand.newAction((int)256, (BValue)new BStringOverride(), null);
    public static final Action auto = BAbsStringWritableCommand.newAction((int)256, null);
    public static final Action absOverride = BAbsStringWritableCommand.newAction((int)256, (BValue)new BAbsStringOverride(), null);
    public static final Action set = BAbsStringWritableCommand.newAction((int)256, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAbsStringWritableCommand.class);
    private static final BIcon icon = BIcon.std((String)"control/stringPoint.png");
    BStringPoint slave = null;
    PointSubscriber pointSub = null;

    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    public void setPointOrd(BOrd v) {
        this.set(pointOrd, (BValue)v, null);
    }

    public BRelTime getDefaultTime() {
        return (BRelTime)this.get(defaultTime);
    }

    public void setDefaultTime(BRelTime v) {
        this.set(defaultTime, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public String getFallback() {
        return this.getString(fallback);
    }

    public void setFallback(String v) {
        this.setString(fallback, v, null);
    }

    public String getOut() {
        return this.getString(out);
    }

    public void setOut(String v) {
        this.setString(out, v, null);
    }

    public void emergencyOverride(BString arg) {
        this.invoke(emergencyOverride, (BValue)arg, null);
    }

    public void emergencyAuto() {
        this.invoke(emergencyAuto, null, null);
    }

    public void override(BStringOverride arg) {
        this.invoke(override, (BValue)arg, null);
    }

    public void auto() {
        this.invoke(auto, null, null);
    }

    public void absOverride(BAbsStringOverride arg) {
        this.invoke(absOverride, (BValue)arg, null);
    }

    public void set(BString arg) {
        this.invoke(set, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() {
        this.pointSub.unsubscribeAll();
        this.pointSub = null;
    }

    public void stationStarted() {
        this.initPoint();
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == pointOrd) {
            this.initPoint();
        }
    }

    private void initPoint() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getPointOrd() != BOrd.NULL) {
            try {
                this.slave = (BStringPoint)this.getPointOrd().resolve((BObject)this).get();
                if (this.slave.get("fallback") != null) {
                    String val = ((BStatusString)this.slave.get("fallback")).getValue();
                    this.setFallback(val);
                }
                this.setOut(this.slave.getOut().getValue());
                if (this.slave.get("facets") != null) {
                    this.setFacets((BFacets)this.slave.get("facets"));
                }
                this.pointSub = new PointSubscriber();
                this.pointSub.subscribe((BComponent)this.slave);
            }
            catch (Exception e) {
                System.out.println(this.getSlotPath() + " couldn't resolve point ord");
                System.out.println(e);
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == override || slot == emergencyOverride || slot == set || slot == absOverride) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doEmergencyOverride(BString v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyOverride").asAction(), (BValue)v, cx);
    }

    public void doEmergencyAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyAuto").asAction(), null, cx);
    }

    public void doOverride(BStringOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("override").asAction(), (BValue)v, cx);
    }

    public void doAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("auto").asAction(), null, cx);
    }

    public void doAbsOverride(BAbsStringOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        BAbsTime current = Clock.time();
        BAbsTime end = BAbsTime.NULL;
        String val = "";
        if (v != null && v.get("expireTime") != null) {
            end = v.getExpireTime();
        }
        if (v != null && v.get("value") != null) {
            val = v.getValue();
        }
        long timeDiff = 0L;
        if (current != BAbsTime.NULL && end != BAbsTime.NULL) {
            timeDiff = v.getExpireTime().getMillis() - current.getMillis();
        }
        BRelTime dur = null;
        dur = timeDiff <= 0L ? BRelTime.make((long)0L) : BRelTime.make((long)timeDiff);
        BStringOverride o = new BStringOverride(dur, val);
        this.slave.invoke(this.slave.getAction("override").asAction(), (BValue)o, null);
    }

    public void doSet(BString v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("set").asAction(), (BValue)v, cx);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == set) {
            return BString.make((String)this.getFallback());
        }
        if (action == override) {
            BStringOverride o = new BStringOverride(this.getOut());
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        if (action == emergencyOverride) {
            return BString.make((String)this.getOut());
        }
        if (action == absOverride) {
            BAbsTime end = Clock.time().add(this.getDefaultTime());
            BAbsStringOverride o = new BAbsStringOverride(end, this.getOut());
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        return super.getActionParameterDefault(action);
    }

    BRelTime getMaxOverrideDuration() {
        BRelTime maxDuration = BRelTime.DEFAULT;
        try {
            BFacets facets = this.getFacets();
            BObject obj = facets.get("maxOverrideDuration");
            if (obj instanceof BRelTime) {
                maxDuration = (BRelTime)obj;
            } else {
                BStation station = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)this);
                if (!station.isRunning()) {
                    station.loadSlots();
                    station.lease();
                }
                facets = (BFacets)station.get("sysInfo");
                maxDuration = (BRelTime)facets.get("maxOverrideDuration", (BObject)maxDuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxDuration;
    }

    public BIcon getIcon() {
        return icon;
    }

    private class PointSubscriber
    extends Subscriber {
        private PointSubscriber() {
        }

        public void event(BComponentEvent event) {
            int id = event.getId();
            if (id == 0) {
                if (event.getSlotName().equals("fallback")) {
                    String val = ((BStatusString)BAbsStringWritableCommand.this.slave.get("fallback")).getValue();
                    BAbsStringWritableCommand.this.setFallback(val);
                }
                if (event.getSlotName().equals("out")) {
                    BAbsStringWritableCommand.this.setOut(BAbsStringWritableCommand.this.slave.getOut().getValue());
                }
                if (event.getSlotName().equals("facets")) {
                    BAbsStringWritableCommand.this.setFacets(BAbsStringWritableCommand.this.slave.getFacets());
                }
            }
        }
    }
}

