/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.sql;

import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import javax.baja.io.BIContextEncodable;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class PropertyValue {
    public final Property property;
    public final BValue value;

    public static PropertyValue[] make(BComplex cmplx) {
        Array arr = new Array(PropertyValue.class);
        Property[] props = cmplx.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue val = cmplx.get(props[i]);
            if (val.equals((Object)props[i].getDefaultValue())) continue;
            arr.add((Object)new PropertyValue(props[i], val));
        }
        return (PropertyValue[])arr.trim();
    }

    public static PropertyValue[] makeKeys(BIOrionObject obj) {
        OrionType type = obj.getOrionType();
        Property[] keys = type.getKey();
        PropertyValue[] result = new PropertyValue[keys.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PropertyValue(keys[i], obj.get(keys[i]));
        }
        return result;
    }

    public PropertyValue(Property property, BValue value) {
        this.property = property;
        this.value = value;
        if (!value.getType().is(property.getType())) {
            throw new OrionException(value.getType() + " is not of type " + property.getType());
        }
    }

    public Property getProperty() {
        return this.property;
    }

    public BValue getValue() {
        return this.value;
    }

    public static String encodeValueToString(BValue value) throws IOException {
        if (value.isSimple()) {
            return ((BSimple)value).encodeToString();
        }
        if (value.isComplex()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ValueDocEncoder enc = new ValueDocEncoder((OutputStream)bytes);
            enc.encode(value);
            enc.flush();
            return BBlob.make((byte[])bytes.toByteArray()).encodeToString();
        }
        throw new OrionException(value.getType() + " is not supported.");
    }

    public static String encodeValueToString(BValue value, Context passwordContext, boolean isLegacyConnection) throws IOException {
        if (value.isSimple()) {
            BSimple val = (BSimple)value;
            if (val instanceof BIContextEncodable) {
                if (isLegacyConnection) {
                    BPassword passValue = (BPassword)val;
                    return LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)passValue).getValue()), (int)0);
                }
                return ((BIContextEncodable)val).encodeToString(passwordContext);
            }
            return ((BSimple)value).encodeToString();
        }
        if (value.isComplex()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ValueDocEncoder enc = new ValueDocEncoder((OutputStream)bytes);
            enc.encode(value);
            enc.flush();
            return BBlob.make((byte[])bytes.toByteArray()).encodeToString();
        }
        throw new OrionException(value.getType() + " is not supported.");
    }

    public static BValue decodeValueFromString(Type propertyType, String s) throws IOException, Exception {
        BObject i = propertyType.getInstance();
        if (i.isSimple()) {
            return (BValue)((BSimple)i).decodeFromString(s);
        }
        if (i.isComplex()) {
            BBlob blob = (BBlob)BBlob.DEFAULT.decodeFromString(s);
            ByteArrayInputStream bytes = new ByteArrayInputStream(blob.copyBytes());
            ValueDocDecoder dec = new ValueDocDecoder((InputStream)bytes);
            dec.next();
            return dec.decode();
        }
        throw new OrionException("Could not decode");
    }

    public static BValue decodeValueFromString(Type propertyType, String s, Context passwordContext, boolean isLegacyConnection) throws IOException, Exception {
        BObject i = propertyType.getInstance();
        if (i.isSimple()) {
            BSimple value = (BSimple)i;
            if (value instanceof BIContextEncodable && !isLegacyConnection) {
                return (BValue)((BIContextEncodable)value).decodeFromString(s, passwordContext);
            }
            return (BValue)((BSimple)i).decodeFromString(s);
        }
        if (i.isComplex()) {
            BBlob blob = (BBlob)BBlob.DEFAULT.decodeFromString(s);
            ByteArrayInputStream bytes = new ByteArrayInputStream(blob.copyBytes());
            ValueDocDecoder dec = new ValueDocDecoder((InputStream)bytes);
            dec.next();
            return dec.decode();
        }
        throw new OrionException("Could not decode");
    }
}

