/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.sys;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionRoot;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import javax.baja.space.LoadCallbacks;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class OrionLoadCallbacks
extends LoadCallbacks {
    public boolean isLazyLoad() {
        return true;
    }

    public void loadSlots(BComponent c) {
        if (c instanceof BOrionRoot) {
            BOrionSpace space = (BOrionSpace)c.getSpace();
            BOrionDatabase[] dbs = null;
            try {
                dbs = space.getOrionDatabases();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (int i = 0; i < dbs.length; ++i) {
                BFoxOrionDatabase db = (BFoxOrionDatabase)dbs[i];
                c.add(db.getId(), (BValue)dbs[i]);
            }
        } else if (c instanceof BOrionDatabase) {
            BOrionSpace space = (BOrionSpace)c.getSpace();
            BOrionModule[] modules = space.listModules((BOrionDatabase)c);
            for (int i = 0; i < modules.length; ++i) {
                c.add(modules[i].getModuleName(), (BValue)modules[i]);
            }
        } else if (c instanceof BOrionModule) {
            BOrionModule module = (BOrionModule)c;
            BOrionSpace space = (BOrionSpace)module.getSpace();
            BOrionDatabase db = module.getOrionDatabase();
            BOrionType[] types = space.listTypes(db, module);
            for (int i = 0; i < types.length; ++i) {
                module.add(types[i].getTypeName(), (BValue)types[i], Context.decoding);
            }
        } else {
            super.loadSlots(c);
        }
    }
}

